/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.Verify;

public class ApproximateStatsOutputRowCountMatcher
implements Matcher {
    private final double expectedOutputRowCount;
    private final double error;

    ApproximateStatsOutputRowCountMatcher(double expectedOutputRowCount, double error) {
        Verify.verify((error >= 0.0 ? 1 : 0) != 0, (String)"error must be >= 0.0", (Object[])new Object[0]);
        Verify.verify((expectedOutputRowCount >= 0.0 ? 1 : 0) != 0, (String)"expectedOutputRowCount must be >= 0.0", (Object[])new Object[0]);
        this.expectedOutputRowCount = expectedOutputRowCount;
        this.error = error;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return new MatchResult(Math.abs(stats.getStats(node).getOutputRowCount() - this.expectedOutputRowCount) < this.error);
    }

    public String toString() {
        return "approximateExpectedOutputRowCount(" + this.expectedOutputRowCount + ", " + this.error + ")";
    }
}

