/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.Preconditions;

public class LimitMatcher
implements Matcher {
    private final long limit;
    private final boolean partial;

    public LimitMatcher(long limit, boolean partial) {
        this.limit = limit;
        this.partial = partial;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof LimitNode)) {
            return false;
        }
        LimitNode limitNode = (LimitNode)node;
        return limitNode.getCount() == this.limit && limitNode.isPartial() == this.partial;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node));
        return MatchResult.match();
    }
}

