/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IndexSourceNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.MergeJoinNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.SpatialJoinNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.AggregationFunctionMatcher;
import com.facebook.presto.sql.planner.assertions.AggregationMatcher;
import com.facebook.presto.sql.planner.assertions.AggregationStepMatcher;
import com.facebook.presto.sql.planner.assertions.AliasMatcher;
import com.facebook.presto.sql.planner.assertions.AliasPresent;
import com.facebook.presto.sql.planner.assertions.AnySymbol;
import com.facebook.presto.sql.planner.assertions.ApproximateStatsOutputRowCountMatcher;
import com.facebook.presto.sql.planner.assertions.AssignUniqueIdMatcher;
import com.facebook.presto.sql.planner.assertions.ColumnReference;
import com.facebook.presto.sql.planner.assertions.CorrelationMatcher;
import com.facebook.presto.sql.planner.assertions.CteConsumerMatcher;
import com.facebook.presto.sql.planner.assertions.CteProducerMatcher;
import com.facebook.presto.sql.planner.assertions.DynamicFilterMatcher;
import com.facebook.presto.sql.planner.assertions.EquiJoinClauseProvider;
import com.facebook.presto.sql.planner.assertions.ExchangeMatcher;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.FilterMatcher;
import com.facebook.presto.sql.planner.assertions.FunctionCallProvider;
import com.facebook.presto.sql.planner.assertions.GroupIdMatcher;
import com.facebook.presto.sql.planner.assertions.IndexSourceMatcher;
import com.facebook.presto.sql.planner.assertions.JoinMatcher;
import com.facebook.presto.sql.planner.assertions.LimitMatcher;
import com.facebook.presto.sql.planner.assertions.MarkDistinctMatcher;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.MergeJoinMatcher;
import com.facebook.presto.sql.planner.assertions.NotPlanNodeMatcher;
import com.facebook.presto.sql.planner.assertions.OffsetMatcher;
import com.facebook.presto.sql.planner.assertions.OutputMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchingState;
import com.facebook.presto.sql.planner.assertions.PlanNodeMatcher;
import com.facebook.presto.sql.planner.assertions.PlanTestSymbol;
import com.facebook.presto.sql.planner.assertions.RemoteSourceMatcher;
import com.facebook.presto.sql.planner.assertions.RowNumberMatcher;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SemiJoinMatcher;
import com.facebook.presto.sql.planner.assertions.SortMatcher;
import com.facebook.presto.sql.planner.assertions.SpatialJoinMatcher;
import com.facebook.presto.sql.planner.assertions.SpecificationProvider;
import com.facebook.presto.sql.planner.assertions.StatsConfidenceLevelMatcher;
import com.facebook.presto.sql.planner.assertions.StatsJoinKeyCountMatcher;
import com.facebook.presto.sql.planner.assertions.StatsOutputRowCountMatcher;
import com.facebook.presto.sql.planner.assertions.StatsOutputSizeMatcher;
import com.facebook.presto.sql.planner.assertions.StatsSourceInfoMatcher;
import com.facebook.presto.sql.planner.assertions.StrictAssignedSymbolsMatcher;
import com.facebook.presto.sql.planner.assertions.StrictSymbolsMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.assertions.SymbolCardinalityMatcher;
import com.facebook.presto.sql.planner.assertions.TableScanMatcher;
import com.facebook.presto.sql.planner.assertions.TableWriterMatcher;
import com.facebook.presto.sql.planner.assertions.TopNMatcher;
import com.facebook.presto.sql.planner.assertions.TopNRowNumberMatcher;
import com.facebook.presto.sql.planner.assertions.UnnestMatcher;
import com.facebook.presto.sql.planner.assertions.ValuesMatcher;
import com.facebook.presto.sql.planner.assertions.WindowFrameProvider;
import com.facebook.presto.sql.planner.assertions.WindowMatcher;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public final class PlanMatchPattern {
    private final List<Matcher> matchers = new ArrayList<Matcher>();
    private final List<PlanMatchPattern> sourcePatterns;
    private boolean anyTree;

    public static PlanMatchPattern node(Class<? extends PlanNode> nodeClass, PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).with(new PlanNodeMatcher(nodeClass));
    }

    public static PlanMatchPattern any(PlanMatchPattern ... sources) {
        return new PlanMatchPattern((List<PlanMatchPattern>)ImmutableList.copyOf((Object[])sources));
    }

    public static PlanMatchPattern anyTree(PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).matchToAnyNodeTree();
    }

    public static PlanMatchPattern anyNot(Class<? extends PlanNode> excludeNodeClass, PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).with(new NotPlanNodeMatcher(excludeNodeClass));
    }

    public static PlanMatchPattern tableScan(String expectedTableName) {
        return TableScanMatcher.create(expectedTableName);
    }

    public static PlanMatchPattern tableScan(String expectedTableName, Map<String, String> columnReferences) {
        PlanMatchPattern result = PlanMatchPattern.tableScan(expectedTableName);
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern strictTableScan(String expectedTableName, Map<String, String> columnReferences) {
        return PlanMatchPattern.tableScan(expectedTableName, columnReferences).withExactAssignedOutputs((Collection)columnReferences.values().stream().map(columnName -> PlanMatchPattern.columnReference(expectedTableName, columnName)).collect(ImmutableList.toImmutableList()));
    }

    public static PlanMatchPattern constrainedTableScan(String expectedTableName, Map<String, Domain> constraint) {
        return TableScanMatcher.builder(expectedTableName).expectedConstraint(constraint).build();
    }

    public static PlanMatchPattern constrainedTableScan(String expectedTableName, Map<String, Domain> constraint, Map<String, String> columnReferences) {
        PlanMatchPattern result = PlanMatchPattern.constrainedTableScan(expectedTableName, constraint);
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern constrainedTableScanWithTableLayout(String expectedTableName, Map<String, Domain> constraint, Map<String, String> columnReferences) {
        PlanMatchPattern result = TableScanMatcher.builder(expectedTableName).expectedConstraint(constraint).hasTableLayout().build();
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern indexSource(String expectedTableName) {
        return PlanMatchPattern.node(IndexSourceNode.class, new PlanMatchPattern[0]).with(new IndexSourceMatcher(expectedTableName));
    }

    public static PlanMatchPattern constrainedIndexSource(String expectedTableName, Map<String, Domain> constraint, Map<String, String> columnReferences) {
        return PlanMatchPattern.node(IndexSourceNode.class, new PlanMatchPattern[0]).with(new IndexSourceMatcher(expectedTableName, constraint)).addColumnReferences(expectedTableName, columnReferences);
    }

    private PlanMatchPattern addColumnReferences(String expectedTableName, Map<String, String> columnReferences) {
        columnReferences.forEach((key, value) -> this.withAlias((String)key, PlanMatchPattern.columnReference(expectedTableName, value)));
        return this;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source);
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, AggregationNode.Step step, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source).with(new AggregationStepMatcher(step));
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(GroupingSetDescriptor groupingSets, Map<Optional<String>, ExpectedValueProvider<FunctionCall>> aggregations, Map<Symbol, Symbol> masks, Optional<Symbol> groupId, AggregationNode.Step step, PlanMatchPattern source) {
        return PlanMatchPattern.aggregation(groupingSets, aggregations, (List<String>)ImmutableList.of(), masks, groupId, step, source);
    }

    public static PlanMatchPattern aggregation(GroupingSetDescriptor groupingSets, Map<Optional<String>, ExpectedValueProvider<FunctionCall>> aggregations, List<String> preGroupedSymbols, Map<Symbol, Symbol> masks, Optional<Symbol> groupId, AggregationNode.Step step, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source);
        aggregations.entrySet().forEach(aggregation -> {
            if (((Optional)aggregation.getKey()).isPresent() && masks.containsKey(new Symbol((String)((Optional)aggregation.getKey()).get()))) {
                result.withAlias((Optional)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue(), (Symbol)masks.get(new Symbol((String)((Optional)aggregation.getKey()).get()))));
            } else {
                result.withAlias((Optional)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue()));
            }
        });
        result.with(new AggregationMatcher(groupingSets, preGroupedSymbols, masks, groupId, step));
        return result;
    }

    public static PlanMatchPattern markDistinct(String markerSymbol, List<String> distinctSymbols, PlanMatchPattern source) {
        return PlanMatchPattern.node(MarkDistinctNode.class, source).with(new MarkDistinctMatcher(new SymbolAlias(markerSymbol), PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.empty()));
    }

    public static PlanMatchPattern markDistinct(String markerSymbol, List<String> distinctSymbols, String hashSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.node(MarkDistinctNode.class, source).with(new MarkDistinctMatcher(new SymbolAlias(markerSymbol), PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.of(new SymbolAlias(hashSymbol))));
    }

    public static ExpectedValueProvider<WindowNode.Frame> windowFrame(WindowNode.Frame.WindowType type, WindowNode.Frame.BoundType startType, Optional<String> startValue, WindowNode.Frame.BoundType endType, Optional<String> endValue, Optional<String> sortKey) {
        return PlanMatchPattern.windowFrame(type, startType, startValue, Optional.empty(), sortKey, Optional.empty(), endType, endValue, Optional.empty(), sortKey, Optional.empty());
    }

    public static ExpectedValueProvider<WindowNode.Frame> windowFrame(WindowNode.Frame.WindowType type, WindowNode.Frame.BoundType startType, Optional<String> startValue, Optional<Type> startValueType, Optional<String> sortKeyForStartComparison, Optional<Type> sortKeyForStartComparisonType, WindowNode.Frame.BoundType endType, Optional<String> endValue, Optional<Type> endValueType, Optional<String> sortKeyForEndComparison, Optional<Type> sortKeyForEndComparisonType) {
        return new WindowFrameProvider(type, startType, startValue.map(SymbolAlias::new), startValueType, sortKeyForStartComparison.map(SymbolAlias::new), sortKeyForStartComparisonType, endType, endValue.map(SymbolAlias::new), endValueType, sortKeyForEndComparison.map(SymbolAlias::new), sortKeyForEndComparisonType);
    }

    public static PlanMatchPattern window(Consumer<WindowMatcher.Builder> windowMatcherBuilderConsumer, PlanMatchPattern source) {
        WindowMatcher.Builder windowMatcherBuilder = new WindowMatcher.Builder(source);
        windowMatcherBuilderConsumer.accept(windowMatcherBuilder);
        return windowMatcherBuilder.build();
    }

    public static PlanMatchPattern rowNumber(Consumer<RowNumberMatcher.Builder> rowNumberMatcherBuilderConsumer, PlanMatchPattern source) {
        RowNumberMatcher.Builder rowNumberMatcherBuilder = new RowNumberMatcher.Builder(source);
        rowNumberMatcherBuilderConsumer.accept(rowNumberMatcherBuilder);
        return rowNumberMatcherBuilder.build();
    }

    public static PlanMatchPattern topNRowNumber(Consumer<TopNRowNumberMatcher.Builder> topNRowNumberMatcherBuilderConsumer, PlanMatchPattern source) {
        TopNRowNumberMatcher.Builder topNRowNumberMatcherBuilder = new TopNRowNumberMatcher.Builder(source);
        topNRowNumberMatcherBuilderConsumer.accept(topNRowNumberMatcherBuilder);
        return topNRowNumberMatcherBuilder.build();
    }

    public static PlanMatchPattern sort(PlanMatchPattern source) {
        return PlanMatchPattern.node(SortNode.class, source);
    }

    public static PlanMatchPattern sort(List<Ordering> orderBy, PlanMatchPattern source) {
        return PlanMatchPattern.node(SortNode.class, source).with(new SortMatcher(orderBy));
    }

    public static PlanMatchPattern topN(long count, List<Ordering> orderBy, PlanMatchPattern source) {
        return PlanMatchPattern.node(TopNNode.class, source).with(new TopNMatcher(count, orderBy));
    }

    public static PlanMatchPattern output(PlanMatchPattern source) {
        return PlanMatchPattern.node(OutputNode.class, source);
    }

    public static PlanMatchPattern output(List<String> outputs, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.output(source);
        result.withOutputs(outputs);
        return result;
    }

    public static PlanMatchPattern strictOutput(List<String> outputs, PlanMatchPattern source) {
        return PlanMatchPattern.output(outputs, source).withExactOutputs(outputs);
    }

    public static PlanMatchPattern project(PlanMatchPattern source) {
        return PlanMatchPattern.node(ProjectNode.class, source);
    }

    public static PlanMatchPattern project(Map<String, ExpressionMatcher> assignments, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.project(source);
        assignments.entrySet().forEach(assignment -> result.withAlias((String)assignment.getKey(), (RvalueMatcher)assignment.getValue()));
        return result;
    }

    public static PlanMatchPattern strictProject(Map<String, ExpressionMatcher> assignments, PlanMatchPattern source) {
        return PlanMatchPattern.project(assignments, source).withExactAssignedOutputs(assignments.values()).withExactAssignments(assignments.values());
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.semiJoin(sourceSymbolAlias, filteringSymbolAlias, outputAlias, Optional.empty(), source, filtering);
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, Optional<SemiJoinNode.DistributionType> distributionType, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.node(SemiJoinNode.class, source, filtering).with(new SemiJoinMatcher(sourceSymbolAlias, filteringSymbolAlias, outputAlias, distributionType));
    }

    public static PlanMatchPattern join(PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(JoinNode.class, left, right);
    }

    public static PlanMatchPattern join(JoinType joinType, List<ExpectedValueProvider<EquiJoinClause>> expectedEquiCriteria, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.join(joinType, expectedEquiCriteria, Optional.empty(), left, right);
    }

    public static PlanMatchPattern join(JoinType joinType, List<ExpectedValueProvider<EquiJoinClause>> expectedEquiCriteria, Optional<String> expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.join(joinType, expectedEquiCriteria, expectedFilter, Optional.empty(), left, right);
    }

    public static PlanMatchPattern join(JoinType joinType, List<ExpectedValueProvider<EquiJoinClause>> expectedEquiCriteria, Optional<String> expectedFilter, Optional<JoinDistributionType> expectedDistributionType, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(JoinNode.class, left, right).with(new JoinMatcher(joinType, expectedEquiCriteria, expectedFilter.map(predicate -> ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(predicate))), expectedDistributionType, Optional.empty()));
    }

    public static PlanMatchPattern join(JoinType joinType, List<ExpectedValueProvider<EquiJoinClause>> expectedEquiCriteria, Map<String, String> expectedDynamicFilter, Optional<String> expectedStaticFilter, PlanMatchPattern leftSource, PlanMatchPattern right) {
        Map expectedDynamicFilterAliases = (Map)expectedDynamicFilter.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new SymbolAlias((String)entry.getKey()), entry -> new SymbolAlias((String)entry.getValue())));
        DynamicFilterMatcher dynamicFilterMatcher = new DynamicFilterMatcher(expectedDynamicFilterAliases, expectedStaticFilter.map(predicate -> ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(predicate))));
        JoinMatcher joinMatcher = new JoinMatcher(joinType, expectedEquiCriteria, Optional.empty(), Optional.empty(), Optional.of(dynamicFilterMatcher));
        return PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, leftSource).with(dynamicFilterMatcher)), right).with(joinMatcher);
    }

    public static PlanMatchPattern indexJoin(PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(IndexJoinNode.class, left, right);
    }

    public static PlanMatchPattern cteConsumer(String cteName) {
        CteConsumerMatcher cteConsumerMatcher = new CteConsumerMatcher(cteName);
        return PlanMatchPattern.node(CteConsumerNode.class, new PlanMatchPattern[0]).with(cteConsumerMatcher);
    }

    public static PlanMatchPattern cteProducer(String cteName, PlanMatchPattern source) {
        CteProducerMatcher cteProducerMatcher = new CteProducerMatcher(cteName);
        return PlanMatchPattern.node(CteProducerNode.class, source).with(cteProducerMatcher);
    }

    public static PlanMatchPattern sequence(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(SequenceNode.class, sources);
    }

    public static PlanMatchPattern spatialJoin(String expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.spatialJoin(expectedFilter, Optional.empty(), left, right);
    }

    public static PlanMatchPattern spatialJoin(String expectedFilter, Optional<String> kdbTree, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(SpatialJoinNode.class, left, right).with(new SpatialJoinMatcher(SpatialJoinNode.Type.INNER, ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expectedFilter, new ParsingOptions())), kdbTree));
    }

    public static PlanMatchPattern spatialLeftJoin(String expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(SpatialJoinNode.class, left, right).with(new SpatialJoinMatcher(SpatialJoinNode.Type.LEFT, ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expectedFilter, new ParsingOptions())), Optional.empty()));
    }

    public static PlanMatchPattern mergeJoin(JoinType joinType, List<ExpectedValueProvider<EquiJoinClause>> expectedEquiCriteria, Optional<Expression> filter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(MergeJoinNode.class, left, right).with(new MergeJoinMatcher(joinType, expectedEquiCriteria, filter));
    }

    public static PlanMatchPattern unnest(PlanMatchPattern source) {
        return PlanMatchPattern.node(UnnestNode.class, source);
    }

    public static PlanMatchPattern unnest(Map<String, List<String>> unnestVariables, PlanMatchPattern source) {
        return PlanMatchPattern.node(UnnestNode.class, source).with(new UnnestMatcher(unnestVariables));
    }

    public static PlanMatchPattern exchange(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExchangeNode.class, sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, (List<Ordering>)ImmutableList.of(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, orderBy, (Set<String>)ImmutableSet.of(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, Set<String> partitionedBy, PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExchangeNode.class, sources).with(new ExchangeMatcher(scope, type, orderBy, partitionedBy));
    }

    public static PlanMatchPattern union(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(UnionNode.class, sources);
    }

    public static PlanMatchPattern assignUniqueId(String uniqueSymbolAlias, PlanMatchPattern source) {
        return PlanMatchPattern.node(AssignUniqueId.class, source).withAlias(uniqueSymbolAlias, (RvalueMatcher)new AssignUniqueIdMatcher());
    }

    public static PlanMatchPattern intersect(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(IntersectNode.class, sources);
    }

    public static PlanMatchPattern except(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExceptNode.class, sources);
    }

    public static ExpectedValueProvider<EquiJoinClause> equiJoinClause(String left, String right) {
        return new EquiJoinClauseProvider(new SymbolAlias(left), new SymbolAlias(right));
    }

    public static SymbolAlias symbol(String alias) {
        return new SymbolAlias(alias);
    }

    public static PlanMatchPattern filter(String expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.filter(ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expectedPredicate)), source);
    }

    public static PlanMatchPattern filterWithDecimal(String expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.filter(ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expectedPredicate, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL))), source);
    }

    public static PlanMatchPattern filter(Expression expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.node(FilterNode.class, source).with(new FilterMatcher(expectedPredicate));
    }

    public static PlanMatchPattern filter(PlanMatchPattern source) {
        return PlanMatchPattern.node(FilterNode.class, source);
    }

    public static PlanMatchPattern apply(List<String> correlationSymbolAliases, Map<String, ExpressionMatcher> subqueryAssignments, PlanMatchPattern inputPattern, PlanMatchPattern subqueryPattern) {
        PlanMatchPattern result = PlanMatchPattern.node(ApplyNode.class, inputPattern, subqueryPattern).with(new CorrelationMatcher(correlationSymbolAliases));
        subqueryAssignments.entrySet().forEach(assignment -> result.withAlias((String)assignment.getKey(), (RvalueMatcher)assignment.getValue()));
        return result;
    }

    public static PlanMatchPattern lateral(List<String> correlationSymbolAliases, PlanMatchPattern inputPattern, PlanMatchPattern subqueryPattern) {
        return PlanMatchPattern.node(LateralJoinNode.class, inputPattern, subqueryPattern).with(new CorrelationMatcher(correlationSymbolAliases));
    }

    public static PlanMatchPattern groupingSet(List<List<String>> groups, Map<String, String> identityMappings, String groupIdAlias, PlanMatchPattern source) {
        return PlanMatchPattern.node(GroupIdNode.class, source).with(new GroupIdMatcher(groups, identityMappings, groupIdAlias));
    }

    public static PlanMatchPattern groupingSet(List<List<String>> groups, Map<String, String> identityMappings, String groupIdAlias, Map<String, ExpressionMatcher> groupingColumns, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(GroupIdNode.class, source).with(new GroupIdMatcher(groups, identityMappings, groupIdAlias));
        groupingColumns.entrySet().forEach(groupingColumn -> result.withAlias((String)groupingColumn.getKey(), (RvalueMatcher)groupingColumn.getValue()));
        return result;
    }

    private static PlanMatchPattern values(Map<String, Integer> aliasToIndex, Optional<Integer> expectedOutputSymbolCount, Optional<List<List<Expression>>> expectedRows) {
        return PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]).with(new ValuesMatcher(aliasToIndex, expectedOutputSymbolCount, expectedRows));
    }

    private static PlanMatchPattern values(List<String> aliases, Optional<List<List<Expression>>> expectedRows) {
        return PlanMatchPattern.values((Map<String, Integer>)Maps.uniqueIndex(IntStream.range(0, aliases.size()).boxed().iterator(), aliases::get), Optional.of(aliases.size()), expectedRows);
    }

    public static PlanMatchPattern values(Map<String, Integer> aliasToIndex) {
        return PlanMatchPattern.values(aliasToIndex, Optional.empty(), Optional.empty());
    }

    public static PlanMatchPattern values(String ... aliases) {
        return PlanMatchPattern.values((List<String>)ImmutableList.copyOf((Object[])aliases));
    }

    public static PlanMatchPattern values(List<String> aliases, List<List<Expression>> expectedRows) {
        return PlanMatchPattern.values(aliases, Optional.of(expectedRows));
    }

    public static PlanMatchPattern values(List<String> aliases) {
        return PlanMatchPattern.values(aliases, Optional.empty());
    }

    public static PlanMatchPattern offset(long rowCount, PlanMatchPattern source) {
        return PlanMatchPattern.node(OffsetNode.class, source).with(new OffsetMatcher(rowCount));
    }

    public static PlanMatchPattern limit(long limit, PlanMatchPattern source) {
        return PlanMatchPattern.limit(limit, false, source);
    }

    public static PlanMatchPattern limit(long limit, boolean partial, PlanMatchPattern source) {
        return PlanMatchPattern.node(LimitNode.class, source).with(new LimitMatcher(limit, partial));
    }

    public static PlanMatchPattern enforceSingleRow(PlanMatchPattern source) {
        return PlanMatchPattern.node(EnforceSingleRowNode.class, source);
    }

    public static PlanMatchPattern tableWriter(List<String> columns, List<String> columnNames, PlanMatchPattern source) {
        return PlanMatchPattern.node(TableWriterNode.class, source).with(new TableWriterMatcher(columns, columnNames));
    }

    public static PlanMatchPattern remoteSource(List<PlanFragmentId> sourceFragmentIds, Map<String, Integer> outputSymbolAliases) {
        return PlanMatchPattern.node(RemoteSourceNode.class, new PlanMatchPattern[0]).with(new RemoteSourceMatcher(sourceFragmentIds, outputSymbolAliases));
    }

    public PlanMatchPattern(List<PlanMatchPattern> sourcePatterns) {
        Objects.requireNonNull(sourcePatterns, "sourcePatterns are null");
        this.sourcePatterns = ImmutableList.copyOf(sourcePatterns);
    }

    List<PlanMatchingState> shapeMatches(PlanNode node) {
        ImmutableList.Builder states = ImmutableList.builder();
        if (this.anyTree) {
            int sourcesCount = node.getSources().size();
            if (sourcesCount > 1) {
                states.add((Object)new PlanMatchingState(Collections.nCopies(sourcesCount, this)));
            } else {
                states.add((Object)new PlanMatchingState((List<PlanMatchPattern>)ImmutableList.of((Object)this)));
            }
        }
        if (node instanceof GroupReference) {
            if (this.sourcePatterns.isEmpty() && this.shapeMatchesMatchers(node)) {
                states.add((Object)new PlanMatchingState((List<PlanMatchPattern>)ImmutableList.of()));
            }
        } else if (node.getSources().size() == this.sourcePatterns.size() && this.shapeMatchesMatchers(node)) {
            states.add((Object)new PlanMatchingState(this.sourcePatterns));
        }
        return states.build();
    }

    private boolean shapeMatchesMatchers(PlanNode node) {
        return this.matchers.stream().allMatch(it -> it.shapeMatches(node));
    }

    MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        SymbolAliases.Builder newAliases = SymbolAliases.builder();
        for (Matcher matcher : this.matchers) {
            MatchResult matchResult = matcher instanceof AggregationMatcher ? matcher.detailMatches(node, stats, session, metadata, symbolAliases.withNewAliases(newAliases.build())) : matcher.detailMatches(node, stats, session, metadata, symbolAliases);
            if (!matchResult.isMatch()) {
                return MatchResult.NO_MATCH;
            }
            newAliases.putAll(matchResult.getAliases());
        }
        return MatchResult.match(newAliases.build());
    }

    public PlanMatchPattern with(Matcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public PlanMatchPattern withAlias(String alias) {
        return this.withAlias(Optional.of(alias), (RvalueMatcher)new AliasPresent(alias));
    }

    public PlanMatchPattern withAlias(String alias, RvalueMatcher matcher) {
        return this.withAlias(Optional.of(alias), matcher);
    }

    public PlanMatchPattern withAlias(Optional<String> alias, RvalueMatcher matcher) {
        this.matchers.add(new AliasMatcher(alias, matcher));
        return this;
    }

    public PlanMatchPattern withNumberOfOutputColumns(int numberOfSymbols) {
        this.matchers.add(new SymbolCardinalityMatcher(numberOfSymbols));
        return this;
    }

    public PlanMatchPattern withExactOutputs(String ... expectedAliases) {
        return this.withExactOutputs((List<String>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactOutputs(List<String> expectedAliases) {
        this.matchers.add(new StrictSymbolsMatcher(StrictSymbolsMatcher.actualOutputs(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withExactAssignedOutputs(RvalueMatcher ... expectedAliases) {
        return this.withExactAssignedOutputs((Collection<? extends RvalueMatcher>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactAssignedOutputs(Collection<? extends RvalueMatcher> expectedAliases) {
        this.matchers.add(new StrictAssignedSymbolsMatcher(StrictSymbolsMatcher.actualOutputs(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withExactAssignments(Collection<? extends RvalueMatcher> expectedAliases) {
        this.matchers.add(new StrictAssignedSymbolsMatcher(StrictAssignedSymbolsMatcher.actualAssignments(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withOutputRowCount(double expectedOutputRowCount) {
        this.matchers.add(new StatsOutputRowCountMatcher(expectedOutputRowCount));
        return this;
    }

    public PlanMatchPattern withSourceInfo(SourceInfo sourceInfo) {
        this.matchers.add(new StatsSourceInfoMatcher(sourceInfo));
        return this;
    }

    public PlanMatchPattern withConfidenceLevel(SourceInfo.ConfidenceLevel confidenceLevel) {
        this.matchers.add(new StatsConfidenceLevelMatcher(confidenceLevel));
        return this;
    }

    public PlanMatchPattern withOutputRowCount(double expectedOutputRowCount, String expectedSourceInfo) {
        this.matchers.add(new StatsOutputRowCountMatcher(expectedOutputRowCount, expectedSourceInfo));
        return this;
    }

    public PlanMatchPattern withOutputRowCount(boolean exactMatch, String expectedSourceInfo) {
        this.matchers.add(new StatsOutputRowCountMatcher(exactMatch, expectedSourceInfo));
        return this;
    }

    public PlanMatchPattern withApproximateOutputRowCount(double expectedOutputRowCount, double error) {
        this.matchers.add(new ApproximateStatsOutputRowCountMatcher(expectedOutputRowCount, error));
        return this;
    }

    public PlanMatchPattern withOutputSize(double expectedOutputSize) {
        this.matchers.add(new StatsOutputSizeMatcher(expectedOutputSize));
        return this;
    }

    public PlanMatchPattern withJoinStatistics(double expectedJoinBuildKeyCount, double expectedNullJoinBuildKeyCount, double expectedJoinProbeKeyCount, double expectedNullJoinProbeKeyCount) {
        this.matchers.add(new StatsJoinKeyCountMatcher(expectedJoinBuildKeyCount, expectedNullJoinBuildKeyCount, expectedJoinProbeKeyCount, expectedNullJoinProbeKeyCount));
        return this;
    }

    public static RvalueMatcher columnReference(String tableName, String columnName) {
        return new ColumnReference(tableName, columnName);
    }

    public static ExpressionMatcher expression(String expression) {
        return new ExpressionMatcher(expression);
    }

    public static ExpressionMatcher expression(String expression, ParsingOptions.DecimalLiteralTreatment decimalLiteralTreatment) {
        return new ExpressionMatcher(expression, decimalLiteralTreatment);
    }

    public static ExpressionMatcher expression(Expression expression) {
        return new ExpressionMatcher(expression);
    }

    public PlanMatchPattern withOutputs(String ... aliases) {
        return this.withOutputs((List<String>)ImmutableList.copyOf((Object[])aliases));
    }

    public PlanMatchPattern withOutputs(List<String> aliases) {
        this.matchers.add(new OutputMatcher(aliases));
        return this;
    }

    public PlanMatchPattern matchToAnyNodeTree() {
        this.anyTree = true;
        return this;
    }

    public boolean isTerminated() {
        return this.sourcePatterns.isEmpty();
    }

    public static PlanTestSymbol anySymbol() {
        return new AnySymbol();
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, List<String> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), PlanMatchPattern.toSymbolAliases(args));
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, List<String> args, List<Ordering> orderBy) {
        return new FunctionCallProvider(QualifiedName.of((String)name), PlanMatchPattern.toSymbolAliases(args), orderBy);
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, Optional<WindowFrame> frame, List<String> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), frame, false, PlanMatchPattern.toSymbolAliases(args));
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, boolean distinct, List<PlanTestSymbol> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), distinct, args);
    }

    public static List<Expression> toSymbolReferences(List<PlanTestSymbol> aliases, SymbolAliases symbolAliases) {
        return (List)aliases.stream().map(arg -> arg.toSymbol(symbolAliases).toSymbolReference()).collect(ImmutableList.toImmutableList());
    }

    private static List<PlanTestSymbol> toSymbolAliases(List<String> aliases) {
        return (List)aliases.stream().map(PlanMatchPattern::symbol).collect(ImmutableList.toImmutableList());
    }

    public static ExpectedValueProvider<DataOrganizationSpecification> specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
        return new SpecificationProvider((List)partitionBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()), (List)orderBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()), (Map)orderings.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new SymbolAlias((String)entry.getKey()), Map.Entry::getValue)));
    }

    public static Ordering sort(String field, SortItem.Ordering ordering, SortItem.NullOrdering nullOrdering) {
        return new Ordering(field, ordering, nullOrdering);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0);
        return builder.toString();
    }

    private void toString(StringBuilder builder, int indent) {
        Preconditions.checkState((this.matchers.stream().filter(PlanNodeMatcher.class::isInstance).count() <= 1L ? 1 : 0) != 0);
        builder.append(PlanMatchPattern.indentString(indent)).append("- ");
        if (this.anyTree) {
            builder.append("anyTree");
        } else {
            builder.append("node");
        }
        Optional<PlanNodeMatcher> planNodeMatcher = this.matchers.stream().filter(PlanNodeMatcher.class::isInstance).map(PlanNodeMatcher.class::cast).findFirst();
        if (planNodeMatcher.isPresent()) {
            builder.append("(").append(planNodeMatcher.get().getNodeClass().getSimpleName()).append(")");
        }
        builder.append("\n");
        List matchersToPrint = (List)this.matchers.stream().filter(matcher -> !(matcher instanceof PlanNodeMatcher)).collect(ImmutableList.toImmutableList());
        for (Matcher matcher2 : matchersToPrint) {
            builder.append(PlanMatchPattern.indentString(indent + 1)).append(matcher2.toString()).append("\n");
        }
        for (PlanMatchPattern pattern : this.sourcePatterns) {
            pattern.toString(builder, indent + 1);
        }
    }

    private static String indentString(int indent) {
        return Strings.repeat((String)"    ", (int)indent);
    }

    public static GroupingSetDescriptor globalAggregation() {
        return PlanMatchPattern.singleGroupingSet(new String[0]);
    }

    public static GroupingSetDescriptor singleGroupingSet(String ... groupingKeys) {
        return PlanMatchPattern.singleGroupingSet((List<String>)ImmutableList.copyOf((Object[])groupingKeys));
    }

    public static GroupingSetDescriptor singleGroupingSet(List<String> groupingKeys) {
        ImmutableSet globalGroupingSets = groupingKeys.isEmpty() ? ImmutableSet.of((Object)0) : ImmutableSet.of();
        return new GroupingSetDescriptor(groupingKeys, 1, (Set<Integer>)globalGroupingSets);
    }

    public static class GroupingSetDescriptor {
        private final List<String> groupingKeys;
        private final int groupingSetCount;
        private final Set<Integer> globalGroupingSets;

        public GroupingSetDescriptor(List<String> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
            this.groupingKeys = groupingKeys;
            this.groupingSetCount = groupingSetCount;
            this.globalGroupingSets = globalGroupingSets;
        }

        public List<String> getGroupingKeys() {
            return this.groupingKeys;
        }

        public int getGroupingSetCount() {
            return this.groupingSetCount;
        }

        public Set<Integer> getGlobalGroupingSets() {
            return this.globalGroupingSets;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("keys", this.groupingKeys).add("count", this.groupingSetCount).add("globalSets", this.globalGroupingSets).toString();
        }
    }

    public static class Ordering {
        private final String field;
        private final SortItem.Ordering ordering;
        private final SortItem.NullOrdering nullOrdering;

        private Ordering(String field, SortItem.Ordering ordering, SortItem.NullOrdering nullOrdering) {
            this.field = field;
            this.ordering = ordering;
            this.nullOrdering = nullOrdering;
        }

        public String getField() {
            return this.field;
        }

        public SortItem.Ordering getOrdering() {
            return this.ordering;
        }

        public SortItem.NullOrdering getNullOrdering() {
            return this.nullOrdering;
        }

        public SortOrder getSortOrder() {
            Preconditions.checkState((this.nullOrdering != SortItem.NullOrdering.UNDEFINED ? 1 : 0) != 0, (Object)"nullOrdering is undefined");
            if (this.ordering == SortItem.Ordering.ASCENDING) {
                if (this.nullOrdering == SortItem.NullOrdering.FIRST) {
                    return SortOrder.ASC_NULLS_FIRST;
                }
                return SortOrder.ASC_NULLS_LAST;
            }
            Preconditions.checkState((this.ordering == SortItem.Ordering.DESCENDING ? 1 : 0) != 0);
            if (this.nullOrdering == SortItem.NullOrdering.FIRST) {
                return SortOrder.DESC_NULLS_FIRST;
            }
            return SortOrder.DESC_NULLS_LAST;
        }

        public String toString() {
            String result = this.field + " " + this.ordering;
            if (this.nullOrdering != SortItem.NullOrdering.UNDEFINED) {
                result = result + " NULLS " + this.nullOrdering;
            }
            return result;
        }
    }
}

