/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowNumberMatcher
implements Matcher {
    private final Optional<List<SymbolAlias>> partitionBy;
    private final Optional<Optional<Integer>> maxRowCountPerPartition;
    private final Optional<SymbolAlias> rowNumberSymbol;
    private final Optional<Optional<SymbolAlias>> hashSymbol;

    private RowNumberMatcher(Optional<List<SymbolAlias>> partitionBy, Optional<Optional<Integer>> maxRowCountPerPartition, Optional<SymbolAlias> rowNumberSymbol, Optional<Optional<SymbolAlias>> hashSymbol) {
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.maxRowCountPerPartition = Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null");
        this.rowNumberSymbol = Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashVariable is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof RowNumberNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        RowNumberNode rowNumberNode = (RowNumberNode)node;
        if (!this.partitionBy.map(expectedPartitionBy -> ((ImmutableList)expectedPartitionBy.stream().map(alias -> alias.toSymbol(symbolAliases)).map(Symbol::getName).collect(ImmutableList.toImmutableList())).equals(rowNumberNode.getPartitionBy().stream().map(VariableReferenceExpression::getName).collect(ImmutableList.toImmutableList()))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.maxRowCountPerPartition.map(expectedMaxRowCountPerPartition -> expectedMaxRowCountPerPartition.equals(rowNumberNode.getMaxRowCountPerPartition())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.rowNumberSymbol.map(expectedRowNumberSymbol -> expectedRowNumberSymbol.toSymbol(symbolAliases).getName().equals(rowNumberNode.getRowNumberVariable().getName())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.hashSymbol.map(expectedHashSymbol -> expectedHashSymbol.map(symbolAlias -> symbolAlias.toSymbol(symbolAliases)).map(Symbol::getName).equals(rowNumberNode.getHashVariable().map(VariableReferenceExpression::getName))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionBy", this.partitionBy).add("maxRowCountPerPartition", this.maxRowCountPerPartition).add("rowNumberSymbol", this.rowNumberSymbol).add("hashSymbol", this.hashSymbol).toString();
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<List<SymbolAlias>> partitionBy = Optional.empty();
        private Optional<Optional<Integer>> maxRowCountPerPartition = Optional.empty();
        private Optional<SymbolAlias> rowNumberSymbol = Optional.empty();
        private Optional<Optional<SymbolAlias>> hashSymbol = Optional.empty();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder partitionBy(List<String> partitionBy) {
            Objects.requireNonNull(partitionBy, "partitionBy is null");
            this.partitionBy = Optional.of((List)partitionBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()));
            return this;
        }

        public Builder maxRowCountPerPartition(Optional<Integer> maxRowCountPerPartition) {
            this.maxRowCountPerPartition = Optional.of(Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null"));
            return this;
        }

        public Builder rowNumberSymbol(SymbolAlias rowNumberSymbol) {
            this.rowNumberSymbol = Optional.of(Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null"));
            return this;
        }

        public Builder hashSymbol(Optional<SymbolAlias> hashSymbol) {
            this.hashSymbol = Optional.of(Objects.requireNonNull(hashSymbol, "hashSymbol is null"));
            return this;
        }

        PlanMatchPattern build() {
            return PlanMatchPattern.node(RowNumberNode.class, this.source).with(new RowNumberMatcher(this.partitionBy, this.maxRowCountPerPartition, this.rowNumberSymbol, this.hashSymbol));
        }
    }
}

