/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.BaseStrictSymbolsMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class StrictSymbolsMatcher
extends BaseStrictSymbolsMatcher {
    private final List<String> expectedAliases;

    public StrictSymbolsMatcher(Function<PlanNode, Set<VariableReferenceExpression>> getActual, List<String> expectedAliases) {
        super(getActual);
        this.expectedAliases = Objects.requireNonNull(expectedAliases, "expectedAliases is null");
    }

    @Override
    protected Set<VariableReferenceExpression> getExpectedVariables(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return (Set)this.expectedAliases.stream().map(symbolAliases::get).map(symbolReference -> new VariableReferenceExpression(Optional.empty(), symbolReference.getName(), (Type)UnknownType.UNKNOWN)).collect(ImmutableSet.toImmutableSet());
    }

    public static Function<PlanNode, Set<VariableReferenceExpression>> actualOutputs() {
        return node -> ImmutableSet.copyOf((Collection)node.getOutputVariables());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exact outputs", this.expectedAliases).toString();
    }
}

