/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.RowExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionVerifier {
    private final SqlParser parser = new SqlParser();
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final TestingRowExpressionTranslator translator = new TestingRowExpressionTranslator(this.metadata);

    @Test
    public void test() {
        Expression actual = this.expression("NOT(orderkey = 3 AND custkey = 3 AND orderkey < 10)");
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        RowExpressionVerifier rowExpressionVerifier = new RowExpressionVerifier(symbolAliases, this.metadata, SessionTestUtils.TEST_SESSION);
        Assert.assertTrue((boolean)this.process(actual, this.expression("NOT(X = 3 AND Y = 3 AND X < 10)"), symbolAliases, this.metadata));
        TestExpressionVerifier.assertThrows(() -> verifier.process((Node)actual, this.expression("NOT(X = 3 AND Y = 3 AND Z < 10)")));
        TestExpressionVerifier.assertThrows(() -> rowExpressionVerifier.process((Node)this.expression("NOT(X = 3 AND Y = 3 AND Z < 10)"), this.translate(actual)));
        Assert.assertFalse((boolean)this.process(actual, this.expression("NOT(X = 3 AND X = 3 AND X < 10)"), symbolAliases, this.metadata));
    }

    @Test
    public void testCast() {
        SymbolAliases aliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).build();
        Assert.assertTrue((boolean)this.process(this.expression("CAST('2' AS varchar)"), this.expression("CAST('2' AS varchar)"), aliases, this.metadata));
        Assert.assertFalse((boolean)this.process(this.expression("CAST('2' AS varchar)"), this.expression("CAST('2' AS bigint)"), aliases, this.metadata));
        Assert.assertTrue((boolean)this.process(this.expression("CAST(orderkey AS varchar)"), this.expression("CAST(X AS varchar)"), aliases, this.metadata));
    }

    @Test
    public void testBetween() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        Assert.assertTrue((boolean)this.process(this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 1 AND 2"), symbolAliases, this.metadata));
        Assert.assertFalse((boolean)this.process(this.expression("orderkey BETWEEN 1 AND 2"), this.expression("Y BETWEEN 1 AND 2"), symbolAliases, this.metadata));
        Assert.assertFalse((boolean)this.process(this.expression("custkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 1 AND 2"), symbolAliases, this.metadata));
        Assert.assertFalse((boolean)this.process(this.expression("orderkey BETWEEN 2 AND 4"), this.expression("X BETWEEN 1 AND 2"), symbolAliases, this.metadata));
        Assert.assertFalse((boolean)this.process(this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN '1' AND '2'"), symbolAliases, this.metadata));
        Assert.assertFalse((boolean)this.process(this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 4 AND 7"), symbolAliases, this.metadata));
    }

    private boolean process(Expression actual, Expression expected, SymbolAliases aliases, Metadata metadata) {
        ExpressionVerifier expressionVerifier = new ExpressionVerifier(aliases);
        RowExpressionVerifier rowExpressionVerifier = new RowExpressionVerifier(aliases, metadata, SessionTestUtils.TEST_SESSION);
        boolean expressionResult = (Boolean)expressionVerifier.process((Node)actual, expected);
        boolean rowExpressionResult = (Boolean)rowExpressionVerifier.process((Node)expected, this.translate(actual));
        Assert.assertEquals((boolean)expressionResult, (boolean)rowExpressionResult);
        return expressionResult;
    }

    private Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)this.parser.createExpression(sql));
    }

    private static void assertThrows(Runnable runnable) {
        try {
            runnable.run();
            throw new AssertionError((Object)"Method didn't throw exception as expected");
        }
        catch (Exception exception) {
            return;
        }
    }

    private RowExpression translate(Expression expression) {
        return this.translator.translate(expression, TypeProvider.viewOf((Map)ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"custkey", (Object)BigintType.BIGINT)));
    }
}

