/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SpecificationProvider;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TopNRowNumberMatcher
implements Matcher {
    private final Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification;
    private final Optional<SymbolAlias> rowNumberSymbol;
    private final Optional<Integer> maxRowCountPerPartition;
    private final Optional<Boolean> partial;
    private final Optional<Optional<SymbolAlias>> hashSymbol;

    private TopNRowNumberMatcher(Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification, Optional<SymbolAlias> rowNumberSymbol, Optional<Integer> maxRowCountPerPartition, Optional<Boolean> partial, Optional<Optional<SymbolAlias>> hashSymbol) {
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.rowNumberSymbol = Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null");
        this.maxRowCountPerPartition = Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null");
        this.partial = Objects.requireNonNull(partial, "partial is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashVariable is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TopNRowNumberNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TopNRowNumberNode topNRowNumberNode = (TopNRowNumberNode)node;
        if (!this.specification.map(expectedSpecification -> SpecificationProvider.matchSpecification(topNRowNumberNode.getSpecification(), (DataOrganizationSpecification)expectedSpecification.getExpectedValue(symbolAliases))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.rowNumberSymbol.map(expectedRowNumberSymbol -> expectedRowNumberSymbol.toSymbol(symbolAliases).getName().equals(topNRowNumberNode.getRowNumberVariable().getName())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.maxRowCountPerPartition.map(expectedMaxRowCountPerPartition -> expectedMaxRowCountPerPartition.equals(topNRowNumberNode.getMaxRowCountPerPartition())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.partial.map(expectedPartial -> expectedPartial.equals(topNRowNumberNode.isPartial())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.hashSymbol.map(expectedHashSymbol -> expectedHashSymbol.map(symbolAlias -> symbolAlias.toSymbol(symbolAliases)).map(Symbol::getName).equals(topNRowNumberNode.getHashVariable().map(VariableReferenceExpression::getName))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("specification", this.specification).add("rowNumberSymbol", this.rowNumberSymbol).add("maxRowCountPerPartition", this.maxRowCountPerPartition).add("partial", this.partial).add("hashSymbol", this.hashSymbol).toString();
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification = Optional.empty();
        private Optional<SymbolAlias> rowNumberSymbol = Optional.empty();
        private Optional<Integer> maxRowCountPerPartition = Optional.empty();
        private Optional<Boolean> partial = Optional.empty();
        private Optional<Optional<SymbolAlias>> hashSymbol = Optional.empty();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
            this.specification = Optional.of(PlanMatchPattern.specification(partitionBy, orderBy, orderings));
            return this;
        }

        public Builder rowNumberSymbol(SymbolAlias rowNumberSymbol) {
            this.rowNumberSymbol = Optional.of(Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null"));
            return this;
        }

        public Builder maxRowCountPerPartition(int maxRowCountPerPartition) {
            this.maxRowCountPerPartition = Optional.of(maxRowCountPerPartition);
            return this;
        }

        public Builder partial(boolean partial) {
            this.partial = Optional.of(partial);
            return this;
        }

        public Builder hashSymbol(Optional<SymbolAlias> hashSymbol) {
            this.hashSymbol = Optional.of(Objects.requireNonNull(hashSymbol, "hashSymbol is null"));
            return this;
        }

        PlanMatchPattern build() {
            return PlanMatchPattern.node(TopNRowNumberNode.class, this.source).with(new TopNRowNumberMatcher(this.specification, this.rowNumberSymbol, this.maxRowCountPerPartition, this.partial, this.hashSymbol));
        }
    }
}

