/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.ShortDecimalType;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ValuesMatcher
implements Matcher {
    private final Map<String, Integer> outputSymbolAliases;
    private final Optional<Integer> expectedOutputSymbolCount;
    private final Optional<Set<List<Expression>>> expectedRows;

    public ValuesMatcher(Map<String, Integer> outputSymbolAliases, Optional<Integer> expectedOutputSymbolCount, Optional<List<List<Expression>>> expectedRows) {
        this.outputSymbolAliases = ImmutableMap.copyOf(outputSymbolAliases);
        this.expectedOutputSymbolCount = Objects.requireNonNull(expectedOutputSymbolCount, "expectedOutputSymbolCount is null");
        this.expectedRows = Objects.requireNonNull(expectedRows, "expectedRows is null").map(ImmutableSet::copyOf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof ValuesNode)) return false;
        if (this.expectedOutputSymbolCount.map(node.getOutputVariables().size()::equals).orElse(true) == false) return false;
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        ValuesNode valuesNode = (ValuesNode)node;
        if (!this.expectedRows.map(rows -> rows.equals(valuesNode.getRows().stream().map(rowExpressions -> (ImmutableList)rowExpressions.stream().map(rowExpression -> {
            ConstantExpression expression = (ConstantExpression)rowExpression;
            if (expression.getType().getJavaType() == Boolean.TYPE) {
                return new BooleanLiteral(String.valueOf(expression.getValue()));
            }
            if (expression.getType() instanceof ShortDecimalType) {
                return new DecimalLiteral(String.valueOf(expression.getValue()));
            }
            if (expression.getType().getJavaType() == Long.TYPE) {
                return new LongLiteral(String.valueOf(expression.getValue()));
            }
            if (expression.getType().getJavaType() == Double.TYPE) {
                return new DoubleLiteral(String.valueOf(expression.getValue()));
            }
            if (expression.getType().getJavaType() == Slice.class) {
                return new StringLiteral(((Slice)expression.getValue()).toStringUtf8());
            }
            return new GenericLiteral(expression.getType().toString(), String.valueOf(expression.getValue()));
        }).collect(ImmutableList.toImmutableList())).collect(ImmutableSet.toImmutableSet()))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        MatchResult result = MatchResult.match(SymbolAliases.builder().putAll(Maps.transformValues(this.outputSymbolAliases, index -> ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)((VariableReferenceExpression)valuesNode.getOutputVariables().get((int)index))))).build());
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("outputSymbolAliases", this.outputSymbolAliases).add("expectedOutputSymbolCount", this.expectedOutputSymbolCount).add("expectedRows", this.expectedRows).toString();
    }
}

