/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class WindowFrameProvider
implements ExpectedValueProvider<WindowNode.Frame> {
    private final WindowNode.Frame.WindowType type;
    private final WindowNode.Frame.BoundType startType;
    private final Optional<SymbolAlias> startValue;
    private final Optional<SymbolAlias> sortKeyForStartComparison;
    private final WindowNode.Frame.BoundType endType;
    private final Optional<SymbolAlias> endValue;
    private final Optional<SymbolAlias> sortKeyForEndComparison;
    private Optional<Type> startValueType;
    private Optional<Type> sortKeyForStartComparisonType;
    private Optional<Type> endValueType;
    private Optional<Type> sortKeyForEndComparisonType;

    WindowFrameProvider(WindowNode.Frame.WindowType type, WindowNode.Frame.BoundType startType, Optional<SymbolAlias> startValue, Optional<Type> startValueType, Optional<SymbolAlias> sortKeyForStartComparison, Optional<Type> sortKeyForStartComparisonType, WindowNode.Frame.BoundType endType, Optional<SymbolAlias> endValue, Optional<Type> endValueType, Optional<SymbolAlias> sortKeyForEndComparison, Optional<Type> sortKeyForEndComparisonType) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startValue = Objects.requireNonNull(startValue, "startValue is null");
        this.startValueType = Objects.requireNonNull(startValueType, "startValueType is null");
        this.sortKeyForStartComparison = Objects.requireNonNull(sortKeyForStartComparison, "sortKeyForStartComparison is null");
        this.sortKeyForStartComparisonType = Objects.requireNonNull(sortKeyForStartComparisonType, "sortKeyForStartComparisonType is null");
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endValue = Objects.requireNonNull(endValue, "endValue is null");
        this.endValueType = Objects.requireNonNull(endValueType, "endValueType is null");
        this.sortKeyForEndComparison = Objects.requireNonNull(sortKeyForEndComparison, "sortKeyForEndComparison is null");
        this.sortKeyForEndComparisonType = Objects.requireNonNull(sortKeyForEndComparisonType, "sortKeyForEndComparisonType is null");
    }

    @Override
    public WindowNode.Frame getExpectedValue(SymbolAliases aliases) {
        Optional<Expression> originalStartValue = this.startValue.map(alias -> alias.toSymbol(aliases).toSymbolReference());
        Optional<Expression> originalEndValue = this.endValue.map(alias -> alias.toSymbol(aliases).toSymbolReference());
        return new WindowNode.Frame(this.type, this.startType, this.toVariableReferenceExpression(aliases, this.startValue, this.startValueType), this.toVariableReferenceExpression(aliases, this.sortKeyForStartComparison, this.sortKeyForStartComparisonType), this.endType, this.toVariableReferenceExpression(aliases, this.endValue, this.endValueType), this.toVariableReferenceExpression(aliases, this.sortKeyForEndComparison, this.sortKeyForEndComparisonType), originalStartValue.map(Expression::toString), originalEndValue.map(Expression::toString));
    }

    private Optional<VariableReferenceExpression> toVariableReferenceExpression(SymbolAliases aliases, Optional<SymbolAlias> symbolAlias, Optional<Type> type) {
        if (!symbolAlias.isPresent()) {
            return Optional.empty();
        }
        String alias = symbolAlias.get().toSymbol(aliases).getName();
        Type variableType = type.orElseGet(() -> BigintType.BIGINT);
        if (alias.startsWith("field")) {
            return Optional.of(new VariableReferenceExpression(Optional.empty(), symbolAlias.get().toString(), variableType));
        }
        return Optional.of(new VariableReferenceExpression(Optional.empty(), symbolAlias.get().toSymbol(aliases).getName(), variableType));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startValue", this.startValue).add("startValueType", this.startValueType).add("sortKeyForStartComparison", this.sortKeyForStartComparison).add("sortKeyForStartComparisonType", this.sortKeyForStartComparisonType).add("endType", (Object)this.endType).add("endValue", this.endValue).add("endValueType", this.endValueType).add("sortKeyForEndComparison", this.sortKeyForEndComparison).add("sortKeyForEndComparisonType", this.sortKeyForEndComparisonType).toString();
    }
}

