/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.CrossJoinWithArrayNotContainsToAntiJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushDownFilterExpressionEvaluationThroughCrossJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.testng.annotations.Test;

public class TestCrossJoinWithArrayNotContainsToAntiJoin
extends BaseRuleTest {
    public TestCrossJoinWithArrayNotContainsToAntiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testTriggerForBigInt() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("not contains(left_array_k1, right_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)))), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(UnnestNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testTriggerForBigIntArrayRightSide() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("not contains(right_array_k1, left_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_k1")), (PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)))), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(UnnestNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testMultipleConditions() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("not contains(left_array_k1, right_k1) and right_k2>1"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)))), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(UnnestNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testComputedArrayExpression() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager()), (Object)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager()))).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("json_string", (Type)VarcharType.VARCHAR);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("not contains(cast(json_parse(json_string) as array<bigint>), right_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.project((PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("x", (Type)VarcharType.VARCHAR))), Assignments.builder().put(p.variable("json_string", (Type)VarcharType.VARCHAR), p.rowExpression("x")).build()), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new EquiJoinClause[0]));
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(UnnestNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))))))))));
    }

    @Test
    public void testMultipleInvalidArrayNotContainsConditions() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("not contains(left_array_k1, right_k1) or not contains(right_array_k2, left_k2)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2"))), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT))), new EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerForDouble() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)DoubleType.DOUBLE));
            p.variable("right_k1", (Type)DoubleType.DOUBLE);
            return p.filter(p.rowExpression("not contains(left_array_k1, right_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)DoubleType.DOUBLE)))), (PlanNode)p.values(p.variable("right_k1", (Type)DoubleType.DOUBLE)), new EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testArrayContainsWithCast() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("not contains(left_array_k1, CAST(right_k1 AS BIGINT))"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT)))), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR)), new EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerForMultiRow() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("not contains(left_array_k1, right_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 50L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerForMultipleColumnsOnArraySide() {
        this.tester().assertThat((Rule)new CrossJoinWithArrayNotContainsToAntiJoin(this.getMetadata(), this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.filter(p.rowExpression("not contains(left_array_k1, right_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT))), new EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerForNonDeterministicArrayExpression() {
        this.tester().assertThat((Rule)new PushDownFilterExpressionEvaluationThroughCrossJoin(this.getFunctionManager())).setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            p.variable("right_k1", (Type)VarcharType.VARCHAR);
            return p.filter(p.rowExpression("not contains(transform(left_array_k1, x->lower(x)), right_k1)"), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.enforceSingleRow((PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)VarcharType.VARCHAR)))), (PlanNode)p.values(p.variable("right_k1", (Type)VarcharType.VARCHAR)), new EquiJoinClause[0]));
        }).doesNotFire();
    }
}

