/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.ExchangeEncoding;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineRemotePartitionedExchangeEncoding;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDetermineRemotePartitionedExchangeEncoding {
    private static final int MIN_COLUMNAR_STREAMS = 100;
    private RuleTester tester;

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tester.close();
        this.tester = null;
    }

    @Test
    public void testPrestoOnSpark() {
        this.assertForPrestoOnSpark().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, 100)).doesNotFire();
        this.assertForPrestoOnSpark().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 100).withRowWiseEncoding()).doesNotFire();
        this.assertForPrestoOnSpark().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 99)).matches(TestDetermineRemotePartitionedExchangeEncoding.exchangeEncoding(ExchangeEncoding.ROW_WISE));
    }

    @Test
    public void testPresto() {
        this.assertForPresto().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, 100)).doesNotFire();
        this.assertForPresto().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 99)).doesNotFire();
        this.assertForPresto().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 101)).doesNotFire();
    }

    @Test
    public void testNative() {
        this.assertForNative().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, 100)).doesNotFire();
        this.assertForNative().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 99)).doesNotFire();
        this.assertForNative().on(p -> TestDetermineRemotePartitionedExchangeEncoding.createExchange(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 100)).matches(TestDetermineRemotePartitionedExchangeEncoding.exchangeEncoding(ExchangeEncoding.ROW_WISE));
    }

    private RuleAssert assertForPrestoOnSpark() {
        return this.createAssert(false, true);
    }

    private RuleAssert assertForNative() {
        return this.createAssert(true, false);
    }

    private RuleAssert assertForPresto() {
        return this.createAssert(false, false);
    }

    private RuleAssert createAssert(boolean nativeExecution, boolean prestoSparkExecutionEnvironment) {
        return this.tester.assertThat((Rule)new DetermineRemotePartitionedExchangeEncoding(nativeExecution, prestoSparkExecutionEnvironment)).setSystemProperty("native_min_columnar_encoding_channels_to_prefer_row_wise_encoding", "100");
    }

    private static ExchangeNode createExchange(PartitioningHandle handle, int numberOfOutputColumnarStreams) {
        int numberOfBigintColumns = numberOfOutputColumnarStreams / 2;
        List types = (List)IntStream.range(0, numberOfBigintColumns).mapToObj(i -> BigintType.BIGINT).collect(ImmutableList.toImmutableList());
        ExchangeNode exchangeNode = TestDetermineRemotePartitionedExchangeEncoding.createExchangeNode(handle, types, types);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfOutputColumnarChannels((ExchangeNode)exchangeNode), (long)(numberOfBigintColumns * 2));
        return exchangeNode;
    }

    private static PlanMatchPattern exchangeEncoding(ExchangeEncoding encoding) {
        return PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])).with(new ExchangeEncodingMatcher(encoding));
    }

    @Test
    public void testEstimateNumberOfOutputColumnarChannels() {
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfOutputColumnarChannels((ExchangeNode)TestDetermineRemotePartitionedExchangeEncoding.createExchangeNode(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT))), (long)2L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfOutputColumnarChannels((ExchangeNode)TestDetermineRemotePartitionedExchangeEncoding.createExchangeNode(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT))), (long)2L);
    }

    private static ExchangeNode createExchangeNode(PartitioningHandle handle, List<Type> inputTypes, List<Type> outputTypes) {
        return ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("exchange"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)new ValuesNode(Optional.empty(), new PlanNodeId("values"), TestDetermineRemotePartitionedExchangeEncoding.createExpressions(inputTypes), (List)ImmutableList.of(), Optional.empty()), (PartitioningScheme)new PartitioningScheme(Partitioning.create((PartitioningHandle)handle, (Collection)ImmutableList.of()), TestDetermineRemotePartitionedExchangeEncoding.createExpressions(outputTypes)));
    }

    private static List<VariableReferenceExpression> createExpressions(List<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            result.add((Object)new VariableReferenceExpression(Optional.empty(), "exp_" + i, types.get(i)));
        }
        return result.build();
    }

    @Test
    public void testEstimateNumberOfColumnarChannels() {
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)BigintType.BIGINT), (long)2L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)RealType.REAL), (long)2L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)VarcharType.VARCHAR), (long)3L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)VarcharType.createVarcharType((int)10)), (long)3L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)DecimalType.createDecimalType((int)3, (int)2)), (long)2L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)DecimalType.createDecimalType((int)30, (int)2)), (long)2L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)new ArrayType((Type)BigintType.BIGINT)), (long)4L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)new ArrayType((Type)VarcharType.VARCHAR)), (long)5L);
        Assert.assertEquals((long)DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR))), (long)7L);
    }

    private static class ExchangeEncodingMatcher
    implements Matcher {
        private final ExchangeEncoding encoding;

        private ExchangeEncodingMatcher(ExchangeEncoding encoding) {
            this.encoding = Objects.requireNonNull(encoding, "encoding is null");
        }

        @Override
        public boolean shapeMatches(PlanNode node) {
            return node instanceof ExchangeNode;
        }

        @Override
        public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
            ExchangeNode exchangeNode = (ExchangeNode)node;
            return exchangeNode.getPartitioningScheme().getEncoding() == this.encoding ? MatchResult.match() : MatchResult.NO_MATCH;
        }
    }
}

