/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.JoinTableInfo;
import com.facebook.presto.spi.JoinTableSet;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TestingColumnHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.optimizations.GroupInnerJoinsByConnectorRuleSet;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.ColumnNaming;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchNodePartitioningProvider;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestGroupInnerJoinsByConnectorRuleSet {
    public static final String CATALOG_SUPPORTING_JOIN_PUSHDOWN = "catalog_join_pushdown_supported";
    public static final String LOCAL = "local";
    public static final String TEST_SCHEMA = "test-schema";
    public static final String TEST_TABLE = "test-table";
    public static final String OTHER_CATALOG_SUPPORTING_JOIN_PUSHDOWN = "other_catalog_join_pushdown_supported";
    private PlanBuilder planBuilder;
    private RuleTester tester;

    @BeforeClass
    public void setUp() {
        LocalQueryRunner runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);
        TestingJoinPushdownConnectorFactory pushdownConnectorFactory = new TestingJoinPushdownConnectorFactory(){

            public String getName() {
                return "tpch_with_join_pushdown";
            }
        };
        TestingJoinPushdownConnectorFactory pushdownConnectorFactory1 = new TestingJoinPushdownConnectorFactory(){

            public String getName() {
                return "tpch_with_join_pushdown1";
            }
        };
        runner.createCatalog(CATALOG_SUPPORTING_JOIN_PUSHDOWN, (ConnectorFactory)pushdownConnectorFactory, (Map)ImmutableMap.of());
        runner.createCatalog(OTHER_CATALOG_SUPPORTING_JOIN_PUSHDOWN, (ConnectorFactory)pushdownConnectorFactory1, (Map)ImmutableMap.of());
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), RuleTester.getSession((Map<String, String>)ImmutableMap.of((Object)"optimizer_inner_join_pushdown_enabled", (Object)"true", (Object)"optimizer_inequality_join_pushdown_enabled", (Object)"true"), SessionPropertyManager.createTestingSessionPropertyManager()), runner, (ConnectorFactory)new TpchConnectorFactory(1));
        this.planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), runner.getMetadata());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test
    public void testDoesNotPushDownOuterJoin() {
        String connectorName = "test_catalog";
        this.assertGroupInnerJoinsByConnectorRuleSet().on(p -> p.join(JoinType.FULL, (PlanNode)this.tableScan(connectorName, "a1", "b1"), (PlanNode)this.tableScan(connectorName, "a2", "b2"), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2")))).doesNotFire();
    }

    @Test
    public void testDPartialPushDownTwoDifferentConnectors() {
        HashSet<JoinTableInfo> joinTableInfos = new HashSet<JoinTableInfo>();
        JoinTableInfo joinTableInfo1 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)new TestingColumnHandle("a1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2"), (Object)new TestingColumnHandle("a2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2")));
        JoinTableInfo joinTableInfo2 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c1"), (Object)new TestingColumnHandle("c1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c2"), (Object)new TestingColumnHandle("c2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c2")));
        joinTableInfos.add(joinTableInfo1);
        joinTableInfos.add(joinTableInfo2);
        JoinTableSet tableHandleSet = new JoinTableSet(joinTableInfos);
        TableHandle tableHandle1 = new TableHandle(new ConnectorId(CATALOG_SUPPORTING_JOIN_PUSHDOWN), (ConnectorTableHandle)tableHandleSet, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        TableHandle tableHandle2 = new TableHandle(new ConnectorId(LOCAL), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.assertGroupInnerJoinsByConnectorRuleSet().on(p -> p.join(JoinType.INNER, (PlanNode)p.join(JoinType.INNER, (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "a1", "a2"), (PlanNode)this.tableScan(LOCAL, "b1", "b2"), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1"))), (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "c1", "c2"), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c1")))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("a1 = b1 and a1 = c1 and true", PlanMatchPattern.join(JoinTableScanMatcher.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, tableHandle1, "a1", "a2", "c1", "c2"), JoinTableScanMatcher.tableScan(LOCAL, tableHandle2, "b1", "b2")))));
    }

    @Test
    public void testValidPushdownForSameConnector() {
        HashSet<JoinTableInfo> joinTableInfos = new HashSet<JoinTableInfo>();
        JoinTableInfo joinTableInfo1 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1"), (Object)new TestingColumnHandle("b1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)new TestingColumnHandle("a1")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1")));
        JoinTableInfo joinTableInfo2 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b2"), (Object)new TestingColumnHandle("b2"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2"), (Object)new TestingColumnHandle("a2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b2")));
        joinTableInfos.add(joinTableInfo1);
        joinTableInfos.add(joinTableInfo2);
        JoinTableSet tableHandleSet = new JoinTableSet(joinTableInfos);
        TableHandle tableHandle = new TableHandle(new ConnectorId(CATALOG_SUPPORTING_JOIN_PUSHDOWN), (ConnectorTableHandle)tableHandleSet, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.assertGroupInnerJoinsByConnectorRuleSet().on(p -> p.join(JoinType.INNER, (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "a1", "b1"), (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "a2", "b2"), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2")))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("a1 = a2 and true", JoinTableScanMatcher.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, tableHandle, "a1", "a2"))));
    }

    @Test
    public void testJoinPushDownHappenedWithFilters() {
        HashSet<JoinTableInfo> joinTableInfos = new HashSet<JoinTableInfo>();
        JoinTableInfo joinTableInfo1 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)new TestingColumnHandle("a1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1"), (Object)new TestingColumnHandle("b1")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1")));
        JoinTableInfo joinTableInfo2 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2"), (Object)new TestingColumnHandle("a2"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b2"), (Object)new TestingColumnHandle("b2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b2")));
        joinTableInfos.add(joinTableInfo1);
        joinTableInfos.add(joinTableInfo2);
        JoinTableSet tableHandleSet = new JoinTableSet(joinTableInfos);
        TableHandle tableHandle = new TableHandle(new ConnectorId(CATALOG_SUPPORTING_JOIN_PUSHDOWN), (ConnectorTableHandle)tableHandleSet, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        String expression = "a1 > b1";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"a1", (Object)BigintType.BIGINT, (Object)"b1", (Object)BigintType.BIGINT));
        TestingRowExpressionTranslator sqlToRowExpressionTranslator = new TestingRowExpressionTranslator(this.tester.getMetadata());
        RowExpression rowExpression = sqlToRowExpressionTranslator.translateAndOptimize(PlanBuilder.expression(expression), typeProvider);
        this.assertGroupInnerJoinsByConnectorRuleSet().on(p -> p.join(JoinType.INNER, (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "a1", "b1"), (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "a2", "b2"), rowExpression, new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2")))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("a1 = a2 and a1 > b1 and true", JoinTableScanMatcher.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, tableHandle, "a1", "a2", "b1"))));
    }

    @Test
    public void testPushDownWithTwoDifferentConnectors() {
        HashSet<JoinTableInfo> joinTableSet1 = new HashSet<JoinTableInfo>();
        JoinTableInfo tableInfo1 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)new TestingColumnHandle("a1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2"), (Object)new TestingColumnHandle("a2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a2")));
        JoinTableInfo tableInfo2 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1"), (Object)new TestingColumnHandle("b1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b2"), (Object)new TestingColumnHandle("b2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b2")));
        joinTableSet1.add(tableInfo1);
        joinTableSet1.add(tableInfo2);
        JoinTableSet tableHandleSet1 = new JoinTableSet(joinTableSet1);
        TableHandle tableHandle1 = new TableHandle(new ConnectorId(CATALOG_SUPPORTING_JOIN_PUSHDOWN), (ConnectorTableHandle)tableHandleSet1, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        HashSet<JoinTableInfo> joinTableSet2 = new HashSet<JoinTableInfo>();
        JoinTableInfo table2Info1 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c1"), (Object)new TestingColumnHandle("c1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c2"), (Object)new TestingColumnHandle("c2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c2")));
        JoinTableInfo table2Info2 = new JoinTableInfo((ConnectorTableHandle)new TestingMetadata.TestingTableHandle(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (Map)ImmutableMap.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("d1"), (Object)new TestingColumnHandle("d1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("d2"), (Object)new TestingColumnHandle("d2")), (List)ImmutableList.of((Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("d1"), (Object)TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("d2")));
        joinTableSet2.add(table2Info1);
        joinTableSet2.add(table2Info2);
        JoinTableSet tableHandleSet2 = new JoinTableSet(joinTableSet2);
        TableHandle tableHandle2 = new TableHandle(new ConnectorId(OTHER_CATALOG_SUPPORTING_JOIN_PUSHDOWN), (ConnectorTableHandle)tableHandleSet2, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.assertGroupInnerJoinsByConnectorRuleSet().on(p -> p.join(JoinType.INNER, (PlanNode)p.join(JoinType.INNER, (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "a1", "a2"), (PlanNode)this.tableScan(OTHER_CATALOG_SUPPORTING_JOIN_PUSHDOWN, "d1", "d2"), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1")), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("a1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("d1"))), (PlanNode)p.join(JoinType.INNER, (PlanNode)this.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, "b1", "b2"), (PlanNode)this.tableScan(OTHER_CATALOG_SUPPORTING_JOIN_PUSHDOWN, "c1", "c2"), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("b1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c1"))), new EquiJoinClause(TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("c1"), TestGroupInnerJoinsByConnectorRuleSet.newBigintVariable("d1")))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("((a1 = b1 and a1 = d1) and (b1 = c1 and c1 = d1)) and true", PlanMatchPattern.join(JoinTableScanMatcher.tableScan(CATALOG_SUPPORTING_JOIN_PUSHDOWN, tableHandle1, "a1", "b1"), JoinTableScanMatcher.tableScan(OTHER_CATALOG_SUPPORTING_JOIN_PUSHDOWN, tableHandle2, "c1", "d1")))));
    }

    private RuleAssert assertGroupInnerJoinsByConnectorRuleSet() {
        return this.tester.assertThat((Rule)new GroupInnerJoinsByConnectorRuleSet.OnlyJoinRule(this.tester.getMetadata(), (plan, session, types, variableAllocator, idAllocator, warningCollector) -> PlanOptimizerResult.optimizerResult((PlanNode)plan, (boolean)false)), (List<String>)ImmutableList.of((Object)CATALOG_SUPPORTING_JOIN_PUSHDOWN, (Object)OTHER_CATALOG_SUPPORTING_JOIN_PUSHDOWN));
    }

    private TableScanNode tableScan(String connectorName, String ... columnNames) {
        return this.planBuilder.tableScan(connectorName, (List<VariableReferenceExpression>)((List)Arrays.stream(columnNames).map(TestGroupInnerJoinsByConnectorRuleSet::newBigintVariable).collect(ImmutableList.toImmutableList())), Arrays.stream(columnNames).map(TestGroupInnerJoinsByConnectorRuleSet::newBigintVariable).collect(Collectors.toMap(Function.identity(), variable -> new TestingColumnHandle(variable.getName()))));
    }

    private static VariableReferenceExpression newBigintVariable(String name) {
        return new VariableReferenceExpression(Optional.empty(), name, (Type)BigintType.BIGINT);
    }

    private static final class JoinTableScanMatcher
    implements Matcher {
        private final ConnectorId connectorId;
        private final TableHandle tableHandle;
        private final String[] columns;

        public static PlanMatchPattern tableScan(String connectorName, TableHandle tableHandle, String ... columnNames) {
            return PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new JoinTableScanMatcher(new ConnectorId(connectorName), tableHandle, columnNames));
        }

        private JoinTableScanMatcher(ConnectorId connectorId, TableHandle tableHandle, String ... columns) {
            this.connectorId = connectorId;
            this.tableHandle = tableHandle;
            this.columns = columns;
        }

        @Override
        public boolean shapeMatches(PlanNode node) {
            return node instanceof TableScanNode;
        }

        @Override
        public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
            Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
            TableScanNode tableScanNode = (TableScanNode)node;
            TableHandle otherTable = tableScanNode.getTable();
            ConnectorTableHandle connectorHandle = otherTable.getConnectorHandle();
            if (this.connectorId.equals((Object)otherTable.getConnectorId()) && Objects.equals(otherTable.getConnectorId(), this.tableHandle.getConnectorId()) && Objects.equals(otherTable.getConnectorHandle(), this.tableHandle.getConnectorHandle()) && Objects.equals(otherTable.getLayout().isPresent(), this.tableHandle.getLayout().isPresent())) {
                return MatchResult.match(SymbolAliases.builder().putAll(Arrays.stream(this.columns).collect(Collectors.toMap(Function.identity(), SymbolReference::new))).build());
            }
            return MatchResult.NO_MATCH;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("connectorId", (Object)this.connectorId).toString();
        }
    }

    private static class TestingJoinPushdownConnectorFactory
    extends TpchConnectorFactory {
        private TestingJoinPushdownConnectorFactory() {
        }

        public Connector create(final String catalogName, final Map<String, String> properties, ConnectorContext context) {
            final int splitsPerNode = super.getSplitsPerNode(properties);
            final ColumnNaming columnNaming = ColumnNaming.valueOf((String)properties.getOrDefault("tpch.column-naming", ColumnNaming.SIMPLIFIED.name()).toUpperCase());
            final NodeManager nodeManager = context.getNodeManager();
            return new Connector(){

                public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                    return TpchTransactionHandle.INSTANCE;
                }

                public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                    return new TpchMetadata(catalogName, columnNaming, this.isPredicatePushdownEnabled(), this.isPartitioningEnabled(properties)){

                        public boolean isPushdownSupportedForFilter(ConnectorSession session, ConnectorTableHandle tableHandle, RowExpression filter, Map<VariableReferenceExpression, ColumnHandle> symbolToColumnHandleMap) {
                            return true;
                        }
                    };
                }

                public ConnectorSplitManager getSplitManager() {
                    return new TpchSplitManager(nodeManager, splitsPerNode);
                }

                public ConnectorRecordSetProvider getRecordSetProvider() {
                    return new TpchRecordSetProvider();
                }

                public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                    return new TpchNodePartitioningProvider(nodeManager, splitsPerNode);
                }

                public Set<ConnectorCapabilities> getCapabilities() {
                    return ImmutableSet.of((Object)ConnectorCapabilities.SUPPORTS_JOIN_PUSHDOWN);
                }
            };
        }
    }
}

