/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.RowExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.plan.MultiJoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoinEnumerator {
    private LocalQueryRunner queryRunner;
    private Metadata metadata;
    private DeterminismEvaluator determinismEvaluator;
    private FunctionResolution functionResolution;
    private PlanBuilder planBuilder;
    private TestingRowExpressionTranslator rowExpressionTranslator;
    private Session session;

    @BeforeClass
    public void setUp() {
        this.session = TestingSession.testSessionBuilder().build();
        this.queryRunner = new LocalQueryRunner(this.session);
        this.metadata = this.queryRunner.getMetadata();
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(this.metadata);
        this.functionResolution = new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver());
        this.planBuilder = new PlanBuilder(this.session, new PlanNodeIdAllocator(), this.metadata);
        this.rowExpressionTranslator = new TestingRowExpressionTranslator(this.metadata);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    @Test
    public void testGeneratePartitions() {
        Assert.assertEquals((Set)ReorderJoins.JoinEnumerator.generatePartitions((int)4), (Set)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)3), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)3), (Object[])new ImmutableSet[]{ImmutableSet.of((Object)0, (Object)2, (Object)3)}));
        Assert.assertEquals((Set)ReorderJoins.JoinEnumerator.generatePartitions((int)3), (Set)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2)));
    }

    @Test
    public void testDoesNotCreateJoinWhenPartitionedOnCrossJoin() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = new PlanBuilder(SessionTestUtils.TEST_SESSION, idAllocator, this.queryRunner.getMetadata());
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        MultiJoinNode multiJoinNode = new MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)p.values(a1), (Object)p.values(b1))), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (List)ImmutableList.of((Object)a1, (Object)b1), Assignments.of(), false, Optional.empty());
        ReorderJoins.JoinEnumerator joinEnumerator = new ReorderJoins.JoinEnumerator(new CostComparator(1.0, 1.0, 1.0), multiJoinNode.getFilter(), this.createContext(), this.determinismEvaluator, this.functionResolution, this.metadata);
        ReorderJoins.JoinEnumerationResult actual = joinEnumerator.createJoinAccordingToPartitioning(multiJoinNode.getSources(), multiJoinNode.getOutputVariables(), (Set)ImmutableSet.of((Object)0));
        Assert.assertFalse((boolean)actual.getPlanNode().isPresent());
        Assert.assertEquals((Object)actual.getCost(), (Object)PlanCostEstimate.infinite());
    }

    @Test
    public void testJoinClauseAndFilterInference() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"a", (Object)BigintType.BIGINT);
        builder.put((Object)"b", (Object)BigintType.BIGINT);
        builder.put((Object)"c", (Object)BigintType.BIGINT);
        builder.put((Object)"d", (Object)BigintType.BIGINT);
        ImmutableMap variableMap = builder.build();
        VariableReferenceExpression a = Expressions.variable((String)"a", (Type)((Type)variableMap.get("a")));
        VariableReferenceExpression b = Expressions.variable((String)"b", (Type)((Type)variableMap.get("b")));
        VariableReferenceExpression c = Expressions.variable((String)"c", (Type)((Type)variableMap.get("c")));
        VariableReferenceExpression d = Expressions.variable((String)"d", (Type)((Type)variableMap.get("d")));
        SymbolAliases.Builder newAliases = SymbolAliases.builder();
        newAliases.put("A", new SymbolReference("a"));
        newAliases.put("B", new SymbolReference("b"));
        newAliases.put("C", new SymbolReference("c"));
        newAliases.put("D", new SymbolReference("d"));
        SymbolAliases symbolAliases = newAliases.build();
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a = b"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)c), "A = B", null);
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a = b", "c = d"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a, (Object)c), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)d), "A = B AND C = D", null);
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a = b + c"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)c), "A = B + C", null);
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a = b + c"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)c), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), "A = B + C", null);
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a = b + c + 1"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)c), "A = B + C + 1", null);
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a = b + c + 1"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)c), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), "A = B + C + 1", null);
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a + b = c"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)c), null, "A + B = C");
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a + b = 1"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b), null, "A + B = 1");
        this.assertJoinCondition(symbolAliases, this.toRowExpressionList((Map<String, Type>)variableMap, "a = ABS(b)", "a = ceil(b-c)", "b = c + 10"), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)a), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)b, (Object)c), "A = abs(B) AND A = ceil(B-C)", "B = C + 10");
    }

    private List<RowExpression> toRowExpressionList(Map<String, Type> variableTypeMap, String ... predicates) {
        return Arrays.stream(predicates).map(p -> this.rowExpressionTranslator.translate((String)p, variableTypeMap)).collect(Collectors.toList());
    }

    private void assertJoinCondition(SymbolAliases symbolAliases, List<RowExpression> joinPredicates, Set<VariableReferenceExpression> leftVariables, Set<VariableReferenceExpression> rightVariables, String expectedEquiJoinClause, String expectedJoinFilter) {
        RowExpressionVerifier verifier = new RowExpressionVerifier(symbolAliases, this.metadata, this.session);
        ReorderJoins.JoinEnumerator joinEnumerator = new ReorderJoins.JoinEnumerator(new CostComparator(1.0, 1.0, 1.0), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, this.createContext(), this.determinismEvaluator, this.functionResolution, this.metadata);
        ReorderJoins.JoinEnumerator.JoinCondition joinConditions = joinEnumerator.extractJoinConditions(joinPredicates, leftVariables, rightVariables, new VariableAllocator());
        Optional<RowExpression> equiJoinExpressionInlined = joinConditions.getJoinClauses().stream().map(criteria -> JoinNodeUtils.toRowExpression((EquiJoinClause)criteria, (FunctionResolution)this.functionResolution)).map(expression -> RowExpressionNodeInliner.replaceExpression((RowExpression)expression, (Map)joinConditions.getNewLeftAssignments())).map(expression -> RowExpressionNodeInliner.replaceExpression((RowExpression)expression, (Map)joinConditions.getNewRightAssignments())).reduce((xva$0, xva$1) -> LogicalRowExpressions.and((RowExpression[])new RowExpression[]{xva$0, xva$1}));
        if (equiJoinExpressionInlined.isPresent()) {
            Assert.assertNotNull((Object)expectedEquiJoinClause);
            Assert.assertTrue((boolean)((Boolean)verifier.process((Node)PlanBuilder.expression(expectedEquiJoinClause), equiJoinExpressionInlined.get())));
        } else {
            Assert.assertNull((Object)expectedEquiJoinClause);
        }
        Optional joinFilter = joinConditions.getJoinFilters().stream().reduce((xva$0, xva$1) -> LogicalRowExpressions.and((RowExpression[])new RowExpression[]{xva$0, xva$1}));
        if (joinFilter.isPresent()) {
            Assert.assertNotNull((Object)expectedJoinFilter);
            Assert.assertTrue((boolean)((Boolean)verifier.process((Node)PlanBuilder.expression(expectedJoinFilter), (RowExpression)joinFilter.get())));
        } else {
            Assert.assertNull((Object)expectedJoinFilter);
        }
    }

    private Rule.Context createContext() {
        final PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        final VariableAllocator variableAllocator = new VariableAllocator();
        final CachingStatsProvider statsProvider = new CachingStatsProvider(this.queryRunner.getStatsCalculator(), Optional.empty(), Lookup.noLookup(), this.queryRunner.getDefaultSession(), TypeProvider.viewOf((Map)variableAllocator.getVariables()));
        final CachingCostProvider costProvider = new CachingCostProvider(this.queryRunner.getCostCalculator(), (StatsProvider)statsProvider, Optional.empty(), this.queryRunner.getDefaultSession());
        return new Rule.Context(){

            public Lookup getLookup() {
                return Lookup.noLookup();
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return planNodeIdAllocator;
            }

            public VariableAllocator getVariableAllocator() {
                return variableAllocator;
            }

            public Session getSession() {
                return TestJoinEnumerator.this.queryRunner.getDefaultSession();
            }

            public StatsProvider getStatsProvider() {
                return statsProvider;
            }

            public CostProvider getCostProvider() {
                return costProvider;
            }

            public void checkTimeoutNotExhausted() {
            }

            public WarningCollector getWarningCollector() {
                return WarningCollector.NOOP;
            }

            public Optional<LogicalPropertiesProvider> getLogicalPropertiesProvider() {
                return Optional.empty();
            }
        };
    }
}

