/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.MultiJoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoinNodeFlattener {
    private static final int DEFAULT_JOIN_LIMIT = 10;
    private DeterminismEvaluator determinismEvaluator;
    private FunctionResolution functionResolution;
    private LocalQueryRunner queryRunner;
    private FunctionAndTypeResolver functionAndTypeResolver;

    @BeforeClass
    public void setUp() {
        this.queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().build());
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(this.queryRunner.getMetadata());
        this.functionAndTypeResolver = this.queryRunner.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver();
        this.functionResolution = new FunctionResolution(this.functionAndTypeResolver);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testDoesNotAllowOuterJoin() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        JoinNode outerJoin = p.join(JoinType.FULL, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ReorderJoins.toMultiJoinNode((JoinNode)outerJoin, (Lookup)Lookup.noLookup(), (int)10, (boolean)false, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator);
    }

    @Test
    public void testDoesNotConvertNestedOuterJoins() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        JoinNode leftJoin = p.join(JoinType.LEFT, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ValuesNode valuesC = p.values(c1);
        JoinNode joinNode = p.join(JoinType.INNER, (PlanNode)leftJoin, (PlanNode)valuesC, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty());
        MultiJoinNode expected = MultiJoinNode.builder().setSources(new PlanNode[]{leftJoin, valuesC}).setFilter(this.createEqualsExpression((RowExpression)a1, (RowExpression)c1)).setOutputVariables(new VariableReferenceExpression[]{a1, b1, c1}).build();
        Assert.assertEquals((Object)ReorderJoins.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10, (boolean)false, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testRetainsOutputSymbols() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression b2 = p.variable("B2");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression c2 = p.variable("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        JoinNode joinNode = p.join(JoinType.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinType.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.empty()), (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        MultiJoinNode expected = MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC}).setFilter(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression((RowExpression)b1, (RowExpression)c1), this.createEqualsExpression((RowExpression)a1, (RowExpression)b1)})).setOutputVariables(new VariableReferenceExpression[]{a1, b1}).build();
        Assert.assertEquals((Object)ReorderJoins.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10, (boolean)false, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testCombinesCriteriaAndFilters() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression b2 = p.variable("B2");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression c2 = p.variable("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        RowExpression bcFilter = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.GREATER_THAN, c2.getType(), (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)c2, (Object)Expressions.constant((Object)0L, (Type)BigintType.BIGINT))), Expressions.call((String)OperatorType.NOT_EQUAL.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.NOT_EQUAL, c2.getType(), (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)c2, (Object)Expressions.constant((Object)7L, (Type)BigintType.BIGINT))), Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.GREATER_THAN, b2.getType(), c2.getType()), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)b2, (Object)c2))});
        CallExpression add = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)this.functionResolution.arithmeticFunction(OperatorType.ADD, a1.getType(), c1.getType()), (Type)a1.getType(), (List)ImmutableList.of((Object)a1, (Object)c1));
        CallExpression abcFilter = Expressions.call((String)OperatorType.LESS_THAN.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.LESS_THAN, add.getType(), b1.getType()), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)add, (Object)b1));
        JoinNode joinNode = p.join(JoinType.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinType.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.of(bcFilter)), (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.of(abcFilter));
        MultiJoinNode expected = new MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)valuesA, (Object)valuesB, (Object)valuesC)), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression((RowExpression)b1, (RowExpression)c1), this.createEqualsExpression((RowExpression)a1, (RowExpression)b1), bcFilter, abcFilter}), (List)ImmutableList.of((Object)a1, (Object)b1, (Object)b2, (Object)c1, (Object)c2), Assignments.builder().build(), false, Optional.empty());
        Assert.assertEquals((Object)ReorderJoins.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10, (boolean)false, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testConvertsBushyTrees() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression d1 = p.variable("D1");
        VariableReferenceExpression d2 = p.variable("D2");
        VariableReferenceExpression e1 = p.variable("E1");
        VariableReferenceExpression e2 = p.variable("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode joinNode = p.join(JoinType.INNER, (PlanNode)p.join(JoinType.INNER, (PlanNode)p.join(JoinType.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty()), (PlanNode)valuesC, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty()), (PlanNode)p.join(JoinType.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<VariableReferenceExpression>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty()), (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1, (Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        MultiJoinNode expected = MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC, valuesD, valuesE}).setFilter(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression((RowExpression)a1, (RowExpression)b1), this.createEqualsExpression((RowExpression)a1, (RowExpression)c1), this.createEqualsExpression((RowExpression)d1, (RowExpression)e1), this.createEqualsExpression((RowExpression)d2, (RowExpression)e2), this.createEqualsExpression((RowExpression)b1, (RowExpression)e1)})).setOutputVariables(new VariableReferenceExpression[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)5, (boolean)false, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testMoreThanJoinLimit() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression d1 = p.variable("D1");
        VariableReferenceExpression d2 = p.variable("D2");
        VariableReferenceExpression e1 = p.variable("E1");
        VariableReferenceExpression e2 = p.variable("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode join1 = p.join(JoinType.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        JoinNode join2 = p.join(JoinType.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<VariableReferenceExpression>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        JoinNode joinNode = p.join(JoinType.INNER, (PlanNode)p.join(JoinType.INNER, (PlanNode)join1, (PlanNode)valuesC, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty()), (PlanNode)join2, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1, (Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        MultiJoinNode expected = MultiJoinNode.builder().setSources(new PlanNode[]{join1, join2, valuesC}).setFilter(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression((RowExpression)a1, (RowExpression)c1), this.createEqualsExpression((RowExpression)b1, (RowExpression)e1)})).setOutputVariables(new VariableReferenceExpression[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)2, (boolean)true, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testProjectNodesBetweenJoinNodesAreFlattenedForComplexEquiJoins() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression d1 = p.variable("D1");
        VariableReferenceExpression e1 = p.variable("E1");
        VariableReferenceExpression sum = p.variable("SUM");
        VariableReferenceExpression rename = p.variable("RENAME");
        VariableReferenceExpression renamePlusSum = p.variable("RENAME_PLUS_SUM");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1);
        ValuesNode valuesE = p.values(e1);
        Assignments assignmentA1PlusB1 = Assignments.builder().put(sum, this.createAddExpression((RowExpression)a1, (RowExpression)b1)).build();
        Assignments assignmentRenameC1 = Assignments.builder().put(rename, (RowExpression)c1).build();
        Assignments assignmentRenamePlusSum = Assignments.builder().put(renamePlusSum, this.createAddExpression((RowExpression)rename, (RowExpression)sum)).build();
        ProjectNode projectOverJoin3 = p.project(assignmentRenamePlusSum, (PlanNode)p.join(JoinType.INNER, (PlanNode)p.project(assignmentA1PlusB1, (PlanNode)p.join(JoinType.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty())), (PlanNode)p.project(assignmentRenameC1, (PlanNode)p.join(JoinType.INNER, (PlanNode)valuesC, (PlanNode)valuesD, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(c1, d1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)c1), Optional.empty())), (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(sum, rename)), (List<VariableReferenceExpression>)ImmutableList.of((Object)sum, (Object)rename), Optional.empty()));
        JoinNode topMostJoinNode = p.join(JoinType.INNER, (PlanNode)valuesE, (PlanNode)projectOverJoin3, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(e1, renamePlusSum)), (List<VariableReferenceExpression>)ImmutableList.of((Object)e1, (Object)renamePlusSum), Optional.empty());
        MultiJoinNode expected = MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC, valuesD, valuesE}).setFilter(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression((RowExpression)a1, (RowExpression)b1), this.createEqualsExpression((RowExpression)c1, (RowExpression)d1), this.createEqualsExpression(this.createAddExpression((RowExpression)a1, (RowExpression)b1), (RowExpression)c1), this.createEqualsExpression((RowExpression)e1, this.createAddExpression((RowExpression)c1, this.createAddExpression((RowExpression)a1, (RowExpression)b1)))})).setAssignments(Assignments.of((VariableReferenceExpression)e1, (RowExpression)e1, (VariableReferenceExpression)renamePlusSum, (RowExpression)this.createAddExpression((RowExpression)c1, this.createAddExpression((RowExpression)a1, (RowExpression)b1)))).setOutputVariables(new VariableReferenceExpression[]{e1, c1, a1, b1}).build();
        MultiJoinNode actual = ReorderJoins.toMultiJoinNode((JoinNode)topMostJoinNode, (Lookup)Lookup.noLookup(), (int)5, (boolean)true, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator);
        Assert.assertEquals((Object)actual, (Object)expected);
        expected = MultiJoinNode.builder().setSources(new PlanNode[]{valuesE, projectOverJoin3}).setFilter(this.createEqualsExpression((RowExpression)e1, (RowExpression)renamePlusSum)).setAssignments(Assignments.of()).setOutputVariables(new VariableReferenceExpression[]{e1, renamePlusSum}).build();
        Assert.assertEquals((Object)ReorderJoins.toMultiJoinNode((JoinNode)topMostJoinNode, (Lookup)Lookup.noLookup(), (int)5, (boolean)false, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testProjectNodesWithNonDeterministicAssignmentsAreNotFlattenedForComplexEquiJoins() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression randomPlusSum = p.variable("RANDOM_PLUS_SUM");
        Assignments nonDeterministicAssignment = Assignments.builder().put(randomPlusSum, this.createAddExpression((RowExpression)this.createRandomExpression(), this.createAddExpression((RowExpression)a1, (RowExpression)b1))).build();
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ProjectNode projectWithNonDeterministicAssignment = p.project(nonDeterministicAssignment, (PlanNode)p.join(JoinType.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty()));
        JoinNode joinNodeToFlatten = p.join(JoinType.INNER, (PlanNode)projectWithNonDeterministicAssignment, (PlanNode)valuesC, (List<EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(randomPlusSum, c1)), (List<VariableReferenceExpression>)ImmutableList.of(), Optional.empty());
        MultiJoinNode expected = MultiJoinNode.builder().setSources(new PlanNode[]{projectWithNonDeterministicAssignment, valuesC}).setFilter(this.createEqualsExpression((RowExpression)randomPlusSum, (RowExpression)c1)).setAssignments(Assignments.of()).setOutputVariables(new VariableReferenceExpression[0]).build();
        Assert.assertEquals((Object)ReorderJoins.toMultiJoinNode((JoinNode)joinNodeToFlatten, (Lookup)Lookup.noLookup(), (int)5, (boolean)true, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    private CallExpression createRandomExpression() {
        return Expressions.call((String)"random", (FunctionHandle)this.functionAndTypeResolver.lookupFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0])), (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[0]);
    }

    private RowExpression createEqualsExpression(RowExpression left, RowExpression right) {
        return Expressions.call((String)OperatorType.EQUAL.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.EQUAL, left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)left, (Object)right));
    }

    private RowExpression createAddExpression(RowExpression left, RowExpression right) {
        return Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)this.functionResolution.arithmeticFunction(OperatorType.ADD, left.getType(), right.getType()), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)left, (Object)right));
    }

    private EquiJoinClause equiJoinClause(VariableReferenceExpression variable1, VariableReferenceExpression variable2) {
        return new EquiJoinClause(variable1, variable2);
    }

    private PlanBuilder planBuilder() {
        return new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.queryRunner.getMetadata());
    }
}

