/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestMergeAdjacentWindows
extends BaseRuleTest {
    private static final WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final WindowNode.Frame frameWithRangeOffset = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.PRECEDING, Optional.of(new VariableReferenceExpression(Optional.empty(), "startValue", (Type)BigintType.BIGINT)), Optional.of(new VariableReferenceExpression(Optional.empty(), "sortKeyCoercedForFrameStartComparison", (Type)BigintType.BIGINT)), WindowNode.Frame.BoundType.FOLLOWING, Optional.of(new VariableReferenceExpression(Optional.empty(), "endValue", (Type)BigintType.BIGINT)), Optional.of(new VariableReferenceExpression(Optional.empty(), "sortKeyCoercedForFrameEndComparison", (Type)BigintType.BIGINT)), Optional.of("originalStartValue"), Optional.of("originalEndValue"));
    private static final WindowNode.Frame frameWithRowOffset = new WindowNode.Frame(WindowNode.Frame.WindowType.ROWS, WindowNode.Frame.BoundType.PRECEDING, Optional.of(new VariableReferenceExpression(Optional.empty(), "startValue", (Type)BigintType.BIGINT)), Optional.empty(), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.of("startValue"), Optional.empty());
    private static final FunctionHandle SUM_FUNCTION_HANDLE = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final FunctionHandle AVG_FUNCTION_HANDLE = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("avg", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final FunctionHandle LAG_FUNCTION_HANDLE = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("lag", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final FunctionHandle RANK_FUNCTION_HANDLE = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("rank", (List)ImmutableList.of());
    private static final String columnAAlias = "ALIAS_A";
    private static final ExpectedValueProvider<DataOrganizationSpecification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"ALIAS_A"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());

    public TestMergeAdjacentWindows() {
        super(new Plugin[0]);
    }

    @Test
    public void testPlanWithoutWindowNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.values(p.variable("a"))).doesNotFire();
    }

    @Test
    public void testPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.values(p.variable("a")))).doesNotFire();
    }

    @Test
    public void testDistinctAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("sum_1"), (Object)this.newWindowNodeFunction("sum", SUM_FUNCTION_HANDLE, "b")), (PlanNode)p.values(p.variable("b"))))).doesNotFire();
    }

    @Test
    public void testIntermediateNonProjectNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(1)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_2"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.filter(p.registerVariable(p.variable("a")).rowExpression("a > 5"), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.values(p.variable("a")))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsIdenticalSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_2"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.values(p.variable("a"))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsIdenticalSpecificationsWithRangeOffset() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a", "sortkey"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, frameWithRangeOffset, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a", "sortkey"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("startValue"), (Object)this.newWindowNodeFunction("rank", RANK_FUNCTION_HANDLE, new String[0])), (PlanNode)p.values(p.variable("a"), p.variable("sortkey"))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsIdenticalSpecificationsWithOffset() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a", "sortkey"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, frameWithRowOffset, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a", "sortkey"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("startValue"), (Object)this.newWindowNodeFunction("rank", RANK_FUNCTION_HANDLE, new String[0])), (PlanNode)p.values(p.variable("a"), p.variable("sortkey"))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsDistinctSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_2"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.values(p.variable("a"), p.variable("b"))))).doesNotFire();
    }

    @Test
    public void testIdenticalAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("sum_1"), (Object)this.newWindowNodeFunction("sum", SUM_FUNCTION_HANDLE, "a")), (PlanNode)p.values(p.variable("a"))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))).addFunction(PlanMatchPattern.functionCall("sum", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0))));
    }

    @Test
    public void testIntermediateProjectNodes() {
        String oneAlias = "ALIAS_one";
        String unusedAlias = "ALIAS_unused";
        String lagOutputAlias = "ALIAS_lagOutput";
        String avgOutputAlias = "ALIAS_avgOutput";
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(2)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("lagOutput"), (Object)this.newWindowNodeFunction("lag", LAG_FUNCTION_HANDLE, "a", "one")), (PlanNode)p.project(Assignments.builder().put(p.variable("one"), (RowExpression)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)).putAll(AssignmentUtils.identityAssignments((Collection)ImmutableList.of((Object)p.variable("a"), (Object)p.variable("avgOutput")))).build(), (PlanNode)p.project(AssignmentUtils.identityAssignments((VariableReferenceExpression[])new VariableReferenceExpression[]{p.variable("a"), p.variable("avgOutput"), p.variable("unused")}), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avgOutput"), (Object)this.newWindowNodeFunction("avg", AVG_FUNCTION_HANDLE, "a")), (PlanNode)p.values(p.variable("a"), p.variable("unused"))))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)oneAlias, (Object)PlanMatchPattern.expression(oneAlias), (Object)lagOutputAlias, (Object)PlanMatchPattern.expression(lagOutputAlias), (Object)avgOutputAlias, (Object)PlanMatchPattern.expression(avgOutputAlias)), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(lagOutputAlias, PlanMatchPattern.functionCall("lag", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias, (Object)oneAlias))).addFunction(avgOutputAlias, PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)oneAlias, (Object)PlanMatchPattern.expression("CAST(1 AS bigint)"), (Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)unusedAlias, (Object)PlanMatchPattern.expression(unusedAlias)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)unusedAlias, (Object)PlanMatchPattern.expression(unusedAlias)), PlanMatchPattern.values(columnAAlias, unusedAlias))))));
    }

    private static DataOrganizationSpecification newWindowNodeSpecification(PlanBuilder planBuilder, String symbolName) {
        return new DataOrganizationSpecification((List)ImmutableList.of((Object)planBuilder.variable(symbolName, (Type)BigintType.BIGINT)), Optional.empty());
    }

    private static DataOrganizationSpecification newWindowNodeSpecification(PlanBuilder planBuilder, String symbolName, String sortkey) {
        return new DataOrganizationSpecification((List)ImmutableList.of((Object)planBuilder.variable(symbolName, (Type)BigintType.BIGINT)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Ordering(planBuilder.variable(sortkey, (Type)BigintType.BIGINT), SortOrder.ASC_NULLS_FIRST)))));
    }

    private WindowNode.Function newWindowNodeFunction(String name, FunctionHandle functionHandle, String ... symbols) {
        return new WindowNode.Function(Expressions.call((String)name, (FunctionHandle)functionHandle, (Type)BigintType.BIGINT, Arrays.stream(symbols).map(symbol -> new VariableReferenceExpression(Optional.empty(), symbol, (Type)BigintType.BIGINT)).collect(Collectors.toList())), frame, false);
    }

    private WindowNode.Function newWindowNodeFunction(String name, FunctionHandle functionHandle, WindowNode.Frame frame, String ... symbols) {
        return new WindowNode.Function(Expressions.call((String)name, (FunctionHandle)functionHandle, (Type)BigintType.BIGINT, (List)((List)Arrays.stream(symbols).map(symbol -> new VariableReferenceExpression(Optional.empty(), symbol, (Type)BigintType.BIGINT)).collect(ImmutableList.toImmutableList()))), frame, false);
    }
}

