/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestMultipleDistinctAggregationToMarkDistinct
extends BaseRuleTest {
    public TestMultipleDistinctAggregationToMarkDistinct() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoDistinct() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output1"), p.rowExpression("count(input1)")).addAggregation(p.variable("output2"), p.rowExpression("count(input2)")))).doesNotFire();
    }

    @Test
    public void testSingleDistinct() {
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output1"), p.rowExpression("count(DISTINCT input1)"), true))).doesNotFire();
    }

    @Test
    public void testMultipleAggregations() {
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input"))).addAggregation(p.variable("output1"), p.rowExpression("count(DISTINCT input)"), true).addAggregation(p.variable("output2"), p.rowExpression("sum(DISTINCT input)"), true))).doesNotFire();
    }

    @Test
    public void testDistinctWithFilter() {
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output1"), p.rowExpression("count(DISTINCT input1)"), Optional.of(p.rowExpression("input2 > 0")), Optional.empty(), true, Optional.empty()).addAggregation(p.variable("output2"), p.rowExpression("count(DISTINCT input2)"), Optional.of(p.rowExpression("input1 > 0")), Optional.empty(), true, Optional.empty()))).doesNotFire();
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))).addAggregation(p.variable("output1"), p.rowExpression("count(DISTINCT input1)"), Optional.of(p.rowExpression("input2 > 0")), Optional.empty(), true, Optional.empty()).addAggregation(p.variable("output2"), p.rowExpression("count(DISTINCT input2)"), true))).doesNotFire();
    }
}

