/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPushAggregationThroughOuterJoin
extends BaseRuleTest {
    public TestPushAggregationThroughOuterJoin() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"use_defaults_for_correlated_aggregation_pushdown_through_outer_joins", (Object)Boolean.toString(false)));
    }

    @Test
    public void testPushesAggregationThroughLeftJoin() {
        this.tester().assertThat((Rule)new PushAggregationThroughOuterJoin(this.getFunctionManager())).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L))), (PlanNode)p.values(p.variable("COL2")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("COL1"), p.variable("COL2"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL2)")).singleGroupingSet(p.variable("COL1")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COL1", (Object)PlanMatchPattern.expression("COL1"), (Object)"COALESCE", (Object)PlanMatchPattern.expression("coalesce(AVG, AVG_NULL)")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("COL1", "COL2")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL1", (Object)0)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL2"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("AVG"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"COL2"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL2", (Object)0)))), PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("AVG_NULL"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"null_literal"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"null_literal", (Object)0))))));
    }

    @Test
    public void testPushesAggregationThroughLeftJoinWithOrderByFromRightSideColumn() {
        this.tester().assertThat((Rule)new PushAggregationThroughOuterJoin(this.getFunctionManager())).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("COL3")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L, 20L))), (PlanNode)p.values(p.variable("COL2"), p.variable("COL4")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("COL1"), p.variable("COL2"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL2)"), Optional.empty(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Ordering(p.variable("COL4"), SortOrder.ASC_NULLS_LAST)))), false, Optional.empty()).singleGroupingSet(p.variable("COL1"), p.variable("COL3")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COL1", (Object)PlanMatchPattern.expression("COL1"), (Object)"COL3", (Object)PlanMatchPattern.expression("COL3"), (Object)"COALESCE", (Object)PlanMatchPattern.expression("coalesce(AVG, AVG_NULL)")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("COL1", "COL2")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL1", (Object)0, (Object)"COL3", (Object)0)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL2"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("AVG"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"COL2"), (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("COL4", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"COL2", (Object)"COL4")))), PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("AVG_NULL"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"null_literal"), (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("null_literal2", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"null_literal", (Object)"null_literal2"))))));
    }

    @Test
    public void testPushesAggregationThroughRightJoin() {
        this.tester().assertThat((Rule)new PushAggregationThroughOuterJoin(this.getFunctionManager())).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.RIGHT, (PlanNode)p.values(p.variable("COL2")), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("COL2"), p.variable("COL1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL2"), (Object)p.variable("COL1")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL2)")).singleGroupingSet(p.variable("COL1")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COALESCE", (Object)PlanMatchPattern.expression("coalesce(AVG, AVG_NULL)"), (Object)"COL1", (Object)PlanMatchPattern.expression("COL1")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("COL2", "COL1")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL2"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("AVG"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"COL2"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL2", (Object)0))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL1", (Object)0))), PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("AVG_NULL"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"null_literal"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"null_literal", (Object)0))))));
    }

    @Test
    public void testDoesNotFireWhenNotDistinct() {
        this.tester().assertThat((Rule)new PushAggregationThroughOuterJoin(this.getFunctionManager())).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 11L))), (PlanNode)p.values(p.variable("COL2")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("COL1"), p.variable("COL2"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL2)")).singleGroupingSet(p.variable("COL1")))).doesNotFire();
        this.tester().assertThat((Rule)new PushAggregationThroughOuterJoin(this.getFunctionManager())).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.project(AssignmentUtils.identityAssignments((VariableReferenceExpression[])new VariableReferenceExpression[]{p.variable("COL1", (Type)BigintType.BIGINT)}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(p.variable("COL1"), p.variable("unused")).source((PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("unused")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L, 1L), PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L, 2L)))))), (PlanNode)p.values(p.variable("COL2")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("COL1"), p.variable("COL2"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("AVG(COL2)")).singleGroupingSet(p.variable("COL1")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenGroupingOnInner() {
        this.tester().assertThat((Rule)new PushAggregationThroughOuterJoin(this.getFunctionManager())).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L))), (PlanNode)p.values(p.variable("COL2"), p.variable("COL3")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("COL1"), p.variable("COL2"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL2)")).singleGroupingSet(p.variable("COL1"), p.variable("COL3")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenAggregationDoesNotHaveSymbols() {
        this.tester().assertThat((Rule)new PushAggregationThroughOuterJoin(this.getFunctionManager())).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 10L))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL2")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 20L))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("COL1"), p.variable("COL2"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("COL1"), (Object)p.variable("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.variable("SUM", (Type)DoubleType.DOUBLE), p.rowExpression("sum(COL1)")).singleGroupingSet(p.variable("COL1")))).doesNotFire();
    }
}

