/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TestTableConstraintsConnectorFactory;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantDistinct;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRedundantDistinctRemoval
extends BaseRuleTest {
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestRedundantDistinctRemoval() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(true)), Optional.of(1), (ConnectorFactory)new TestTableConstraintsConnectorFactory(1));
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver()));
    }

    @Test
    public void singleTableTests() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT acctbal FROM customer WHERE custkey = 100").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT orderkey, custkey FROM orders").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT * FROM (VALUES (1,2)) t1 (c1, c2)").matches(PlanMatchPattern.any(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT orderkey, custkey FROM orders").matches(PlanMatchPattern.any(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Rule)new RemoveRedundantDistinct(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression c = p.variable("c");
            VariableReferenceExpression unique = p.variable("unique");
            return p.aggregation(builder -> builder.singleGroupingSet(c, unique).source((PlanNode)p.assignUniqueId(unique, (PlanNode)p.values(5, c))));
        }).matches(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT custkey FROM orders").matches(PlanMatchPattern.any(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT custkey+5 FROM customer").validates(plan -> this.assertNodePresentInPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT acctbal FROM customer WHERE custkey + 5= 100").validates(plan -> this.assertNodePresentInPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT totalprice from orders where Orderkey in (1,2,3,3)").validates(plan -> this.assertNodePresentInPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT totalprice FROM orders WHERE orderkey = (SELECT orderkey from lineitem limit 1)").validates(plan -> this.assertNodePresentInPlan((Plan)plan, AggregationNode.class));
    }

    @Test
    public void testRedundantDistinctRemovalOneToNJoin() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct * from orders o inner join customer c on o.custkey = c.custkey").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct l.orderkey from orders o inner join customer c on o.custkey = c.custkey inner join lineitem l on o.orderkey = l.orderkey where o.orderkey = 10 and l.linenumber = 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct o.orderkey from orders o inner join customer c on o.custkey = c.custkey inner join lineitem l on o.orderkey = l.orderkey where o.orderkey = 10 and l.linenumber = 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct c.custkey from orders o inner join customer c on o.custkey = c.custkey inner join lineitem l on o.orderkey = l.orderkey where o.orderkey = 10 and l.linenumber = 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT distinct orderkey FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber in (1,2,3,4))").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
    }

    @Test
    public void testRedundantDistinctRemovalNtoMJoin() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct o.orderkey, c.custkey from orders o inner join customer c on o.custkey > c.custkey").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
    }

    @Test
    public void testRedundantDistinctRemovalOneToOneJoin() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct o.orderkey, l.linenumber from orders o inner join lineitem l on o.orderkey = l.orderkey where l.linenumber = 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct l.orderkey, l.linenumber from orders o inner join lineitem l on o.orderkey = l.orderkey where l.linenumber = 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT DISTINCT o.orderkey FROM orders o LEFT JOIN customer c ON o.custkey = c.custkey").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, AggregationNode.class));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule)new RemoveRedundantDistinct(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression c = p.variable("c");
            return p.aggregation(builder -> builder.singleGroupingSet(c).source((PlanNode)p.limit(5L, (PlanNode)p.values(5, c))));
        }).doesNotFire();
        this.tester().assertThat((Rule)new RemoveRedundantDistinct(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression c = p.variable("c");
            return p.aggregation(builder -> builder.groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)c), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)p.limit(1L, (PlanNode)p.values(5, c))));
        }).doesNotFire();
    }

    @Test
    public void testFeatureDisabled() {
        RuleTester newTester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(false)));
        newTester.assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantDistinct()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct o.orderkey, l.linenumber from orders o inner join lineitem l on o.orderkey = l.orderkey where l.linenumber = 10").validates(plan -> this.assertNodePresentInPlan((Plan)plan, AggregationNode.class));
    }
}

