/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TestTableConstraintsConnectorFactory;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantSort;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRedundantSortRemoval
extends BaseRuleTest {
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestRedundantSortRemoval() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(true)), Optional.of(1), (ConnectorFactory)new TestTableConstraintsConnectorFactory(1));
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver()));
    }

    @Test
    public void singleTableTests() {
        this.tester().assertThat((Rule)new RemoveRedundantSort(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.aggregation(builder -> builder.source((PlanNode)p.values(p.variable("foo"))).addAggregation(p.variable("c"), p.rowExpression("count(foo)")).globalGrouping()))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select max(totalprice) from orders order by 1").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, SortNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select count(*), totalprice from orders where totalprice = 101.10 group by totalprice order by 1, 2").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, SortNode.class));
        this.tester().assertThat((Rule)new RemoveRedundantSort(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.values(p.variable("foo")))).matches(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT totalprice FROM orders WHERE orderkey = 10 ORDER BY totalprice").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, SortNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT quantity FROM lineitem WHERE orderkey = 10 and linenumber = 100 ORDER BY quantity").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, SortNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT quantity FROM lineitem WHERE orderkey = 10 ORDER BY quantity").validates(plan -> this.assertNodePresentInPlan((Plan)plan, SortNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select max(totalprice) from orders order by 1").validates(plan -> this.assertNodePresentInPlan((Plan)plan, SortNode.class));
    }

    @Test
    public void complexQueryTests() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey=10 order by totalprice").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, SortNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey>10 order by totalprice").validates(plan -> this.assertNodePresentInPlan((Plan)plan, SortNode.class));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule)new RemoveRedundantSort(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.aggregation(builder -> builder.source((PlanNode)p.values(20, p.variable("foo"))).addAggregation(p.variable("c"), p.rowExpression("count(foo)")).singleGroupingSet(p.variable("foo"))))).doesNotFire();
    }

    @Test
    public void testFeatureDisabled() {
        RuleTester newTester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(false)));
        newTester.assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select max(totalprice) from orders order by 1").validates(plan -> this.assertNodePresentInPlan((Plan)plan, SortNode.class));
    }
}

