/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TestingColumnHandle;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RemoveCrossJoinWithConstantInput;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingEnvironment;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestRemoveCrossJoinWithConstantInput
extends BaseRuleTest {
    private static final MethodHandle KEY_NATIVE_EQUALS = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT});
    private static final MethodHandle KEY_BLOCK_EQUALS = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_EQUALS, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));
    private static final MethodHandle KEY_NATIVE_HASH_CODE = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{BigintType.BIGINT});
    private static final MethodHandle KEY_BLOCK_HASH_CODE = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_HASH_CODE, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));

    public TestRemoveCrossJoinWithConstantInput() {
        super(new Plugin[0]);
    }

    @Test
    public void testOneColumnValuesNode() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("right_k1")), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)))), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testOneColumnValuesNodeArray() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            VariableReferenceExpression rightKey = p.variable("right_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)rightKey), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)new LongArrayBlock(2, Optional.empty(), new long[2]), (Type)new ArrayType((Type)BigintType.BIGINT))))), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testOneColumnValuesNodeMap() {
        long[] keys = new long[]{1L, 2L};
        LongArrayBlock longArrayBlock = new LongArrayBlock(2, Optional.empty(), keys);
        int[] offsets = new int[]{0, 2, 4, 6};
        MapBlock mapBlock = MapBlock.fromKeyValueBlock((int)2, Optional.ofNullable(null), (int[])offsets, (Block)longArrayBlock, (Block)longArrayBlock);
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(arg_0 -> TestRemoveCrossJoinWithConstantInput.lambda$testOneColumnValuesNodeMap$2((Block)mapBlock, arg_0)).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testOneColumnValuesNodeNonDeterministic() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("right_k1")), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)p.rowExpression("random()")))), new EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testOneColumnValuesNodeWithJoinFilter() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("right_k1")), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)))), p.rowExpression("left_k1+right_k1 > 2"), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testMultipleColumnsValuesNode() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            VariableReferenceExpression rightK1 = p.variable("right_k1", (Type)BigintType.BIGINT);
            VariableReferenceExpression rightK2 = p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)rightK1, (Object)rightK2), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT)))), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testMultipleRowsValuesNode() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("right_k1")), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)), (Object)ImmutableList.of((Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT)))), new EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testEmptyValuesNode() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testProjectConstant() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            VariableReferenceExpression rightKey = p.variable("right_k", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.project(PlanBuilder.assignment(rightKey, p.rowExpression("1")), (PlanNode)p.values(1, new VariableReferenceExpression[0])), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testProjectConstantMultipleRows() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            VariableReferenceExpression rightKey = p.variable("right_k", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.project(PlanBuilder.assignment(rightKey, p.rowExpression("1")), (PlanNode)p.values(2, new VariableReferenceExpression[0])), new EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testMultipleProjects() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            VariableReferenceExpression rightKey = p.variable("right_k", (Type)new ArrayType((Type)BigintType.BIGINT));
            VariableReferenceExpression rightKey2 = p.variable("right_k2", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.project(PlanBuilder.assignment(rightKey, (RowExpression)rightKey2), (PlanNode)p.project(PlanBuilder.assignment(rightKey2, p.rowExpression("1")), (PlanNode)p.values(1, new VariableReferenceExpression[0]))), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testOneColumnValuesNodeOnLeft() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("right_k1")), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)))), (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testOneColumnValuesNodeExpression() {
        this.tester().assertThat((Rule)new RemoveCrossJoinWithConstantInput(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").on(p -> {
            VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            VariableReferenceExpression rightKey1 = p.variable("right_k1", (Type)BigintType.BIGINT);
            VariableReferenceExpression rightKey2 = p.variable("right_k2", (Type)VarcharType.VARCHAR);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)), (Object)ImmutableList.of((Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT)))), (PlanNode)p.project(PlanBuilder.assignment(rightKey2, p.rowExpression("cast(right_k1 as varchar)")), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)rightKey1), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT))))), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"left_k1", (Object)PlanMatchPattern.expression("left_k1"), (Object)"right_k2", (Object)PlanMatchPattern.expression("cast(1 as varchar)")), PlanMatchPattern.values("left_k1")));
    }

    private static /* synthetic */ PlanNode lambda$testOneColumnValuesNodeMap$2(Block mapBlock, PlanBuilder p) {
        VariableReferenceExpression leftKey = p.variable("left_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
        VariableReferenceExpression rightKey = p.variable("right_k1", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE));
        return p.join(JoinType.INNER, (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)leftKey, (Object)new TestingColumnHandle("col"))), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)rightKey), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)mapBlock, (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE))))), new EquiJoinClause[0]);
    }
}

