/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RemoveMapCastRule;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.Test;

public class TestRemoveMapCastRule
extends BaseRuleTest {
    public TestRemoveMapCastRule() {
        super(new Plugin[0]);
    }

    @Test
    public void testSubscriptCast() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)new SimplifyRowExpressions(this.getMetadata(), this.getExpressionManager()).rules()).addAll((Iterable)new RemoveMapCastRule(this.getFunctionManager()).rules()).build()).setSystemProperty("remove_map_cast", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)DoubleType.DOUBLE);
            VariableReferenceExpression feature = p.variable("feature", PlannerUtils.createMapType((FunctionAndTypeManager)this.getFunctionManager(), (Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE));
            VariableReferenceExpression key = p.variable("key", (Type)BigintType.BIGINT);
            return p.project(PlanBuilder.assignment(a, p.rowExpression("cast(feature as map<bigint, double>)[key]")), (PlanNode)p.values(feature, key));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("feature[cast(key as integer)]")), PlanMatchPattern.values("feature", "key")));
    }

    @Test
    public void testElementAtCast() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)new SimplifyRowExpressions(this.getMetadata(), this.getExpressionManager()).rules()).addAll((Iterable)new RemoveMapCastRule(this.getFunctionManager()).rules()).build()).setSystemProperty("remove_map_cast", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)DoubleType.DOUBLE);
            VariableReferenceExpression feature = p.variable("feature", PlannerUtils.createMapType((FunctionAndTypeManager)this.getFunctionManager(), (Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE));
            VariableReferenceExpression key = p.variable("key", (Type)BigintType.BIGINT);
            return p.project(PlanBuilder.assignment(a, p.rowExpression("element_at(cast(feature as map<bigint, double>), key)")), (PlanNode)p.values(feature, key));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("element_at(feature, try_cast(key as integer))")), PlanMatchPattern.values("feature", "key")));
    }
}

