/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RemoveTrivialFilters;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestRemoveTrivialFilters
extends BaseRuleTest {
    public TestRemoveTrivialFilters() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new RemoveTrivialFilters()).on(p -> p.filter(p.rowExpression("1 = 1"), (PlanNode)p.values())).doesNotFire();
    }

    @Test
    public void testRemovesTrueFilter() {
        this.tester().assertThat((Rule)new RemoveTrivialFilters()).on(p -> p.filter(p.rowExpression("TRUE"), (PlanNode)p.values())).matches(PlanMatchPattern.values(new String[0]));
    }

    @Test
    public void testRemovesFalseFilter() {
        this.tester().assertThat((Rule)new RemoveTrivialFilters()).on(p -> p.filter(p.rowExpression("FALSE"), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 1L))))).matches(PlanMatchPattern.values("a"));
    }
}

