/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.RewriteCaseExpressionPredicate;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRewriteCaseExpressionPredicate
extends BaseRuleTest {
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"col1", (Object)IntegerType.INTEGER, (Object)"col2", (Object)IntegerType.INTEGER, (Object)"col3", (Object)VarcharType.VARCHAR);
    private final TestingRowExpressionTranslator testSqlToRowExpressionTranslator = new TestingRowExpressionTranslator();

    public TestRewriteCaseExpressionPredicate() {
        super(new Plugin[0]);
    }

    @Test
    public void testRewriterDoesNotFireOnPredicateWithoutCaseExpression() {
        this.assertRewriteDoesNotFire("col1 > 1");
    }

    @Test
    public void testRewriterDoesNotFireOnPredicateWithoutComparisonFunction() {
        this.assertRewriteDoesNotFire("(case when col1=1 then 'case1' when col2=2 then 'case2' else 'default' end)");
    }

    @Test
    public void testRewriterDoesNotFireOnPredicateWithFunctionCallOnComparisonValue() {
        this.assertRewriteDoesNotFire("(case when col1=1 then 'case1' when col2=2 then 'case2' else 'default' end) = upper('case1')");
        this.assertRewriteDoesNotFire("(case when col1=1 then 10 when col2=2 then 20 else 30 end) = ceil(col1)");
    }

    @Test
    public void testRewriterDoesNotFireOnInvalidSearchCaseExpression() {
        this.assertRewriteDoesNotFire("(case when col1=1 then 'case1' when col2=2 then 'case2' else 'default' end) = 'case1'");
        this.assertRewriteDoesNotFire("(case when col1=1 then 'case1' when ceil(col1)=2 then 'case2' else 'default' end) = 'case1'");
        this.assertRewriteDoesNotFire("(case when col1>1 then 1 when col1>2 then 2 else 3 end) > 2");
        this.assertRewriteDoesNotFire("(case when col1<1 then 1 when col1<2 then 2 else 3 end) < 2");
        this.assertRewriteDoesNotFire("(case when col1=1 then 'case1' when col1=ceil(1) then 'case2' else 'default' end) = 'case1'");
        this.assertRewriteDoesNotFire("(case when col1=1 then 'case1' when col1=1 then 'case2' else 'default' end) = 'case1'");
    }

    @Test
    public void testSimpleCaseExpressionRewrite() {
        this.assertRewrittenExpression("(case col1 when 1 then 'case1' when 2 then 'case2' else 'default' end) = 'case1'", "('case1' = 'case1' AND col1 = 1) OR ('case2' = 'case1' AND col1 = 2) OR ('default' = 'case1' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case col1 when 1 then 'case1' when 2 then 'case2' else 'default' end) = 'case2'", "('case1' = 'case2' AND col1 = 1) OR ('case2' = 'case2' AND col1 = 2) OR ('default' = 'case2' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case col1 when 1 then 'case1' when 2 then 'case2' else 'default' end) = 'default'", "('case1' = 'default' AND col1 = 1) OR ('case2' = 'default' AND col1 = 2) OR ('default' = 'default' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
    }

    @Test
    public void testSearchedCaseExpressionRewrite() {
        this.assertRewrittenExpression("(case when col1=1 then 'case1' when col1=2 then 'case2' else 'default' end) = 'case1'", "('case1' = 'case1' AND col1 = 1) OR ('case2' = 'case1' AND col1 = 2) OR ('default' = 'case1' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case when lower(col3)='a' then 'case1' when lower(col3)='b' then 'case2' else 'default' end) = 'case1'", "('case1' = 'case1' AND lower(col3) = 'a') OR ('case2' = 'case1' AND lower(col3) = 'b') OR ('default' = 'case1' AND (NOT(lower(col3) = 'a') AND NOT(lower(col3) = 'b')))");
        this.assertRewrittenExpression("(case when ceil(col1)=1 then 'case1' when ceil(col1)=2 then 'case2' else 'default' end) = 'default'", "('case1' = 'default' AND ceil(col1) = 1) OR ('case2' = 'default' AND ceil(col1) = 2) OR ('default' = 'default' AND (NOT(ceil(col1) = 1) AND NOT(ceil(col1) = 2)))");
    }

    @Test
    public void testRewriterOnCaseExpressionInRightSideOfComparisonFunction() {
        this.assertRewrittenExpression("(case col1 when 1 then 10 when 2 then 20 else 30 end) > 20", "(10 > 20 AND col1 = 1) OR (20 > 20 AND col1 = 2) OR (30 > 20 AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("25 < (case col1 when 1 then 10 when 2 then 20 else 30 end)", "(25 < 10 AND col1 = 1) OR (25 < 20 AND col1 = 2) OR (25 < 30 AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
    }

    @Test
    public void testRewriterWhenMoreThanOneConditionMatches() {
        this.assertRewrittenExpression("(case col1 when 1 then 'case' when 2 then 'case' else 'default' end) = 'case'", "('case' = 'case' AND col1 = 1) OR ('case' = 'case' AND col1 = 2) OR ('default' = 'case' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case col1 when 1 then concat('default', 'AndCase1') when 2 then 'case2' else 'defaultAndCase1' end) = 'defaultAndCase1'", "(concat('default', 'AndCase1') = 'defaultAndCase1' AND col1 = 1) OR ('case2' = 'defaultAndCase1' AND col1 = 2) OR ('defaultAndCase1' = 'defaultAndCase1' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case col3 when 'data1' then 'case1' when 'data2' then 'case2' else col3 end) = 'case1'", "('case1' = 'case1' AND col3 = 'data1') OR ('case2' = 'case1' AND col3 = 'data2') OR (col3 = 'case1' AND (NOT(col3 = 'data1') AND NOT(col3 = 'data2')))");
    }

    @Test
    public void testRewriterOnCaseExpressionWithoutElseClause() {
        this.assertRewrittenExpression("(case col1 when 1 then 'case1' when 2 then 'case2' end) = 'case1'", "('case1' = 'case1' AND col1 = 1) OR ('case2' = 'case1' AND col1 = 2) OR (null = 'case1' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case col1 when 1 then 'case1' when 2 then 'case2' end) = 'case3'", "('case1' = 'case3' AND col1 = 1) OR ('case2' = 'case3' AND col1 = 2) OR (null = 'case3' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case col1 when 1 then 'case1' when 2 then 'case2' end) = 'case2'", "('case1' = 'case2' AND col1 = 1) OR ('case2' = 'case2' AND col1 = 2) OR (null = 'case2' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
    }

    @Test
    public void testRewriterOnCaseExpressionWithCastFunction() {
        this.assertRewrittenExpression("cast((case col1 when 1 then 'case11' when 2 then 'case2' else 'def' end) as VARCHAR(6)) = 'case11'", "(cast('case11' as VARCHAR(6)) = 'case11' AND col1 = 1) OR (cast('case2' as VARCHAR(6)) = 'case11' AND col1 = 2) OR (cast('def' as VARCHAR(6)) = 'case11' AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case col1 when 1 then 'case1' when 2 then 'case2' else 'default' end) = cast('case1' AS VARCHAR)", "('case1' = cast('case1' AS VARCHAR) AND col1 = 1) OR ('case2' = cast('case1' AS VARCHAR) AND col1 = 2) OR ('default' = cast('case1' AS VARCHAR) AND (NOT(col1 = 1) AND NOT(col1 = 2)))");
        this.assertRewrittenExpression("(case when col1=cast('1' as INTEGER) then 'case1' when col1=cast('2' as INTEGER) then 'case2' else 'default' end) = 'case1'", "('case1' = 'case1' AND col1 = cast('1' as INTEGER)) OR ('case2' = 'case1' AND col1 = cast('2' as INTEGER)) OR ('default' = 'case1' AND (NOT(col1 = cast('1' as INTEGER)) AND NOT(col1 = cast('2' as INTEGER))))");
    }

    @Test
    public void testIfSubExpressionsAreRewritten() {
        this.assertRewrittenExpression("((case col1 when 1 then 'a' else 'b' end) = 'a') = true", "(('a' = 'a' AND col1 = 1) OR ('b' = 'a' AND NOT(col1=1))) = true");
    }

    private void assertRewriteDoesNotFire(String expression) {
        this.tester().assertThat(new RewriteCaseExpressionPredicate(METADATA.getFunctionAndTypeManager()).filterRowExpressionRewriteRule()).setSystemProperty("optimize_case_expression_predicate", "true").on(p -> p.filter(this.testSqlToRowExpressionTranslator.translate(expression, TYPE_MAP), (PlanNode)p.values())).doesNotFire();
    }

    private void assertRewrittenExpression(String inputExpressionStr, String expectedExpressionStr) {
        RowExpression inputExpression = this.testSqlToRowExpressionTranslator.translate(inputExpressionStr, TYPE_MAP);
        this.tester().assertThat(new RewriteCaseExpressionPredicate(METADATA.getFunctionAndTypeManager()).filterRowExpressionRewriteRule()).setSystemProperty("optimize_case_expression_predicate", "true").on(p -> p.filter(inputExpression, (PlanNode)p.values(p.variable("col1"), p.variable("col2"), p.variable("col3")))).matches(PlanMatchPattern.filter(expectedExpressionStr, PlanMatchPattern.values("col1", "col2", "col3")));
    }
}

