/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import java.util.Collections;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformUncorrelatedInPredicateSubqueryToSemiJoin
extends BaseRuleTest {
    public TestTransformUncorrelatedInPredicateSubqueryToSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNoCorrelation() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(Assignments.of(), Collections.emptyList(), (PlanNode)p.values(), (PlanNode)p.values())).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNonInPredicateSubquery() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)new ExistsExpression(Optional.empty(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)), Collections.emptyList(), (PlanNode)p.values(), (PlanNode)p.values())).doesNotFire();
    }

    @Test
    public void testFiresForInPredicate() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.inSubquery((VariableReferenceExpression)p.variable("y"), (VariableReferenceExpression)p.variable("z"))), Collections.emptyList(), (PlanNode)p.values(p.variable("y")), (PlanNode)p.values(p.variable("z")))).matches(PlanMatchPattern.node(SemiJoinNode.class, PlanMatchPattern.values("y"), PlanMatchPattern.values("z")));
    }
}

