/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class TestAddPartitionToSortRule
implements Rule<SortNode> {
    public Pattern<SortNode> getPattern() {
        return Pattern.typeOf(SortNode.class);
    }

    public Rule.Result apply(SortNode node, Captures captures, Rule.Context context) {
        if (!node.getPartitionBy().isEmpty()) {
            return Rule.Result.empty();
        }
        Optional<VariableReferenceExpression> partition = node.getSource().getOutputVariables().stream().filter(x -> x.getType().equals(BigintType.BIGINT)).findFirst();
        Preconditions.checkState((boolean)partition.isPresent());
        return Rule.Result.ofPlanNode((PlanNode)new SortNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getSource(), node.getOrderingScheme(), node.isPartial(), (List)ImmutableList.of((Object)partition.get())));
    }
}

