/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestMergeWindows
extends BasePlanTest {
    private static final String SUPPKEY_ALIAS = "SUPPKEY";
    private static final String ORDERKEY_ALIAS = "ORDERKEY";
    private static final String SHIPDATE_ALIAS = "SHIPDATE";
    private static final String QUANTITY_ALIAS = "QUANTITY";
    private static final String DISCOUNT_ALIAS = "DISCOUNT";
    private static final String EXTENDEDPRICE_ALIAS = "EXTENDEDPRICE";
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DOQSS = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity", (Object)"DISCOUNT", (Object)"discount", (Object)"SUPPKEY", (Object)"suppkey", (Object)"ORDERKEY", (Object)"orderkey", (Object)"SHIPDATE", (Object)"shipdate"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DOQS = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity", (Object)"DISCOUNT", (Object)"discount", (Object)"SUPPKEY", (Object)"suppkey", (Object)"ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DEOQS = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity", (Object)"SUPPKEY", (Object)"suppkey", (Object)"ORDERKEY", (Object)"orderkey", (Object)"DISCOUNT", (Object)"discount", (Object)"EXTENDEDPRICE", (Object)"extendedprice"));
    private static final Optional<WindowFrame> COMMON_FRAME = Optional.of(new WindowFrame(WindowFrame.Type.ROWS, new FrameBound(FrameBound.Type.UNBOUNDED_PRECEDING), Optional.of(new FrameBound(FrameBound.Type.CURRENT_ROW))));
    private static final Optional<WindowFrame> UNSPECIFIED_FRAME = Optional.empty();
    private final ExpectedValueProvider<DataOrganizationSpecification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"SUPPKEY"), (List<String>)ImmutableList.of((Object)"ORDERKEY"), (Map<String, SortOrder>)ImmutableMap.of((Object)"ORDERKEY", (Object)SortOrder.ASC_NULLS_LAST));
    private final ExpectedValueProvider<DataOrganizationSpecification> specificationB = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"ORDERKEY"), (List<String>)ImmutableList.of((Object)"SHIPDATE"), (Map<String, SortOrder>)ImmutableMap.of((Object)"SHIPDATE", (Object)SortOrder.ASC_NULLS_LAST));

    public TestMergeWindows() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public TestMergeWindows(Map<String, String> sessionProperties) {
        super(sessionProperties);
    }

    @Test
    public void testMergeableWindowsAllOptimizers() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.anyNot(WindowNode.class, LINEITEM_TABLESCAN_DOQSS)))));
        this.assertPlan(sql, pattern);
    }

    @Test
    public void testIdenticalWindowSpecificationsABA() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQSS))));
    }

    @Test
    public void testIdenticalWindowSpecificationsABcpA() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, LAG(quantity, 1, 0.0E0) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.functionCall("lag", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS, (Object)"ONE", (Object)"ZERO"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ONE", (Object)PlanMatchPattern.expression("CAST(1 AS bigint)"), (Object)"ZERO", (Object)PlanMatchPattern.expression("0.0E0")), LINEITEM_TABLESCAN_DOQSS))))));
    }

    @Test
    public void testIdenticalWindowSpecificationsABfilterA() {
        String sql = "SELECT  sum_discount_A,   SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A,   SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B FROM (  SELECT    *,     SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A   FROM lineitem)WHERE shipdate IS NOT NULL";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.filter("SHIPDATE IS NOT NULL", PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), LINEITEM_TABLESCAN_DOQSS)))))));
    }

    @Test
    public void testIdenticalWindowSpecificationsAAcpA() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, LAG(quantity, 1, 0.0E0) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))).addFunction(PlanMatchPattern.functionCall("lag", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS, (Object)"ONE", (Object)"ZERO"))).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ONE", (Object)PlanMatchPattern.expression("CAST(1 AS bigint)"), (Object)"ZERO", (Object)PlanMatchPattern.expression("0.0E0")), LINEITEM_TABLESCAN_DOQS)))));
    }

    @Test
    public void testIdenticalWindowSpecificationsAAfilterA() {
        String sql = "SELECT  sum_discount_A,   SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A,   AVG(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) avg_quantity_A FROM (  SELECT    *,     SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A   FROM lineitem)WHERE shipdate IS NOT NULL";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))).addFunction(PlanMatchPattern.functionCall("avg", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.filter("SHIPDATE IS NOT NULL", PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), LINEITEM_TABLESCAN_DOQSS))))));
    }

    @Test
    public void testIdenticalWindowSpecificationsDefaultFrame() {
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        ExpectedValueProvider<DataOrganizationSpecification> specificationD = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (List<String>)ImmutableList.of((Object)SHIPDATE_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)SHIPDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        String sql = "SELECT SUM(quantity) OVER (PARTITION By suppkey ORDER BY orderkey), SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate), SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey) FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.functionCall("sum", UNSPECIFIED_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", UNSPECIFIED_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationD).addFunction(PlanMatchPattern.functionCall("sum", UNSPECIFIED_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQSS))));
    }

    @Test
    public void testMergeDifferentFrames() {
        Optional<WindowFrame> frameC = Optional.of(new WindowFrame(WindowFrame.Type.ROWS, new FrameBound(FrameBound.Type.UNBOUNDED_PRECEDING), Optional.of(new FrameBound(FrameBound.Type.CURRENT_ROW))));
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        Optional<WindowFrame> frameD = Optional.of(new WindowFrame(WindowFrame.Type.ROWS, new FrameBound(FrameBound.Type.CURRENT_ROW), Optional.of(new FrameBound(FrameBound.Type.UNBOUNDED_FOLLOWING))));
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C, AVG(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) avg_quantity_D, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_C FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.functionCall("avg", frameD, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", frameC, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", frameC, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQS)));
    }

    @Test
    public void testMergeDifferentFramesWithDefault() {
        Optional<WindowFrame> frameD = Optional.of(new WindowFrame(WindowFrame.Type.ROWS, new FrameBound(FrameBound.Type.CURRENT_ROW), Optional.of(new FrameBound(FrameBound.Type.UNBOUNDED_FOLLOWING))));
        ExpectedValueProvider<DataOrganizationSpecification> specificationD = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey) sum_quantity_C, AVG(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) avg_quantity_D, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey) sum_discount_C FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationD).addFunction(PlanMatchPattern.functionCall("avg", frameD, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", UNSPECIFIED_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", UNSPECIFIED_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQS)));
    }

    @Test
    public void testMergeRangeFramesWithDefault() {
        Optional<WindowFrame> frameD = Optional.of(new WindowFrame(WindowFrame.Type.RANGE, new FrameBound(FrameBound.Type.CURRENT_ROW), Optional.of(new FrameBound(FrameBound.Type.UNBOUNDED_FOLLOWING))));
        ExpectedValueProvider<DataOrganizationSpecification> specificationD = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey) sum_quantity_C, AVG(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) avg_quantity_D, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey) sum_discount_C FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationD).addFunction(PlanMatchPattern.functionCall("avg", frameD, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", UNSPECIFIED_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", UNSPECIFIED_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQS)));
    }

    @Test
    public void testNotMergeAcrossJoinBranches() {
        String rOrderkeyAlias = "R_ORDERKEY";
        String rShipdateAlias = "R_SHIPDATE";
        String rQuantityAlias = "R_QUANTITY";
        String sql = "WITH foo AS (SELECT suppkey, orderkey, partkey, SUM(discount) OVER (PARTITION BY orderkey ORDER BY shipdate, quantity DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) a FROM lineitem WHERE (partkey = 272 OR partkey = 273) AND suppkey > 50 ), bar AS ( SELECT suppkey, orderkey, partkey, AVG(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate, quantity DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) b FROM lineitem WHERE (partkey = 272 OR partkey = 273) AND suppkey > 50 )SELECT * FROM foo, bar WHERE foo.a = bar.b";
        ExpectedValueProvider<DataOrganizationSpecification> leftSpecification = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (List<String>)ImmutableList.of((Object)SHIPDATE_ALIAS, (Object)QUANTITY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)SHIPDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST, (Object)QUANTITY_ALIAS, (Object)SortOrder.DESC_NULLS_LAST));
        ExpectedValueProvider<DataOrganizationSpecification> rightSpecification = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)rOrderkeyAlias), (List<String>)ImmutableList.of((Object)rShipdateAlias, (Object)rQuantityAlias), (Map<String, SortOrder>)ImmutableMap.of((Object)rShipdateAlias, (Object)SortOrder.ASC_NULLS_LAST, (Object)rQuantityAlias, (Object)SortOrder.DESC_NULLS_LAST));
        ImmutableMap.Builder leftTableScanBuilder = ImmutableMap.builder();
        leftTableScanBuilder.put((Object)DISCOUNT_ALIAS, (Object)"discount");
        leftTableScanBuilder.put((Object)ORDERKEY_ALIAS, (Object)"orderkey");
        leftTableScanBuilder.put((Object)"PARTKEY", (Object)"partkey");
        leftTableScanBuilder.put((Object)SUPPKEY_ALIAS, (Object)"suppkey");
        leftTableScanBuilder.put((Object)QUANTITY_ALIAS, (Object)"quantity");
        leftTableScanBuilder.put((Object)SHIPDATE_ALIAS, (Object)"shipdate");
        PlanMatchPattern leftTableScan = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)leftTableScanBuilder.build());
        PlanMatchPattern rightTableScan = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)rOrderkeyAlias, (Object)"orderkey", (Object)"R_PARTKEY", (Object)"partkey", (Object)"R_SUPPKEY", (Object)"suppkey", (Object)rQuantityAlias, (Object)"quantity", (Object)rShipdateAlias, (Object)"shipdate"));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.filter("SUM = AVG", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.any(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(leftSpecification).addFunction("SUM", PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.any(leftTableScan))), PlanMatchPattern.any(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(rightSpecification).addFunction("AVG", PlanMatchPattern.functionCall("avg", COMMON_FRAME, (List<String>)ImmutableList.of((Object)rQuantityAlias))), PlanMatchPattern.any(rightTableScan)))))));
    }

    @Test
    public void testNotMergeDifferentPartition() {
        String sql = "SELECT SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) over (PARTITION BY quantity ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQS))));
    }

    @Test
    public void testNotMergeDifferentOrderBy() {
        String sql = "SELECT SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) OVER (PARTITION BY suppkey ORDER BY quantity ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)QUANTITY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), LINEITEM_TABLESCAN_DOQS))));
    }

    @Test
    public void testNotMergeDifferentOrdering() {
        String sql = "SELECT SUM(extendedprice) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) over (PARTITION BY suppkey ORDER BY orderkey DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C, SUM(discount) over (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.DESC_NULLS_LAST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)EXTENDEDPRICE_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), LINEITEM_TABLESCAN_DEOQS))));
    }

    @Test
    public void testNotMergeDifferentNullOrdering() {
        String sql = "SELECT SUM(extendedprice) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey NULLS FIRST ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_FIRST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)EXTENDEDPRICE_ALIAS))).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.functionCall("sum", COMMON_FRAME, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DEOQS))));
    }

    private void assertUnitPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.getMetadata().getFunctionAndTypeManager()), (Object)new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll((Iterable)GatherAndMergeWindows.rules()).build()), (Object)new PruneUnreferencedOutputs());
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

