/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.OptimizerAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneUnreferencedOutputs
extends BaseRuleTest {
    public TestPruneUnreferencedOutputs() {
        super(new Plugin[0]);
    }

    @Test
    public void windowNodePruning() {
        FunctionHandle functionHandle = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("rank", (List)ImmutableList.of());
        CallExpression call = Expressions.call((String)"rank", (FunctionHandle)functionHandle, (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[0]);
        WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.assertRuleApplication().on(p -> p.output((List<String>)ImmutableList.of((Object)"user_uuid"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("user_uuid", (Type)VarcharType.VARCHAR)), (PlanNode)p.project(Assignments.of((VariableReferenceExpression)p.variable("user_uuid", (Type)VarcharType.VARCHAR), (RowExpression)p.variable("user_uuid", (Type)VarcharType.VARCHAR)), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.variable("user_uuid", (Type)VarcharType.VARCHAR)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Ordering(p.variable("expr"), SortOrder.ASC_NULLS_LAST), (Object)new Ordering(p.variable("random"), SortOrder.ASC_NULLS_LAST))))), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("rank"), (Object)new WindowNode.Function(call, frame, false)), (PlanNode)p.project(Assignments.builder().put(p.variable("user_uuid", (Type)VarcharType.VARCHAR), (RowExpression)p.variable("user_uuid", (Type)VarcharType.VARCHAR)).put(p.variable("expr", (Type)BigintType.BIGINT), (RowExpression)p.variable("expr", (Type)BigintType.BIGINT)).put(p.variable("random", (Type)BigintType.BIGINT), p.rowExpression("random()")).build(), (PlanNode)p.values(p.variable("user_uuid", (Type)VarcharType.VARCHAR), p.variable("expr", (Type)BigintType.BIGINT))))))).matches(PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.values("user_uuid")))));
    }

    @Test
    public void testIntersectNodePruning() {
        this.assertRuleApplication().on(p -> p.output((List<String>)ImmutableList.of((Object)"regionkey"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("regionkey_16")), (PlanNode)p.project(Assignments.of((VariableReferenceExpression)p.variable("regionkey_16"), (RowExpression)p.variable("regionkey_16")), (PlanNode)p.intersect((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().putAll((Object)p.variable("nationkey_15"), (Object[])new VariableReferenceExpression[]{p.variable("nationkey"), p.variable("regionkey_6")}).putAll((Object)p.variable("regionkey_16"), (Object[])new VariableReferenceExpression[]{p.variable("regionkey"), p.variable("regionkey_6")}).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(p.variable("nationkey"), p.variable("regionkey")), (Object)p.values(p.variable("regionkey_6"))))))).matches(PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.intersect(PlanMatchPattern.values("nationkey", "regionkey"), PlanMatchPattern.values("regionkey_6")))));
    }

    @Test
    public void testExceptNodePruning() {
        this.assertRuleApplication().on(p -> p.output((List<String>)ImmutableList.of((Object)"regionkey"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("regionkey_16")), (PlanNode)p.project(Assignments.of((VariableReferenceExpression)p.variable("regionkey_16"), (RowExpression)p.variable("regionkey_16")), (PlanNode)p.except((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().putAll((Object)p.variable("nationkey_15"), (Object[])new VariableReferenceExpression[]{p.variable("nationkey"), p.variable("regionkey_6")}).putAll((Object)p.variable("regionkey_16"), (Object[])new VariableReferenceExpression[]{p.variable("regionkey"), p.variable("regionkey_6")}).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(p.variable("nationkey"), p.variable("regionkey")), (Object)p.values(p.variable("regionkey_6"))))))).matches(PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.except(PlanMatchPattern.values("nationkey", "regionkey"), PlanMatchPattern.values("regionkey_6")))));
    }

    private OptimizerAssert assertRuleApplication() {
        RuleTester tester = this.tester();
        return tester.assertThat((PlanOptimizer)new PruneUnreferencedOutputs());
    }
}

