/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.relation.ExpressionOptimizerProvider;
import com.facebook.presto.sql.InMemoryExpressionOptimizerProvider;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestReorderWindows
extends BasePlanTest {
    private static final String DISCOUNT_ALIAS = "DISCOUNT";
    private static final String ORDERKEY_ALIAS = "ORDERKEY";
    private static final String QUANTITY_ALIAS = "QUANTITY";
    private static final String PARTKEY_ALIAS = "PARTKEY";
    private static final String RECEIPTDATE_ALIAS = "RECEIPTDATE";
    private static final String SHIPDATE_ALIAS = "SHIPDATE";
    private static final String SUPPKEY_ALIAS = "SUPPKEY";
    private static final String TAX_ALIAS = "TAX";
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DOQPRSST;
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DOQRST;
    private static final Optional<WindowFrame> commonFrame;
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowA;
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowAp;
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowApp;
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowB;
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowC;
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowD;
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowE;

    @Test
    public void testNonMergeableABAReordersToAABAllOptimizers() {
        String sql = "select sum(quantity) over(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) sum_quantity_A, avg(discount) over(PARTITION BY partkey ORDER BY receiptdate ASC NULLS LAST) avg_discount_B, min(tax) over(PARTITION BY suppkey ORDER BY shipdate ASC NULLS LAST) min_tax_A from lineitem";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowAp).addFunction(PlanMatchPattern.functionCall("min", commonFrame, (List<String>)ImmutableList.of((Object)TAX_ALIAS))), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("sum", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowB).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_DOQPRSST)))))));
        this.assertPlan(sql, pattern);
    }

    @Test
    public void testNonMergeableABAReordersToAAB() {
        String sql = "select sum(quantity) over(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) sum_quantity_A, avg(discount) over(PARTITION BY partkey ORDER BY receiptdate ASC NULLS LAST) avg_discount_B, min(tax) over(PARTITION BY suppkey ORDER BY shipdate ASC NULLS LAST) min_tax_A from lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowAp).addFunction(PlanMatchPattern.functionCall("min", commonFrame, (List<String>)ImmutableList.of((Object)TAX_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("sum", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowB).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), LINEITEM_TABLESCAN_DOQPRSST)))));
    }

    @Test
    public void testPrefixOfPartitionComesFirstRegardlessOfTheirOrderInSQL() {
        this.assertUnitPlan("select avg(discount) over(PARTITION BY suppkey, tax ORDER BY receiptdate ASC NULLS LAST) avg_discount_A, sum(quantity) over(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) sum_quantity_A from lineitem", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowApp).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("sum", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQRST))));
        this.assertUnitPlan("select sum(quantity) over(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) sum_quantity_A, avg(discount) over(PARTITION BY suppkey, tax ORDER BY receiptdate ASC NULLS LAST) avg_discount_A from lineitem", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowApp).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("sum", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), LINEITEM_TABLESCAN_DOQRST))));
    }

    @Test
    public void testReorderAcrossProjectNodes() {
        String sql = "select avg(discount) over(PARTITION BY suppkey, tax ORDER BY receiptdate ASC NULLS LAST) avg_discount_A, lag(quantity, 1) over(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) lag_quantity_A from lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowApp).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("lag", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS, (Object)"ONE"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ONE", (Object)PlanMatchPattern.expression("CAST(1 AS bigint)")), LINEITEM_TABLESCAN_DOQRST)))));
    }

    @Test
    public void testNotReorderAcrossNonPartitionFilter() {
        String sql = "SELECT   avg_discount_APP,   AVG(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) avg_quantity_A FROM (    SELECT      *,      AVG(discount) OVER(PARTITION BY suppkey, tax ORDER BY receiptdate ASC NULLS LAST) avg_discount_APP    FROM lineitem) WHERE receiptdate IS NOT NULL";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.project(PlanMatchPattern.filter("RECEIPTDATE IS NOT NULL", PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowApp).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), LINEITEM_TABLESCAN_DOQRST))))));
    }

    @Test
    public void testReorderAcrossPartitionFilter() {
        String sql = "SELECT   avg_discount_APP,   AVG(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) avg_quantity_A FROM (    SELECT      *,      AVG(discount) OVER(PARTITION BY suppkey, tax ORDER BY receiptdate ASC NULLS LAST) avg_discount_APP    FROM lineitem) WHERE suppkey > 0";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowApp).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.filter("SUPPKEY > BIGINT '0'", LINEITEM_TABLESCAN_DOQRST)))));
    }

    @Test
    public void testReorderBDAC() {
        String sql = "select avg(discount) over(PARTITION BY suppkey ORDER BY orderkey ASC NULLS LAST) avg_discount_A, sum(tax) over(PARTITION BY quantity ORDER BY receiptdate ASC NULLS LAST) sum_tax_E, avg(quantity) over(PARTITION BY tax ORDER BY receiptdate ASC NULLS LAST) avg_quantity_D, sum(discount) over(PARTITION BY receiptdate ORDER BY suppkey ASC NULLS LAST) sum_discount_C from lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowD).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowA).addFunction(PlanMatchPattern.functionCall("avg", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowC).addFunction(PlanMatchPattern.functionCall("sum", commonFrame, (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowE).addFunction(PlanMatchPattern.functionCall("sum", commonFrame, (List<String>)ImmutableList.of((Object)TAX_ALIAS))), LINEITEM_TABLESCAN_DOQRST))))));
    }

    private void assertUnitPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.getMetadata().getFunctionAndTypeManager()), (Object)new PredicatePushDown(this.getMetadata(), this.getQueryRunner().getSqlParser(), (ExpressionOptimizerProvider)new InMemoryExpressionOptimizerProvider(this.getMetadata()), false), (Object)new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0), (Object)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(1), (Object)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(2))), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }

    static {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        columns.put((Object)DISCOUNT_ALIAS, (Object)"discount");
        columns.put((Object)ORDERKEY_ALIAS, (Object)"orderkey");
        columns.put((Object)QUANTITY_ALIAS, (Object)"quantity");
        columns.put((Object)PARTKEY_ALIAS, (Object)"partkey");
        columns.put((Object)RECEIPTDATE_ALIAS, (Object)"receiptdate");
        columns.put((Object)SHIPDATE_ALIAS, (Object)"shipdate");
        columns.put((Object)SUPPKEY_ALIAS, (Object)"suppkey");
        columns.put((Object)TAX_ALIAS, (Object)"tax");
        LINEITEM_TABLESCAN_DOQPRSST = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)columns.build());
        columns = ImmutableMap.builder();
        columns.put((Object)DISCOUNT_ALIAS, (Object)"discount");
        columns.put((Object)ORDERKEY_ALIAS, (Object)"orderkey");
        columns.put((Object)QUANTITY_ALIAS, (Object)"quantity");
        columns.put((Object)RECEIPTDATE_ALIAS, (Object)"receiptdate");
        columns.put((Object)SUPPKEY_ALIAS, (Object)"suppkey");
        columns.put((Object)TAX_ALIAS, (Object)"tax");
        LINEITEM_TABLESCAN_DOQRST = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)columns.build());
        commonFrame = Optional.empty();
        windowA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        windowAp = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)SHIPDATE_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)SHIPDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        windowApp = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS, (Object)TAX_ALIAS), (List<String>)ImmutableList.of((Object)RECEIPTDATE_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)RECEIPTDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        windowB = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)PARTKEY_ALIAS), (List<String>)ImmutableList.of((Object)RECEIPTDATE_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)RECEIPTDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        windowC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)RECEIPTDATE_ALIAS), (List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)SUPPKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        windowD = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)TAX_ALIAS), (List<String>)ImmutableList.of((Object)RECEIPTDATE_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)RECEIPTDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        windowE = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), (List<String>)ImmutableList.of((Object)RECEIPTDATE_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)RECEIPTDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
    }
}

