/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSimplifyPlanWithEmptyInput
extends BasePlanTest {
    private Session enableOptimization() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("simplify_plan_with_empty_input", "true").build();
    }

    private Session enableCteMaterialization() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("simplify_plan_with_empty_input", "true").setSystemProperty("cte_materialization_strategy", "ALL").build();
    }

    @Test
    public void testInnerJoinWithEmptyInput() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from orders o join (select orderkey, linenumber from lineitem where false) l on o.orderkey = l.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.values("orderkey", "custkey", "linenumber")));
    }

    @Test
    public void testCrossJoinWithEmptyInput() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from orders o cross join (select orderkey, linenumber from lineitem where false) l", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.values("orderkey", "custkey", "linenumber")));
    }

    @Test
    public void testLeftJoinWithEmptyBuild() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from orders o left join (select orderkey, linenumber from lineitem where false) l on o.orderkey = l.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"custkey", (Object)PlanMatchPattern.expression("custkey"), (Object)"linenumber", (Object)PlanMatchPattern.expression("null")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))));
    }

    @Test
    public void testLeftJoinWithEmptyProbe() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from (select orderkey, linenumber from lineitem where false) l left join orders o on l.orderkey = o.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.values("linenumber", "orderkey", "custkey")));
    }

    @Test
    public void testRightJoinWithEmptyBuild() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from orders o right join (select orderkey, linenumber from lineitem where false) l on o.orderkey = l.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.values("orderkey", "custkey", "linenumber")));
    }

    @Test
    public void testRightJoinWithEmptyProbe() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from (select orderkey, linenumber from lineitem where false) l right join orders o on l.orderkey = o.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"custkey", (Object)PlanMatchPattern.expression("custkey"), (Object)"linenumber", (Object)PlanMatchPattern.expression("null")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))));
    }

    @Test
    public void testFullJoinWithEmptyProbe() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from (select orderkey, linenumber from lineitem where false) l full outer join orders o on l.orderkey = o.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"custkey", (Object)PlanMatchPattern.expression("custkey"), (Object)"linenumber", (Object)PlanMatchPattern.expression("null")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))));
    }

    @Test
    public void testFullJoinWithEmptyBuild() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from orders o full outer join (select orderkey, linenumber from lineitem where false) l on o.orderkey = l.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"custkey", (Object)PlanMatchPattern.expression("custkey"), (Object)"linenumber", (Object)PlanMatchPattern.expression("null")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))));
    }

    @Test
    public void testUnionWithEmptyInput() {
        this.assertPlan("select orderkey, partkey from lineitem union all select orderkey, custkey as partkey from orders where false", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"partkey"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"orderkey", (Object)"orderkey"))));
    }

    @Test
    public void testUnionMultipleNonEmptyInput() {
        this.assertPlan("select orderkey, partkey from lineitem union all select orderkey, custkey as partkey from orders where false union all select custkey, nationkey from customer", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"partkey"), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"orderkey", (Object)"orderkey")), PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey", (Object)"custkey", (Object)"custkey")))));
    }

    @Test
    public void testSemiJoinEmptyFilterSource() {
        this.assertPlan("select orderkey, partkey from lineitem where orderkey in (select orderkey from orders where false)", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"partkey"), PlanMatchPattern.filter("false", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey")))));
    }

    @Test
    public void testSemiJoinEmptySource() {
        this.assertPlan("select orderkey, partkey from (select orderkey, partkey from lineitem where false) where orderkey in (select orderkey from orders)", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"partkey"), PlanMatchPattern.values("orderkey", "partkey")));
    }

    @Test
    public void testAggregationWithDefaultOutput() {
        this.assertPlan("select count(*) as count from (select orderkey from orders where false)", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"count"), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testAggregationNoDefaultOutput() {
        this.assertPlan("select orderkey, count(*) as count from (select orderkey from orders where false) group by orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"count"), PlanMatchPattern.values("orderkey", "count")));
    }

    @Test
    public void testInnerJoinWithOverEmptyAggregation() {
        this.assertPlan("select o.orderkey, o.custkey, l.linenumber from orders o join (select orderkey, max(linenumber) as linenumber from lineitem where false group by orderkey) l on o.orderkey = l.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.values("orderkey", "custkey", "linenumber")));
    }

    @Test
    public void testQueryWithWindowFilterLimitOrderby() {
        this.assertPlan("with emptyorders as (select orderkey, totalprice, orderdate from orders where false) SELECT orderkey, orderdate, totalprice, ROW_NUMBER() OVER (ORDER BY orderdate) as row_num FROM emptyorders WHERE totalprice > 10 ORDER BY orderdate ASC LIMIT 10", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"orderdate", (Object)"totalprice", (Object)"row_number"), PlanMatchPattern.values("orderkey", "totalprice", "orderdate", "row_number")));
    }

    @Test
    public void testQueryWithJoinWindowFilterLimitOrderby() {
        this.assertPlan("with emptyorders as (select * from orders where false) SELECT c.custkey, c.name, c.acctbal, SUM(l.quantity) OVER (PARTITION BY c.custkey) AS total_quantity FROM customer c JOIN emptyorders o ON c.custkey = o.custkey JOIN lineitem l ON o.orderkey = l.orderkey WHERE o.orderdate BETWEEN DATE '1995-03-01' AND DATE '1995-03-31' AND l.shipdate BETWEEN DATE '1995-03-01' AND DATE '1995-03-31' ORDER BY total_quantity DESC, c.custkey LIMIT 100", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"custkey", (Object)"name", (Object)"acctbal", (Object)"sum"), PlanMatchPattern.values("sum", "custkey", "name", "acctbal")));
    }

    @Test
    public void testRowNumberWithEmptyInput() {
        this.assertPlan("select orderkey, row_number() over (partition by orderpriority), orderpriority from (select orderkey, orderpriority from orders where false)", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"rownumber", (Object)"orderpriority"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"orderkey", (Object)"orderpriority", (Object)"rownumber"), (List<List<Expression>>)ImmutableList.of())));
    }

    @Test
    public void testTopNRowNumberWithEmptyInput() {
        this.assertPlan("select * from (select orderkey, row_number() over (partition by orderpriority order by orderkey) row_number, orderpriority from (select orderkey, orderpriority from orders where false)) where row_number < 2", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"row_number", (Object)"orderpriority"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"orderkey", (Object)"orderpriority", (Object)"row_number"), (List<List<Expression>>)ImmutableList.of())));
    }

    @Test
    public void testCteMaterializationQueryWithJoinWindowFilterLimitOrderby() {
        this.assertPlan("with emptyorders as (select * from orders where false) SELECT c.custkey, c.name, c.acctbal, SUM(l.quantity) OVER (PARTITION BY c.custkey) AS total_quantity FROM customer c JOIN emptyorders o ON c.custkey = o.custkey JOIN lineitem l ON o.orderkey = l.orderkey WHERE o.orderdate BETWEEN DATE '1995-03-01' AND DATE '1995-03-31' AND l.shipdate BETWEEN DATE '1995-03-01' AND DATE '1995-03-31' ORDER BY total_quantity DESC, c.custkey LIMIT 100", this.enableCteMaterialization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"custkey", (Object)"name", (Object)"acctbal", (Object)"sum"), PlanMatchPattern.values("sum", "custkey", "name", "acctbal")));
    }

    @Test
    public void testCteMaterializationQueryCrossJoinWithEmptyInput() {
        this.assertPlan("WITH t as (select o.orderkey, o.custkey, l.linenumber from orders o cross join (select orderkey, linenumber from lineitem where false) l) SELECT * FROM t", this.enableCteMaterialization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"custkey", (Object)"linenumber"), PlanMatchPattern.values("orderkey", "custkey", "linenumber")));
    }

    @Test
    public void testCteMaterializationQueryWithWindowFilterLimitOrderby() {
        this.assertPlan("with emptyorders as (select orderkey, totalprice, orderdate from orders where false) SELECT orderkey, orderdate, totalprice, ROW_NUMBER() OVER (ORDER BY orderdate) as row_num FROM emptyorders WHERE totalprice > 10 ORDER BY orderdate ASC LIMIT 10", this.enableCteMaterialization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"orderdate", (Object)"totalprice", (Object)"row_number"), PlanMatchPattern.values("orderkey", "totalprice", "orderdate", "row_number")));
    }

    @Test
    public void testNestedCteMaterializationQueryWithEmptyInput() {
        this.assertPlan("WITH t as(select orderkey, count(*) as count from (select orderkey from orders where false) group by orderkey), b AS (SELECT * FROM t) SELECT * FROM b", this.enableCteMaterialization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"count"), PlanMatchPattern.values("orderkey", "count")));
    }
}

