/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.optimizations.TestAddPartitionToSortRule;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.testng.annotations.Test;

public class TestSortWithinPartitionPlans
extends BasePlanTest {
    @Test
    public void testSortWithPartition() {
        LocalQueryRunner localQueryRunner = this.getQueryRunner();
        localQueryRunner.setAdditionalOptimizer((List)ImmutableList.of((Object)new IterativeOptimizer(localQueryRunner.getMetadata(), new RuleStatsRecorder(), localQueryRunner.getStatsCalculator(), localQueryRunner.getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.of((Object)new TestAddPartitionToSortRule()))));
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("task_concurrency", "2").build();
        this.assertDistributedPlan("SELECT partkey, discount from lineitem order by discount", session, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.sort(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))))));
    }
}

