/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestUnaliasSymbolReferences
extends BasePlanTest {
    @Test
    public void testJoinTimestampsWithTimezonesPreservesAssignments() {
        this.assertPlan("WITH source AS (SELECT * FROM (    VALUES        (TIMESTAMP '2001-08-22 03:04:05.321 America/Los_Angeles'),        (TIMESTAMP '2001-08-22 06:04:05.321 America/New_York')) AS tbl (tstz))SELECT * FROM source a JOIN source b ON a.tstz = b.tstz", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LEFT_BAR", "RIGHT_BAR")), PlanMatchPattern.anyTree(PlanMatchPattern.values("LEFT_BAR")), PlanMatchPattern.anyTree(PlanMatchPattern.values("RIGHT_BAR"))).withNumberOfOutputColumns(2).withExactOutputs("LEFT_BAR", "RIGHT_BAR")));
    }

    @Test
    public void testIdenticalValuesCollapseAssignments() {
        this.assertPlan("WITH source AS (SELECT * FROM (    VALUES        (to_unixtime(TIMESTAMP '2001-08-22 03:04:05.321 America/Los_Angeles')),        (to_unixtime(TIMESTAMP '2001-08-22 06:04:05.321 America/New_York'))) AS tbl (tstz))SELECT * FROM source a JOIN source b ON a.tstz = b.tstz", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LEFT_BAR", "RIGHT_BAR")), PlanMatchPattern.anyTree(PlanMatchPattern.values("LEFT_BAR")), PlanMatchPattern.anyTree(PlanMatchPattern.values("RIGHT_BAR"))).withNumberOfOutputColumns(1).withExactOutputs("LEFT_BAR")));
    }
}

