/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.metadata.AbstractMockMetadata;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.DynamicFilterStats;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.testing.TestingHandle;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPlanPrinter {
    private static final String TEST_METRIC_NAME = "test_metric";
    private static final RuntimeMetric TEST_RUNTIME_METRIC_1 = new RuntimeMetric("test_metric", RuntimeUnit.NONE, 10L, 2L, 9L, 1L);
    private static final DynamicFilterStats TEST_DYNAMIC_FILTER_STATS_1 = new DynamicFilterStats((Set)ImmutableSet.of((Object)new PlanNodeId("1"), (Object)new PlanNodeId("2")));
    private static final PlanBuilder PLAN_BUILDER = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final VariableReferenceExpression COLUMN_VARIABLE = new VariableReferenceExpression(Optional.empty(), "column", (Type)VarcharType.VARCHAR);
    private static final ColumnHandle COLUMN_HANDLE = new TestingMetadata.TestingColumnHandle("column");
    private static final TableHandle TABLE_HANDLE_WITH_LAYOUT = new TableHandle(new ConnectorId("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE));

    private String domainToPrintedScan(VariableReferenceExpression variable, ColumnHandle colHandle, Domain domain) {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)colHandle, (Object)domain).build());
        TableScanNode scanNode = PLAN_BUILDER.tableScan(TABLE_HANDLE_WITH_LAYOUT, (List<VariableReferenceExpression>)ImmutableList.of((Object)variable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)variable, (Object)colHandle), (TupleDomain<ColumnHandle>)tupleDomain, (TupleDomain<ColumnHandle>)tupleDomain);
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId(0), (PlanNode)scanNode, (Set)ImmutableSet.of((Object)variable), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)scanNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SOURCE_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of((Object)variable)), StageExecutionDescriptor.ungroupedExecution(), false, Optional.of(StatsAndCosts.empty()), Optional.empty());
        return PlanPrinter.textPlanFragment((PlanFragment)testFragment, (FunctionAndTypeManager)FUNCTION_AND_TYPE_MANAGER, (Session)SessionTestUtils.TEST_SESSION, (boolean)false);
    }

    private void assertDomainFormat(VariableReferenceExpression variable, ColumnHandle colHandle, Domain domain, String expected) {
        String printed = this.domainToPrintedScan(variable, colHandle, domain);
        Assert.assertTrue((boolean)printed.contains(":: " + expected));
    }

    private void assertDomainFormat(Domain domain, String expected) {
        this.assertDomainFormat(COLUMN_VARIABLE, COLUMN_HANDLE, domain, expected);
    }

    @Test
    public void testDomainTextFormatting() {
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.all((Type)VarcharType.VARCHAR), (boolean)false), "[(<min>, <max>)]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"some string"), (Object[])new Object[0]), (boolean)false), "[[\"some string\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"here's a quote: \""), (Object[])new Object[0]), (boolean)false), "[[\"here's a quote: \\\"\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)""), (Object[])new Object[0]), (boolean)false), "[[\"\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"string with \"quotes\" inside")).intersect(Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"this string's quote is here -> \""))), (Range[])new Range[0]), (boolean)false), "[[\"string with \\\"quotes\\\" inside\", \"this string's quote is here -> \\\"\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"string with \"quotes\" inside")).intersect(Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"this string's quote is here -> \""))), (Range[])new Range[0]), (boolean)false), "[(\"string with \\\"quotes\\\" inside\", \"this string's quote is here -> \\\"\")]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<min>"), (Object[])new Object[0]), (boolean)false), "[[\"<min>\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<max>"), (Object[])new Object[0]), (boolean)false), "[[\"<max>\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<min>, <max>"), (Object[])new Object[0]), (boolean)false), "[[\"<min>, <max>\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")).intersect(Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Range[])new Range[0]), (boolean)false), "[[\"a\", \"b\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a, b"), (Object[])new Object[0]), (boolean)false), "[[\"a, b\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"xyz"), (Object[])new Object[0]), (boolean)true), "[NULL, [\"xyz\"]]");
        this.assertDomainFormat(Domain.onlyNull((Type)VarcharType.VARCHAR), "[NULL]");
    }

    @Test
    public void assertFragmentStringReadability() {
        int stageId0 = 0;
        int stageExecutionId0 = 1;
        ImmutableList pipeline00 = ImmutableList.of((Object)TestPlanPrinter.createOperatorStats(stageId0, stageExecutionId0, 0, 0, new PlanNodeId("101"), ExchangeOperator.class, 5384L, 100L, 5040L, 100L, 5040L, 100L), (Object)TestPlanPrinter.createOperatorStats(stageId0, stageExecutionId0, 0, 1, new PlanNodeId("102"), TaskOutputOperator.class, 0L, 0L, 5040L, 100L, 5040L, 100L));
        StageExecutionStats stageExecutionStats = TestPlanPrinter.createStageStats(stageId0, stageExecutionId0, 5384L, 100L, 5040L, 100L, 5040L, 100L, (List<OperatorStats>)pipeline00);
        String expected = "CPU: 0.00ns, Scheduled: 0.00ns, Input: 100 rows (4.92kB); per task: avg.: 10.10 std.dev.: 21.20, Output: 100 rows (4.92kB), 3 tasks\n";
        Assert.assertEquals((String)PlanPrinter.formattedFragmentString((StageExecutionStats)stageExecutionStats, (double)10.1, (double)21.2, (int)3), (String)expected);
    }

    private static OperatorStats createOperatorStats(int stageId, int stageExecutionId, int pipelineId, int operatorId, PlanNodeId planNodeId, Class operatorCls, long rawInputDataSize, long rawInputPositions, long inputDataSize, long inputPositions, long outputDataSize, long outputPositions) {
        return new OperatorStats(stageId, stageExecutionId, pipelineId, operatorId, planNodeId, operatorCls.getSimpleName(), 0L, 0L, new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), 0L, 0L, new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), 0L, rawInputDataSize, rawInputPositions, inputDataSize, inputPositions, 0.0, 0L, new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), 0L, outputDataSize, outputPositions, 0L, new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), 0L, new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, Optional.empty(), null, new RuntimeStats((Map)ImmutableMap.of((Object)TEST_METRIC_NAME, (Object)RuntimeMetric.copyOf((RuntimeMetric)TEST_RUNTIME_METRIC_1))), DynamicFilterStats.copyOf((DynamicFilterStats)TEST_DYNAMIC_FILTER_STATS_1), 0L, 0L, 0L, 0L);
    }

    private static StageExecutionStats createStageStats(int stageId, int stageExecutionId, long rawInputDataSize, long rawInputPositions, long inputDataSize, long inputPositions, long outputDataSize, long outputPositions, List<OperatorStats> operatorSummaries) {
        return new StageExecutionStats(0L, new Distribution(0.0).snapshot(), 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 0L, 0L, 0L, 0L, new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), 0L, rawInputDataSize, rawInputPositions, inputDataSize, inputPositions, 0L, outputDataSize, outputPositions, 0L, new StageGcStatistics(stageId, stageExecutionId, 102, 103, 104, 105, 106, 107), operatorSummaries, new RuntimeStats());
    }
}

