/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.sanity.DynamicFiltersChecker;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDynamicFiltersChecker
extends BasePlanTest {
    private Metadata metadata;
    private LogicalRowExpressions logicalRowExpressions;
    private PlanBuilder builder;
    private VariableReferenceExpression lineitemOrderKeyVariable;
    private TableScanNode lineitemTableScanNode;
    private VariableReferenceExpression ordersOrderKeyVariable;
    private TableScanNode ordersTableScanNode;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(this.metadata.getFunctionAndTypeManager()), (StandardFunctionResolution)new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()), (FunctionMetadataManager)this.metadata.getFunctionAndTypeManager());
        this.builder = new PlanBuilder(this.getQueryRunner().getDefaultSession(), new PlanNodeIdAllocator(), this.metadata);
        ConnectorId connectorId = this.getCurrentConnectorId();
        TableHandle lineitemTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)new TpchTableHandle("lineitem", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.lineitemOrderKeyVariable = this.builder.variable("LINEITEM_OK", (Type)BigintType.BIGINT);
        this.lineitemTableScanNode = this.builder.tableScan(lineitemTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.lineitemOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.lineitemOrderKeyVariable, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
        TableHandle ordersTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)new TpchTableHandle("orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.ordersOrderKeyVariable = this.builder.variable("ORDERS_OK", (Type)BigintType.BIGINT);
        this.ordersTableScanNode = this.builder.tableScan(ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersOrderKeyVariable, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="Dynamic filters \\[DF\\] present in join were not fully consumed by its probe side, currentJoinDynamicFilters is: \\[DF\\], consumedProbeSide is: \\[\\]")
    public void testUnconsumedDynamicFilterInJoin() {
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(this.builder.rowExpression("ORDERS_OK > 0"), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of((Object)"DF", (Object)this.lineitemOrderKeyVariable));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="Dynamic filters \\[DF\\] present in join were consumed by its build side. consumedBuildSide \\[DF\\], currentJoinDynamicFilters \\[DF\\]")
    public void testDynamicFilterConsumedOnBuildSide() {
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.ordersOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager()), (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.ordersOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager()), (PlanNode)this.lineitemTableScanNode), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of((Object)"DF", (Object)this.lineitemOrderKeyVariable));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="All consumed dynamic filters could not be matched with a join.")
    public void testUnmatchedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(this.logicalRowExpressions.combineConjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK > 0"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())}), (PlanNode)this.lineitemTableScanNode), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of()));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="All consumed dynamic filters could not be matched with a join.")
    public void testUnmatchedNestedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(this.logicalRowExpressions.combineConjuncts(new RowExpression[]{this.logicalRowExpressions.combineDisjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK IS NULL"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())}), this.logicalRowExpressions.combineDisjuncts(new RowExpression[]{this.builder.rowExpression("LINEITEM_OK IS NOT NULL"), PredicatePushDown.createDynamicFilterExpression((String)"DF", (RowExpression)this.lineitemOrderKeyVariable, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())})}), (PlanNode)this.lineitemTableScanNode), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of()));
        this.validatePlan((PlanNode)root);
    }

    private void validatePlan(PlanNode root) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new DynamicFiltersChecker().validate(root, session, this.metadata, WarningCollector.NOOP);
            return null;
        });
    }
}

