/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.plan.PlanCheckerProvider;
import com.facebook.presto.spi.plan.PlanCheckerProviderContext;
import com.facebook.presto.spi.plan.PlanCheckerProviderFactory;
import com.facebook.presto.spi.plan.SimplePlanFragment;
import com.facebook.presto.spi.plan.SimplePlanFragmentSerde;
import com.facebook.presto.sql.planner.plan.JsonCodecSimplePlanFragmentSerde;
import com.facebook.presto.sql.planner.sanity.PlanCheckerProviderManager;
import com.facebook.presto.sql.planner.sanity.PlanCheckerProviderManagerConfig;
import com.facebook.presto.testing.TestingNodeManager;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPlanCheckerProviderManager {
    @Test
    public void testLoadPlanCheckerProviders() throws IOException {
        PlanCheckerProviderManagerConfig planCheckerProviderManagerConfig = new PlanCheckerProviderManagerConfig().setPlanCheckerConfigurationDir(new File("src/test/resources/plan-checkers"));
        PlanCheckerProviderManager planCheckerProviderManager = new PlanCheckerProviderManager((SimplePlanFragmentSerde)new JsonCodecSimplePlanFragmentSerde(JsonCodec.jsonCodec(SimplePlanFragment.class)), planCheckerProviderManagerConfig);
        planCheckerProviderManager.addPlanCheckerProviderFactory((PlanCheckerProviderFactory)new TestingPlanCheckerProviderFactory());
        planCheckerProviderManager.loadPlanCheckerProviders((NodeManager)new TestingNodeManager());
        Assert.assertEquals((Collection)planCheckerProviderManager.getPlanCheckerProviders(), (Collection)ImmutableList.of((Object)TestingPlanCheckerProvider.TESTING_PLAN_CHECKER_PROVIDER));
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="No planCheckerProviderFactory found for 'test'. Available factories were \\[]")
    public void testLoadUnregisteredPlanCheckerProvider() throws IOException {
        PlanCheckerProviderManagerConfig planCheckerProviderManagerConfig = new PlanCheckerProviderManagerConfig().setPlanCheckerConfigurationDir(new File("src/test/resources/plan-checkers"));
        PlanCheckerProviderManager planCheckerProviderManager = new PlanCheckerProviderManager((SimplePlanFragmentSerde)new JsonCodecSimplePlanFragmentSerde(JsonCodec.jsonCodec(SimplePlanFragment.class)), planCheckerProviderManagerConfig);
        planCheckerProviderManager.loadPlanCheckerProviders((NodeManager)new TestingNodeManager());
    }

    public static class TestingPlanCheckerProviderFactory
    implements PlanCheckerProviderFactory {
        public String getName() {
            return "test";
        }

        public PlanCheckerProvider create(Map<String, String> properties, PlanCheckerProviderContext planCheckerProviderContext) {
            return TestingPlanCheckerProvider.TESTING_PLAN_CHECKER_PROVIDER;
        }
    }

    public static class TestingPlanCheckerProvider
    implements PlanCheckerProvider {
        public static final TestingPlanCheckerProvider TESTING_PLAN_CHECKER_PROVIDER = new TestingPlanCheckerProvider();
    }
}

