/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.MockConnectorFactory;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.ViewExpression;
import com.facebook.presto.sql.query.QueryAssertions;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestColumnMask {
    private static final JsonCodec<ViewDefinition> VIEW_DEFINITION_JSON_CODEC = JsonCodec.jsonCodec(ViewDefinition.class);
    private static final String CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String USER = "user";
    private static final String RUN_AS_USER = "run-as-user";
    private static final String VIEW_OWNER = "view-owner";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(new Identity("user", Optional.empty())).build();
    private QueryAssertions assertions;
    private TestingAccessControlManager accessControl;

    @BeforeClass
    public void init() {
        LocalQueryRunner runner = new LocalQueryRunner(SESSION);
        runner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        SchemaTableName viewSchemaTableName = new SchemaTableName("default", "nation_view");
        ViewDefinition viewDefinition = new ViewDefinition("SELECT nationkey, name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("nationkey", (Type)BigintType.BIGINT), (Object)new ViewDefinition.ViewColumn("name", (Type)VarcharType.createVarcharType((int)25))), Optional.of(VIEW_OWNER), false);
        String viewJson = VIEW_DEFINITION_JSON_CODEC.toJson((Object)viewDefinition);
        ConnectorViewDefinition view = new ConnectorViewDefinition(viewSchemaTableName, Optional.of(VIEW_OWNER), viewJson);
        MockConnectorFactory mock = MockConnectorFactory.builder().withGetViews((s, prefix) -> ImmutableMap.builder().put((Object)viewSchemaTableName, (Object)view).build()).build();
        runner.createCatalog(MOCK_CATALOG, (ConnectorFactory)mock, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSimpleMask() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-custkey"));
            this.assertions.assertQuery("SELECT custkey FROM orders WHERE orderkey = 1", "VALUES BIGINT '-370'");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "NULL"));
            this.assertions.assertQuery("SELECT custkey FROM orders WHERE orderkey = 1", "VALUES CAST(NULL AS BIGINT)");
        });
    }

    @Test
    public void testMultipleMasksOnDifferentColumns() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-custkey"));
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderstatus", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "'X'"));
            this.assertions.assertQuery("SELECT custkey, orderstatus FROM orders WHERE orderkey = 1", "VALUES (BIGINT '-370', 'X')");
        });
    }

    @Test
    public void testCoercibleType() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "CAST(clerk AS VARCHAR(5))"));
            this.assertions.assertQuery("SELECT clerk FROM orders WHERE orderkey = 1", "VALUES CAST('Clerk' AS VARCHAR(15))");
        });
    }

    @Test
    public void testSubquery() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT cast(max(name) AS VARCHAR(15)) FROM nation)"));
            this.assertions.assertQuery("SELECT clerk FROM orders WHERE orderkey = 1", "VALUES CAST('VIETNAM' AS VARCHAR(15))");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT cast(max(name) AS VARCHAR(15)) FROM nation WHERE nationkey = orderkey)"));
            this.assertions.assertQuery("SELECT clerk FROM orders WHERE orderkey = 1", "VALUES CAST('ARGENTINA' AS VARCHAR(15))");
        });
    }

    @Test
    public void testTableReferenceInWithClause() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-custkey"));
            this.assertions.assertQuery("WITH t AS (SELECT custkey FROM orders WHERE orderkey = 1) SELECT * FROM t", "VALUES BIGINT '-370'");
        });
    }

    @Test
    public void testOtherSchema() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("sf1"), "(SELECT count(*) FROM customer)"));
            this.assertions.assertQuery("SELECT max(orderkey) FROM orders", "VALUES BIGINT '150000'");
        });
    }

    @Test
    public void testDifferentIdentity() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "100"));
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT sum(orderkey) FROM orders)"));
            this.assertions.assertQuery("SELECT max(orderkey) FROM orders", "VALUES BIGINT '1500000'");
        });
    }

    @Test
    public void testRecursion() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM orders)"));
            this.assertions.assertFails("SELECT orderkey FROM orders", ".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM local.tiny.orders)"));
            this.assertions.assertFails("SELECT orderkey FROM orders", ".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM orders)"));
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM orders)"));
            this.assertions.assertFails("SELECT orderkey FROM orders", ".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
        });
    }

    @Test
    public void testLimitedScope() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "customer"), "custkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey"));
            this.assertions.assertFails("SELECT (SELECT min(custkey) FROM customer WHERE customer.custkey = orders.custkey) FROM orders", "\\Qline 1:1: Column 'orderkey' cannot be resolved\\E");
        });
    }

    @Test
    public void testSqlInjection() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT name FROM region WHERE regionkey = 0)"));
            this.assertions.assertQuery("WITH region(regionkey, name) AS (VALUES (0, 'ASIA'))SELECT name FROM nation ORDER BY name LIMIT 1", "VALUES CAST('AFRICA' AS VARCHAR(25))");
        });
    }

    @Test
    public void testInvalidMasks() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "$$$"));
            this.assertions.assertFails("SELECT orderkey FROM orders", "\\QInvalid column mask for 'local.tiny.orders.orderkey': mismatched input '$'. Expecting: <expression>\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "unknown_column"));
            this.assertions.assertFails("SELECT orderkey FROM orders", "\\Qline 1:1: Column 'unknown_column' cannot be resolved\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "'foo'"));
            this.assertions.assertFails("SELECT orderkey FROM orders", "\\QExpected column mask for 'local.tiny.orders.orderkey' to be of type bigint, but was varchar(3)\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "count(*) > 0"));
            this.assertions.assertFails("SELECT orderkey FROM orders", "\\Qline 1:10: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [\"count\"(*)]\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "row_number() OVER () > 0"));
            this.assertions.assertFails("SELECT orderkey FROM orders", "\\Qline 1:22: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [\"row_number\"() OVER ()]\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "grouping(orderkey) = 0"));
            this.assertions.assertFails("SELECT orderkey FROM orders", "\\Qline 1:20: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [GROUPING (orderkey)]\\E");
        });
    }

    @Test
    public void testInsertWithColumnMasking() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "clerk"));
            this.assertions.assertFails("INSERT INTO orders SELECT * FROM orders", "Insert into table with column masks is not supported");
        });
    }

    @Test
    public void testDeleteWithColumnMasking() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "clerk"));
            this.assertions.assertFails("DELETE FROM orders", "\\Qline 1:1: Delete from table with column mask is not supported\\E");
        });
    }

    @Test
    public void testView() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", VIEW_OWNER, new ViewExpression(VIEW_OWNER, Optional.empty(), Optional.empty(), "reverse(name)"));
            Session session = Session.builder((Session)SESSION).setIdentity(new Identity(RUN_AS_USER, Optional.empty())).build();
            this.assertions.assertQuery(session, "SELECT name FROM mock.default.nation_view WHERE nationkey = 1", "VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", VIEW_OWNER, new ViewExpression(VIEW_OWNER, Optional.of(CATALOG), Optional.of("tiny"), "reverse(name)"));
            Session session = Session.builder((Session)SESSION).setIdentity(new Identity(VIEW_OWNER, Optional.empty())).build();
            this.assertions.assertQuery(session, "SELECT name FROM mock.default.nation_view WHERE nationkey = 1", "VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "reverse(name)"));
            Session session = Session.builder((Session)SESSION).setIdentity(new Identity(RUN_AS_USER, Optional.empty())).build();
            this.assertions.assertQuery(session, "SELECT name FROM mock.default.nation_view WHERE nationkey = 1", "VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_view"), "name", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "reverse(name)"));
            this.assertions.assertQuery("SELECT name FROM mock.default.nation_view WHERE nationkey = 1", "VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        });
    }
}

