/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.MockConnectorFactory;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.ViewExpression;
import com.facebook.presto.sql.query.QueryAssertions;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowFilter {
    private static final JsonCodec<ViewDefinition> VIEW_DEFINITION_JSON_CODEC = JsonCodec.jsonCodec(ViewDefinition.class);
    private static final String CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String USER = "user";
    private static final String RUN_AS_USER = "run-as-user";
    private static final String VIEW_OWNER = "view-owner";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(new Identity("user", Optional.empty())).build();
    private QueryAssertions assertions;
    private TestingAccessControlManager accessControl;

    @BeforeClass
    public void init() {
        LocalQueryRunner runner = new LocalQueryRunner(SESSION);
        runner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        SchemaTableName viewSchemaTableName = new SchemaTableName("default", "nation_view");
        ViewDefinition viewDefinition = new ViewDefinition("SELECT nationkey, name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("nationkey", (Type)BigintType.BIGINT), (Object)new ViewDefinition.ViewColumn("name", (Type)VarcharType.createVarcharType((int)25))), Optional.of(VIEW_OWNER), false);
        String viewJson = VIEW_DEFINITION_JSON_CODEC.toJson((Object)viewDefinition);
        ConnectorViewDefinition view = new ConnectorViewDefinition(viewSchemaTableName, Optional.of(VIEW_OWNER), viewJson);
        MockConnectorFactory mock = MockConnectorFactory.builder().withGetViews((s, prefix) -> ImmutableMap.builder().put((Object)viewSchemaTableName, (Object)view).build()).build();
        runner.createCatalog(MOCK_CATALOG, (ConnectorFactory)mock, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSimpleFilter() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "orderkey < 10"));
            this.assertions.assertQuery("SELECT count(*) FROM orders", "VALUES BIGINT '7'");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "NULL"));
            this.assertions.assertQuery("SELECT count(*) FROM orders", "VALUES BIGINT '0'");
        });
    }

    @Test
    public void testMultipleFilters() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "orderkey < 10"));
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "orderkey > 5"));
            this.assertions.assertQuery("SELECT count(*) FROM orders", "VALUES BIGINT '2'");
        });
    }

    @Test
    public void testCorrelatedSubquery() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "EXISTS (SELECT 1 FROM nation WHERE nationkey = orderkey)"));
            this.assertions.assertQuery("SELECT count(*) FROM orders", "VALUES BIGINT '7'");
        });
    }

    @Test
    public void testTableReferenceInWithClause() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "orderkey = 1"));
            this.assertions.assertQuery("WITH t AS (SELECT count(*) FROM orders) SELECT * FROM t", "VALUES BIGINT '1'");
        });
    }

    @Test
    public void testOtherSchema() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("sf1"), "(SELECT count(*) FROM customer) = 150000"));
            this.assertions.assertQuery("SELECT count(*) FROM orders", "VALUES BIGINT '15000'");
        });
    }

    @Test
    public void testDifferentIdentity() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey = 1"));
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey IN (SELECT orderkey FROM orders)"));
            this.assertions.assertQuery("SELECT count(*) FROM orders", "VALUES BIGINT '1'");
        });
    }

    @Test
    public void testRecursion() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey IN (SELECT orderkey FROM orders)"));
            this.assertions.assertFails("SELECT count(*) FROM orders", ".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey IN (SELECT local.tiny.orderkey FROM orders)"));
            this.assertions.assertFails("SELECT count(*) FROM orders", ".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey IN (SELECT orderkey FROM orders)"));
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey IN (SELECT orderkey FROM orders)"));
            this.assertions.assertFails("SELECT count(*) FROM orders", ".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
        });
    }

    @Test
    public void testLimitedScope() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "customer"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey = 1"));
            this.assertions.assertFails("SELECT (SELECT min(name) FROM customer WHERE customer.custkey = orders.custkey) FROM orders", "\\Qline 1:1: Column 'orderkey' cannot be resolved\\E");
        });
    }

    @Test
    public void testSqlInjection() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "nation"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "regionkey IN (SELECT regionkey FROM region WHERE name = 'ASIA')"));
            this.assertions.assertQuery("WITH region(regionkey, name) AS (VALUES (0, 'ASIA'), (1, 'ASIA'), (2, 'ASIA'), (3, 'ASIA'), (4, 'ASIA'))SELECT name FROM nation ORDER BY name LIMIT 1", "VALUES CAST('CHINA' AS VARCHAR(25))");
        });
    }

    @Test
    public void testInvalidFilter() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "$$$"));
            this.assertions.assertFails("SELECT count(*) FROM orders", "\\QInvalid row filter for 'local.tiny.orders': mismatched input '$'. Expecting: <expression>\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "unknown_column"));
            this.assertions.assertFails("SELECT count(*) FROM orders", "line 1:1: Column 'unknown_column' cannot be resolved");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "1"));
            this.assertions.assertFails("SELECT count(*) FROM orders", "\\QExpected row filter for 'local.tiny.orders' to be of type BOOLEAN, but was integer\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "count(*) > 0"));
            this.assertions.assertFails("SELECT count(*) FROM orders", "\\Qline 1:10: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [\"count\"(*)]\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "row_number() OVER () > 0"));
            this.assertions.assertFails("SELECT count(*) FROM orders", "\\Qline 1:22: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [\"row_number\"() OVER ()]\\E");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "grouping(orderkey) = 0"));
            this.assertions.assertFails("SELECT count(*) FROM orders", "\\Qline 1:20: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [GROUPING (orderkey)]\\E");
        });
    }

    @Test
    public void testInsertWithRowFiltering() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey < 10"));
            this.assertions.assertFails("INSERT INTO orders SELECT * FROM orders", "Insert into table with row filter is not supported");
        });
    }

    @Test
    public void testDeleteWithRowFiltering() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey < 10"));
            this.assertions.assertFails("DELETE FROM orders", "\\Qline 1:1: Delete from table with row filter is not supported\\E");
        });
    }

    @Test
    public void testView() {
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "nation"), VIEW_OWNER, new ViewExpression(VIEW_OWNER, Optional.empty(), Optional.empty(), "nationkey = 1"));
            Session session = Session.builder((Session)SESSION).setIdentity(new Identity(RUN_AS_USER, Optional.empty())).build();
            this.assertions.assertQuery(session, "SELECT name FROM mock.default.nation_view", "VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "nation"), VIEW_OWNER, new ViewExpression(VIEW_OWNER, Optional.of(CATALOG), Optional.of("tiny"), "nationkey = 1"));
            Session session = Session.builder((Session)SESSION).setIdentity(new Identity(VIEW_OWNER, Optional.empty())).build();
            this.assertions.assertQuery(session, "SELECT name FROM mock.default.nation_view", "VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "nation"), RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "nationkey = 1"));
            Session session = Session.builder((Session)SESSION).setIdentity(new Identity(RUN_AS_USER, Optional.empty())).build();
            this.assertions.assertQuery(session, "SELECT count(*) FROM mock.default.nation_view", "VALUES BIGINT '25'");
        });
        this.assertions.executeExclusively(() -> {
            this.accessControl.reset();
            this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_view"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "nationkey = 1"));
            this.assertions.assertQuery("SELECT name FROM mock.default.nation_view", "VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        });
    }
}

