/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.expressions.translator.FunctionTranslator;
import com.facebook.presto.expressions.translator.RowExpressionTranslator;
import com.facebook.presto.expressions.translator.RowExpressionTreeTranslator;
import com.facebook.presto.expressions.translator.TranslatedExpression;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowExpressionTranslator {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private final FunctionAndTypeManager functionAndTypeManager = METADATA.getFunctionAndTypeManager();
    private final TestingRowExpressionTranslator sqlToRowExpressionTranslator = new TestingRowExpressionTranslator(METADATA);

    @Test
    public void testEndToEndFunctionTranslation() {
        String untranslated = "LN(bitwise_and(1, col1))";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"col1", (Object)BigintType.BIGINT));
        CallExpression callExpression = (CallExpression)this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), typeProvider);
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)callExpression, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertTrue((boolean)translatedExpression.getTranslated().isPresent());
        Assert.assertEquals(translatedExpression.getTranslated().get(), (Object)"LNof(1 BITWISE_AND col1)");
    }

    @Test
    public void testEndToEndSpecialFormTranslation() {
        String untranslated = "col1 AND col2";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"col1", (Object)BooleanType.BOOLEAN, (Object)"col2", (Object)BooleanType.BOOLEAN));
        RowExpression specialForm = this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), typeProvider);
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)specialForm, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertTrue((boolean)translatedExpression.getTranslated().isPresent());
        Assert.assertEquals(translatedExpression.getTranslated().get(), (Object)"col1 TEST_AND col2");
    }

    @Test
    public void testMissingFunctionTranslator() {
        String untranslated = "ABS(col1)";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"col1", (Object)DoubleType.DOUBLE));
        RowExpression specialForm = this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), typeProvider);
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)specialForm, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertFalse((boolean)translatedExpression.getTranslated().isPresent());
    }

    @Test
    public void testIncorrectFunctionSignatureInDefinition() {
        String untranslated = "CEIL(col1)";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"col1", (Object)DoubleType.DOUBLE));
        RowExpression specialForm = this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), typeProvider);
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)specialForm, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertFalse((boolean)translatedExpression.getTranslated().isPresent());
    }

    @Test
    public void testHiddenFunctionNot() {
        String untranslated = "NOT true";
        RowExpression specialForm = this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), TypeProvider.empty());
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)specialForm, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertTrue((boolean)translatedExpression.getTranslated().isPresent());
        Assert.assertEquals(translatedExpression.getTranslated().get(), (Object)"NOT_2 true");
    }

    @Test
    public void testBasicOperator() {
        String untranslated = "col1 + col2";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"col1", (Object)BigintType.BIGINT, (Object)"col2", (Object)BigintType.BIGINT));
        RowExpression specialForm = this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), typeProvider);
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)specialForm, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertTrue((boolean)translatedExpression.getTranslated().isPresent());
        Assert.assertEquals(translatedExpression.getTranslated().get(), (Object)"col1 -|- col2");
    }

    @Test
    public void testLessThanOperator() {
        String untranslated = "col1 < col2";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"col1", (Object)BigintType.BIGINT, (Object)"col2", (Object)BigintType.BIGINT));
        RowExpression specialForm = this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), typeProvider);
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)specialForm, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertTrue((boolean)translatedExpression.getTranslated().isPresent());
        Assert.assertEquals(translatedExpression.getTranslated().get(), (Object)"col1 LT col2");
    }

    @Test
    public void testUntranslatableSpecialForm() {
        String untranslated = "col1 OR col2";
        TypeProvider typeProvider = TypeProvider.copyOf((Map)ImmutableMap.of((Object)"col1", (Object)BooleanType.BOOLEAN, (Object)"col2", (Object)BooleanType.BOOLEAN));
        RowExpression specialForm = this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(untranslated), typeProvider);
        TranslatedExpression translatedExpression = RowExpressionTreeTranslator.translateWith((RowExpression)specialForm, (RowExpressionTranslator)new TestFunctionTranslator(this.functionAndTypeManager, (FunctionTranslator<String>)FunctionTranslator.buildFunctionTranslator((Set)ImmutableSet.of(TestFunctions.class))), Collections.emptyMap());
        Assert.assertFalse((boolean)translatedExpression.getTranslated().isPresent());
    }

    private class TestFunctionTranslator
    extends RowExpressionTranslator<String, Map<VariableReferenceExpression, ColumnHandle>> {
        private final FunctionAndTypeManager functionAndTypeManager;
        private final FunctionTranslator<String> functionTranslator;

        TestFunctionTranslator(FunctionAndTypeManager functionAndTypeManager, FunctionTranslator<String> functionTranslator) {
            this.functionTranslator = Objects.requireNonNull(functionTranslator);
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager);
        }

        public TranslatedExpression<String> translateConstant(ConstantExpression literal, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<String, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
            return new TranslatedExpression(Optional.of(literal.toString()), (RowExpression)literal, Collections.emptyList());
        }

        public TranslatedExpression<String> translateCall(CallExpression callExpression, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<String, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
            List translatedExpressions = callExpression.getArguments().stream().map(expression -> rowExpressionTreeTranslator.rewrite(expression, (Object)context)).collect(Collectors.toList());
            FunctionMetadata functionMetadata = this.functionAndTypeManager.getFunctionMetadata(callExpression.getFunctionHandle());
            try {
                return this.functionTranslator.translate(functionMetadata, (RowExpression)callExpression, translatedExpressions);
            }
            catch (Throwable t) {
                return TranslatedExpression.untranslated((RowExpression)callExpression, translatedExpressions);
            }
        }

        public TranslatedExpression<String> translateSpecialForm(SpecialFormExpression specialFormExpression, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<String, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
            if (!specialFormExpression.getForm().equals((Object)SpecialFormExpression.Form.AND)) {
                return TranslatedExpression.untranslated((RowExpression)specialFormExpression);
            }
            List translatedExpressions = specialFormExpression.getArguments().stream().map(expression -> rowExpressionTreeTranslator.rewrite(expression, (Object)context)).collect(Collectors.toList());
            Assert.assertTrue((boolean)((TranslatedExpression)translatedExpressions.get(0)).getTranslated().isPresent());
            Assert.assertTrue((boolean)((TranslatedExpression)translatedExpressions.get(1)).getTranslated().isPresent());
            return new TranslatedExpression(Optional.of((String)((TranslatedExpression)translatedExpressions.get(0)).getTranslated().get() + " TEST_AND " + (String)((TranslatedExpression)translatedExpressions.get(1)).getTranslated().get()), (RowExpression)specialFormExpression, translatedExpressions);
        }

        public TranslatedExpression<String> translateVariable(VariableReferenceExpression variable, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<String, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
            return new TranslatedExpression(Optional.of(variable.getName()), (RowExpression)variable, Collections.emptyList());
        }
    }

    public static class TestFunctions {
        @ScalarFunction
        @SqlType(value="bigint")
        public static String bitwiseAnd(@SqlType(value="bigint") String left, @SqlType(value="bigint") String right) {
            return left + " BITWISE_AND " + right;
        }

        @ScalarFunction(value="ln")
        @SqlType(value="double")
        public static String ln(@SqlType(value="double") String sql) {
            return "LNof(" + sql + ")";
        }

        @ScalarFunction(value="ceil")
        @SqlType(value="double")
        public static String ceil(@SqlType(value="boolean") String sql) {
            return "CEILof(" + sql + ")";
        }

        @ScalarFunction(value="not")
        @SqlType(value="boolean")
        public static String not(@SqlType(value="boolean") String sql) {
            return "NOT_2 " + sql;
        }

        @ScalarOperator(value=OperatorType.ADD)
        @SqlType(value="bigint")
        public static String plus(@SqlType(value="bigint") String left, @SqlType(value="bigint") String right) {
            return left + " -|- " + right;
        }

        @ScalarOperator(value=OperatorType.LESS_THAN)
        @SqlType(value="boolean")
        public static String lessThan(@SqlType(value="bigint") String left, @SqlType(value="bigint") String right) {
            return left + " LT " + right;
        }
    }
}

