/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tdigest;

import com.facebook.presto.tdigest.TDigest;
import io.airlift.slice.Slice;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkTDigest {
    private static final int NUMBER_OF_ENTRIES = 1000000;
    private static final int STANDARD_COMPRESSION_FACTOR = 100;

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OperationsPerInvocation(value=1000000)
    public TDigest benchmarkInsertsT(Data data) {
        TDigest digest = TDigest.createTDigest((double)100.0);
        int k = 1;
        for (int i = 0; i < k; ++i) {
            for (long value : data.normalDistribution1) {
                digest.add((double)value);
            }
        }
        return digest;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public double benchmarkQuantilesT(DigestWithQuantile data) {
        return data.digest1.getQuantile((double)data.quantile);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public TDigest benchmarkCopyT(Digest data) {
        TDigest copy = TDigest.createTDigest((double)data.digest1.getCompressionFactor());
        copy.merge(data.digest1);
        return copy;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public TDigest benchmarkMergeT(Digest data) {
        TDigest merged = TDigest.createTDigest((Slice)data.digest1.serialize());
        merged.merge(data.digest2);
        return merged;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public TDigest benchmarkDeserializeT(Digest data) {
        return TDigest.createTDigest((Slice)data.serializedDigest1);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public Slice benchmarkSerializeT(Digest data) {
        return data.digest1.serialize();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkTDigest.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        private long[] normalDistribution1;
        private long[] normalDistribution2;

        @Setup
        public void setup() {
            this.normalDistribution1 = this.makeNormalValues(1000000);
            this.normalDistribution2 = this.makeNormalValues(1000000);
        }

        private long[] makeNormalValues(int size) {
            long[] values = new long[size];
            for (int i = 0; i < size; ++i) {
                long value;
                values[i] = value = Math.abs((long)(ThreadLocalRandom.current().nextGaussian() * 1.0E9));
            }
            return values;
        }

        private long[] makeRandomValues(int size) {
            long[] values = new long[size];
            for (int i = 0; i < size; ++i) {
                values[i] = (long)(Math.random() * 1.0E9);
            }
            return values;
        }
    }

    @State(value=Scope.Thread)
    public static class DigestWithQuantile
    extends Digest {
        @Param(value={"0.0001", "0.01", "0.2500", "0.5000", "0.7500", "0.9999"})
        float quantile;
    }

    @State(value=Scope.Thread)
    public static class Digest {
        protected TDigest digest1;
        protected TDigest digest2;
        protected Slice serializedDigest1;

        @Setup
        public void setup(Data data) {
            this.digest1 = this.makeTDigest(data.normalDistribution1);
            this.digest2 = this.makeTDigest(data.normalDistribution2);
            this.serializedDigest1 = this.digest1.serialize();
        }

        private TDigest makeTDigest(long[] values) {
            TDigest result = TDigest.createTDigest((double)100.0);
            int k = 1;
            for (int i = 0; i < k; ++i) {
                for (long value : values) {
                    result.add((double)value);
                }
            }
            return result;
        }
    }
}

