/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestTransactionManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((TransactionManagerConfig)ConfigAssertions.recordDefaults(TransactionManagerConfig.class)).setIdleCheckInterval(new Duration(1.0, TimeUnit.MINUTES)).setIdleTimeout(new Duration(5.0, TimeUnit.MINUTES)).setCompanionCatalogs("").setMaxFinishingConcurrency(1));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"transaction.idle-check-interval", (Object)"1s").put((Object)"transaction.idle-timeout", (Object)"10s").put((Object)"transaction.max-finishing-concurrency", (Object)"100").put((Object)"transaction.companion-catalogs", (Object)"cat1=cat2,cat2=cat3").build();
        TransactionManagerConfig expected = new TransactionManagerConfig().setIdleCheckInterval(new Duration(1.0, TimeUnit.SECONDS)).setIdleTimeout(new Duration(10.0, TimeUnit.SECONDS)).setCompanionCatalogs("cat1=cat2,cat2=cat3").setMaxFinishingConcurrency(100);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

