/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.type.AbstractTestType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBooleanType
extends AbstractTestType {
    public TestBooleanType() {
        super((Type)BooleanType.BOOLEAN, Boolean.class, TestBooleanType.createTestBlock());
    }

    @Test
    public void testBooleanBlockWithoutNullsFromByteArray() {
        byte[] booleanBytes = new byte[4];
        BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(booleanBytes.length);
        for (int i = 0; i < booleanBytes.length; ++i) {
            boolean value = i % 2 == 0;
            booleanBytes[i] = value ? (byte)1 : 0;
            BooleanType.BOOLEAN.writeBoolean(builder, value);
        }
        Block wrappedBlock = BooleanType.wrapByteArrayAsBooleanBlockWithoutNulls((byte[])booleanBytes);
        Block builderBlock = builder.build();
        Assert.assertFalse((boolean)wrappedBlock.mayHaveNull());
        Assert.assertTrue((boolean)(wrappedBlock instanceof ByteArrayBlock));
        Assert.assertTrue((boolean)(builderBlock instanceof ByteArrayBlock));
        BlockAssertions.assertBlockEquals((Type)BooleanType.BOOLEAN, wrappedBlock, builderBlock);
        Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(wrappedBlock, 0));
        booleanBytes[0] = 0;
        Assert.assertFalse((boolean)BooleanType.BOOLEAN.getBoolean(wrappedBlock, 0));
    }

    @Test
    public void testBooleanBlockWithSingleNonNullValue() {
        Assert.assertTrue((boolean)(BooleanType.createBlockForSingleNonNullValue((boolean)true) instanceof ByteArrayBlock));
        Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(BooleanType.createBlockForSingleNonNullValue((boolean)true), 0));
        Assert.assertFalse((boolean)BooleanType.BOOLEAN.getBoolean(BooleanType.createBlockForSingleNonNullValue((boolean)false), 0));
        Assert.assertFalse((boolean)BooleanType.createBlockForSingleNonNullValue((boolean)false).mayHaveNull());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, 15);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return true;
    }
}

