/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestCharOperators
extends AbstractTestFunctions {
    @Test
    public void testEqual() {
        this.assertFunction("cast('foo' as char(3)) = cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) = cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) = cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) = cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(5)) = 'bar'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(5)) = 'bar   '", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('a' as char(2)) = cast('a ' as char(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('a ' as char(2)) = cast('a' as char(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('a' as char(3)) = cast('a' as char(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('' as char(3)) = cast('' as char(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('' as char(2)) = cast('' as char(2))", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("cast('foo' as char(3)) <> cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) <> cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) <> cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(3)) <> cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(5)) <> 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(5)) <> 'bar   '", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('a' as char(2)) <> cast('a ' as char(2))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('a ' as char(2)) <> cast('a' as char(2))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('a' as char(3)) <> cast('a' as char(2))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('' as char(3)) <> cast('' as char(2))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('' as char(2)) <> cast('' as char(2))", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("cast('bar' as char(5)) < cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(5)) < cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) < cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) < cast('bar' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) < cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) < cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(5)) < cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) < cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) < cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foobar' as char(6)) < cast('foobaz' as char(6))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foob r' as char(6)) < cast('foobar' as char(6))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000' as char(1)) < cast(' ' as char(1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000' as char(1)) < cast('' as char(0))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('abc\u0000' as char(4)) < cast('abc' as char(4))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000' as char(1)) < cast('\u0000 ' as char(2))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('\u0000' as char(2)) < cast('\u0000 ' as char(2))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('\u0000 a' as char(3)) < cast('\u0000' as char(3))", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("cast('bar' as char(5)) <= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(5)) <= cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) <= cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) <= cast('bar' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) <= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) <= cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(5)) <= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) <= cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) <= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foobar' as char(6)) <= cast('foobaz' as char(6))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foob r' as char(6)) <= cast('foobar' as char(6))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000' as char(1)) <= cast(' ' as char(1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000' as char(1)) <= cast('' as char(0))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('abc\u0000' as char(4)) <= cast('abc' as char(4))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000' as char(1)) <= cast('\u0000 ' as char(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000' as char(2)) <= cast('\u0000 ' as char(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000 a' as char(3)) <= cast('\u0000' as char(3))", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("cast('bar' as char(5)) > cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(5)) > cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(3)) > cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) > cast('bar' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) > cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) > cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(5)) > cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) > cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(3)) > cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foobar' as char(6)) > cast('foobaz' as char(6))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foob r' as char(6)) > cast('foobar' as char(6))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast(' ' as char(1)) > cast('\u0000' as char(1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('' as char(0)) > cast('\u0000' as char(1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('abc' as char(4)) > cast('abc\u0000' as char(4))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000 ' as char(2)) > cast('\u0000' as char(1))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('\u0000 ' as char(2)) > cast('\u0000' as char(2))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('\u0000 a' as char(3)) > cast('\u0000' as char(3))", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("cast('bar' as char(5)) >= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(5)) >= cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(3)) >= cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) >= cast('bar' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) >= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) >= cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(5)) >= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) >= cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(3)) >= cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foobar' as char(6)) >= cast('foobaz' as char(6))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foob r' as char(6)) >= cast('foobar' as char(6))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast(' ' as char(1)) >= cast('\u0000' as char(1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('' as char(0)) >= cast('\u0000' as char(1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('abc' as char(4)) >= cast('abc\u0000' as char(4))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000 ' as char(2)) >= cast('\u0000' as char(1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000 ' as char(2)) >= cast('\u0000' as char(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000 a' as char(3)) >= cast('\u0000' as char(3))", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("cast('bbb' as char(3)) BETWEEN cast('aaa' as char(3)) AND cast('ccc' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) BETWEEN cast('foo' as char(3)) AND cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) BETWEEN cast('foo' as char(3)) AND cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) BETWEEN cast('zzz' as char(3)) AND cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) NOT BETWEEN cast('zzz' as char(3)) AND cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) BETWEEN cast('bar' as char(3)) AND cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) BETWEEN cast('bar' as char(3)) AND cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) BETWEEN cast('foo' as char(3)) AND cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) BETWEEN cast('foo' as char(3)) AND cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(3)) BETWEEN cast('bar' as char(3)) AND cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(3)) BETWEEN cast('bar' as char(3)) AND cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\u0000 a' as char(3)) BETWEEN cast('\u0000' as char(3)) AND cast('\u0000a' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(4)) BETWEEN cast('bar' as char(3)) AND cast('bar' as char(5))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(4)) BETWEEN cast('bar' as char(5)) AND cast('bar' as char(7))", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("cast(NULL as char(3)) IS DISTINCT FROM cast(NULL as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast(NULL as char(3)) IS DISTINCT FROM cast(NULL as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) IS DISTINCT FROM cast('foo' as char(5))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) IS DISTINCT FROM cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('foo' as char(3)) IS DISTINCT FROM cast('bar' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(3)) IS DISTINCT FROM cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foo' as char(3)) IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('bar' as char(5)) IS DISTINCT FROM 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast('bar' as char(5)) IS DISTINCT FROM 'bar   '", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("NULL IS DISTINCT FROM cast('foo' as char(3))", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "CAST(null AS CHAR(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "CHAR '123'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCharCast() {
        this.assertFunction("CAST(CAST('78.95' AS CHAR(5)) AS DOUBLE)", (Type)DoubleType.DOUBLE, 78.95);
        this.assertFunction("CAST(CAST(' 45.58  ' AS CHAR(10)) AS DOUBLE)", (Type)DoubleType.DOUBLE, 45.58);
        this.assertInvalidCast("CAST(CAST('  Z56  ' AS CHAR(20)) AS DOUBLE)");
        this.assertFunction("CAST(CAST('45.783' AS CHAR(6)) AS REAL)", (Type)RealType.REAL, Float.valueOf(45.783f));
        this.assertFunction("CAST(CAST(' 45.783  ' AS CHAR(10)) AS REAL)", (Type)RealType.REAL, Float.valueOf(45.783f));
        this.assertInvalidCast("CAST(CAST('  Z56  ' AS CHAR(20)) AS REAL)");
        this.assertFunctionString("CAST(CAST('6.40282346638528860e+70' AS CHAR(60)) AS REAL)", (Type)RealType.REAL, "Infinity");
        this.assertFunction("CAST(CAST('45' AS CHAR(2)) AS BIGINT)", (Type)BigintType.BIGINT, 45L);
        this.assertFunction("CAST(CAST(' 45  ' AS CHAR(10)) AS BIGINT)", (Type)BigintType.BIGINT, 45L);
        this.assertInvalidCast("CAST(CAST('  Z56  ' AS CHAR(20)) AS BIGINT)");
        this.assertFunction("CAST(CAST('45' AS CHAR(2)) AS INTEGER)", (Type)IntegerType.INTEGER, 45);
        this.assertFunction("CAST(CAST('2147483647' AS CHAR(10)) AS INTEGER)", (Type)IntegerType.INTEGER, Integer.MAX_VALUE);
        this.assertFunction("CAST(CAST(' 45  ' AS CHAR(10)) AS INTEGER)", (Type)IntegerType.INTEGER, 45);
        this.assertInvalidCast("CAST(CAST('  Z56  ' AS CHAR(20)) AS INTEGER)");
        this.assertInvalidCast("CAST(CAST('2147483648' AS CHAR(10)) AS INTEGER)");
        this.assertFunction("CAST(CAST('45' AS CHAR(2)) AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)45);
        this.assertFunction("CAST(CAST(' 45  ' AS CHAR(10)) AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)45);
        this.assertInvalidCast("CAST(CAST('  Z56  ' AS CHAR(20)) AS SMALLINT)");
        this.assertFunction("CAST(CAST('123' AS CHAR(3)) AS TINYINT)", (Type)TinyintType.TINYINT, (byte)123);
        this.assertFunction("CAST(CAST(' 123  ' AS CHAR(10)) AS TINYINT)", (Type)TinyintType.TINYINT, (byte)123);
        this.assertInvalidCast("CAST(CAST('  Z56  ' AS CHAR(20)) AS TINYINT)");
    }
}

