/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowOperators
extends AbstractTestFunctions {
    private static FunctionAssertions legacyRowFieldOrdinalAccess;
    private static FunctionAssertions fieldNameInJsonCastEnabled;
    private static FunctionAssertions legacyJsonCastEnabled;
    private static FunctionAssertions legacyJsonCastDisabled;
    private static FunctionAssertions canonicalizedJsonExtractDisabled;
    private static FunctionAssertions canonicalizedJsonExtractEnabled;

    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
        legacyRowFieldOrdinalAccess = new FunctionAssertions(Session.builder((Session)this.session).setSystemProperty("legacy_row_field_ordinal_access", "true").build(), new FeaturesConfig());
        fieldNameInJsonCastEnabled = new FunctionAssertions(Session.builder((Session)this.session).setSystemProperty("field_names_in_json_cast_enabled", "true").build(), new FeaturesConfig());
        FunctionsConfig featuresConfigWithLegacyJsonCastEnabled = new FunctionsConfig().setLegacyJsonCast(true);
        legacyJsonCastEnabled = new FunctionAssertions(this.session, new FeaturesConfig(), featuresConfigWithLegacyJsonCastEnabled, true);
        FunctionsConfig featuresConfigWithLegacyJsonCastDisabled = new FunctionsConfig().setLegacyJsonCast(false);
        legacyJsonCastDisabled = new FunctionAssertions(this.session, new FeaturesConfig(), featuresConfigWithLegacyJsonCastDisabled, true);
        FunctionsConfig featuresConfigWithCanonicalizedJsonExtractDisabled = new FunctionsConfig().setCanonicalizedJsonExtract(false);
        canonicalizedJsonExtractDisabled = new FunctionAssertions(this.session, new FeaturesConfig(), featuresConfigWithCanonicalizedJsonExtractDisabled, true);
        FunctionsConfig featuresConfigWithCanonicalizedJsonExtractEnabled = new FunctionsConfig().setCanonicalizedJsonExtract(true);
        canonicalizedJsonExtractEnabled = new FunctionAssertions(this.session, new FeaturesConfig(), featuresConfigWithCanonicalizedJsonExtractEnabled, true);
    }

    @AfterClass(alwaysRun=true)
    public final void tearDown() {
        legacyRowFieldOrdinalAccess.close();
        legacyRowFieldOrdinalAccess = null;
        fieldNameInJsonCastEnabled.close();
        fieldNameInJsonCastEnabled = null;
        legacyJsonCastEnabled.close();
        legacyJsonCastEnabled = null;
        legacyJsonCastDisabled.close();
        legacyJsonCastDisabled = null;
        canonicalizedJsonExtractDisabled.close();
        canonicalizedJsonExtractDisabled = null;
        canonicalizedJsonExtractEnabled.close();
        canonicalizedJsonExtractEnabled = null;
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testRowTypeLookup() {
        this.functionAssertions.getMetadata().getType(TypeSignature.parseTypeSignature((String)"row(a bigint)"));
        Type type = this.functionAssertions.getMetadata().getType(TypeSignature.parseTypeSignature((String)"row(b bigint)"));
        Assert.assertEquals((int)type.getTypeSignature().getParameters().size(), (int)1);
        Assert.assertEquals((String)((String)((TypeSignatureParameter)type.getTypeSignature().getParameters().get(0)).getNamedTypeSignature().getName().get()), (String)"b");
    }

    @Test
    public void testRowToJson() {
        fieldNameInJsonCastEnabled.assertFunction("cast(cast (null as ROW(BIGINT, VARCHAR)) AS JSON)", (Type)JsonType.JSON, null);
        fieldNameInJsonCastEnabled.assertFunction("cast(ROW(null, null) as json)", (Type)JsonType.JSON, "{\"\":null,\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("cast(ROW(true, false, null) AS JSON)", (Type)JsonType.JSON, "{\"\":true,\"\":false,\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("cast(cast(ROW(12, 12345, 123456789, 1234567890123456789, null, null, null, null) AS ROW(TINYINT, SMALLINT, INTEGER, BIGINT, TINYINT, SMALLINT, INTEGER, BIGINT)) AS JSON)", (Type)JsonType.JSON, "{\"\":12,\"\":12345,\"\":123456789,\"\":1234567890123456789,\"\":null,\"\":null,\"\":null,\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(CAST(3.14E0 AS REAL), 3.1415E0, 1e308, DECIMAL '3.14', DECIMAL '12345678901234567890.123456789012345678', CAST(null AS REAL), CAST(null AS DOUBLE), CAST(null AS DECIMAL)) AS JSON)", (Type)JsonType.JSON, "{\"\":3.14,\"\":3.1415,\"\":1.0E308,\"\":3.14,\"\":12345678901234567890.123456789012345678,\"\":null,\"\":null,\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW('a', 'bb', CAST(null as VARCHAR), JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', CAST(null AS JSON)) AS JSON)", (Type)JsonType.JSON, "{\"\":\"a\",\"\":\"bb\",\"\":null,\"\":123,\"\":3.14,\"\":false,\"\":\"abc\",\"\":[1,\"a\",null],\"\":{\"a\":1,\"b\":\"str\",\"c\":null},\"\":null,\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(DATE '2001-08-22', DATE '2001-08-23', null) AS JSON)", (Type)JsonType.JSON, "{\"\":\"2001-08-22\",\"\":\"2001-08-23\",\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(TIMESTAMP '1970-01-01 00:00:01', cast(null as TIMESTAMP)) AS JSON)", (Type)JsonType.JSON, String.format("{\"\":\"%s\",\"\":null}", DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        fieldNameInJsonCastEnabled.assertFunction("cast(ROW(ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], CAST(null AS ARRAY<BIGINT>)) AS JSON)", (Type)JsonType.JSON, "{\"\":[1,2],\"\":[3,null],\"\":[],\"\":[null,null],\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("cast(ROW(MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), CAST(NULL as MAP<VARCHAR, BIGINT>)) AS JSON)", (Type)JsonType.JSON, "{\"\":{\"a\":1,\"b\":2},\"\":{\"none\":null,\"three\":3},\"\":{},\"\":{\"h1\":null,\"h2\":null},\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("cast(ROW(ROW(1, 2), ROW(3, CAST(null as INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null) AS JSON)", (Type)JsonType.JSON, "{\"\":{\"\":1,\"\":2},\"\":{\"\":3,\"\":null},\"\":{\"\":null,\"\":null},\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(1, 2) AS JSON)", (Type)JsonType.JSON, "{\"\":1,\"\":2}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(CAST(ROW(1, 2) AS ROW(a BIGINT, b BIGINT)) AS JSON)", (Type)JsonType.JSON, "{\"a\":1,\"b\":2}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(1, NULL) AS JSON)", (Type)JsonType.JSON, "{\"\":1,\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(1, CAST(NULL AS INTEGER)) AS JSON)", (Type)JsonType.JSON, "{\"\":1,\"\":null}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(1, 2.0E0) AS JSON)", (Type)JsonType.JSON, "{\"\":1,\"\":2.0}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(1.0E0, 2.5E0) AS JSON)", (Type)JsonType.JSON, "{\"\":1.0,\"\":2.5}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(1.0E0, 'kittens') AS JSON)", (Type)JsonType.JSON, "{\"\":1.0,\"\":\"kittens\"}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(TRUE, FALSE) AS JSON)", (Type)JsonType.JSON, "{\"\":true,\"\":false}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(ROW(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) AS JSON)", (Type)JsonType.JSON, "{\"\":false,\"\":[1,2],\"\":{\"1\":2.0,\"3\":4.0}}");
        fieldNameInJsonCastEnabled.assertFunction("CAST(row(1.0, 123123123456.6549876543) AS JSON)", (Type)JsonType.JSON, "{\"\":1.0,\"\":123123123456.6549876543}");
    }

    @Test
    public void testRowToJsonNoFieldNames() {
        this.assertFunction("cast(cast (null as ROW(BIGINT, VARCHAR)) AS JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(ROW(null, null) as json)", (Type)JsonType.JSON, "[null,null]");
        this.assertFunction("cast(ROW(true, false, null) AS JSON)", (Type)JsonType.JSON, "[true,false,null]");
        this.assertFunction("cast(cast(ROW(12, 12345, 123456789, 1234567890123456789, null, null, null, null) AS ROW(TINYINT, SMALLINT, INTEGER, BIGINT, TINYINT, SMALLINT, INTEGER, BIGINT)) AS JSON)", (Type)JsonType.JSON, "[12,12345,123456789,1234567890123456789,null,null,null,null]");
        this.assertFunction("CAST(ROW(CAST(3.14E0 AS REAL), 3.1415E0, 1e308, DECIMAL '3.14', DECIMAL '12345678901234567890.123456789012345678', CAST(null AS REAL), CAST(null AS DOUBLE), CAST(null AS DECIMAL)) AS JSON)", (Type)JsonType.JSON, "[3.14,3.1415,1.0E308,3.14,12345678901234567890.123456789012345678,null,null,null]");
        this.assertFunction("CAST(ROW('a', 'bb', CAST(null as VARCHAR), JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', CAST(null AS JSON)) AS JSON)", (Type)JsonType.JSON, "[\"a\",\"bb\",null,123,3.14,false,\"abc\",[1,\"a\",null],{\"a\":1,\"b\":\"str\",\"c\":null},null,null]");
        this.assertFunction("CAST(ROW(DATE '2001-08-22', DATE '2001-08-23', null) AS JSON)", (Type)JsonType.JSON, "[\"2001-08-22\",\"2001-08-23\",null]");
        this.assertFunction("CAST(ROW(TIMESTAMP '1970-01-01 00:00:01', cast(null as TIMESTAMP)) AS JSON)", (Type)JsonType.JSON, String.format("[\"%s\",null]", DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("cast(ROW(ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], CAST(null AS ARRAY<BIGINT>)) AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[],[null,null],null]");
        this.assertFunction("cast(ROW(MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), CAST(NULL as MAP<VARCHAR, BIGINT>)) AS JSON)", (Type)JsonType.JSON, "[{\"a\":1,\"b\":2},{\"none\":null,\"three\":3},{},{\"h1\":null,\"h2\":null},null]");
        this.assertFunction("cast(ROW(ROW(1, 2), ROW(3, CAST(null as INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null) AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[null,null],null]");
        this.assertFunction("CAST(ROW(1, 2) AS JSON)", (Type)JsonType.JSON, "[1,2]");
        this.assertFunction("CAST(CAST(ROW(1, 2) AS ROW(a BIGINT, b BIGINT)) AS JSON)", (Type)JsonType.JSON, "[1,2]");
        this.assertFunction("CAST(ROW(1, NULL) AS JSON)", (Type)JsonType.JSON, "[1,null]");
        this.assertFunction("CAST(ROW(1, CAST(NULL AS INTEGER)) AS JSON)", (Type)JsonType.JSON, "[1,null]");
        this.assertFunction("CAST(ROW(1, 2.0E0) AS JSON)", (Type)JsonType.JSON, "[1,2.0]");
        this.assertFunction("CAST(ROW(1.0E0, 2.5E0) AS JSON)", (Type)JsonType.JSON, "[1.0,2.5]");
        this.assertFunction("CAST(ROW(1.0E0, 'kittens') AS JSON)", (Type)JsonType.JSON, "[1.0,\"kittens\"]");
        this.assertFunction("CAST(ROW(TRUE, FALSE) AS JSON)", (Type)JsonType.JSON, "[true,false]");
        this.assertFunction("CAST(ROW(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) AS JSON)", (Type)JsonType.JSON, "[false,[1,2],{\"1\":2.0,\"3\":4.0}]");
        this.assertFunction("CAST(row(1.0, 123123123456.6549876543) AS JSON)", (Type)JsonType.JSON, "[1.0,123123123456.6549876543]");
    }

    @Test
    public void testJsonToRow() {
        this.assertFunction("CAST(CAST (null AS JSON) AS ROW(BIGINT))", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)), null);
        this.assertFunction("CAST(JSON 'null' AS ROW(BIGINT))", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)), null);
        this.assertFunction("CAST(JSON '[null, null]' AS ROW(VARCHAR, BIGINT))", (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)), Lists.newArrayList((Object[])new Object[]{null, null}));
        this.assertFunction("CAST(JSON '{\"k2\": null, \"k1\": null}' AS ROW(k1 VARCHAR, k2 BIGINT))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"k2", (Type)BigintType.BIGINT))), Lists.newArrayList((Object[])new Object[]{null, null}));
        this.assertFunction("CAST(JSON '{\"k1\": [1, 2], \"used\": 3, \"k2\": [4, 5]}' AS ROW(used BIGINT))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"used", (Type)BigintType.BIGINT))), ImmutableList.of((Object)3L));
        this.assertFunction("CAST(JSON '[{\"k1\": [1, 2], \"used\": 3, \"k2\": [4, 5]}]' AS ARRAY<ROW(used BIGINT)>)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"used", (Type)BigintType.BIGINT)))), ImmutableList.of((Object)ImmutableList.of((Object)3L)));
        this.assertFunction("CAST(JSON '{\"a\":1,\"c\":3}' AS ROW(a BIGINT, b BIGINT, c BIGINT, d BIGINT))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"c", (Type)BigintType.BIGINT), (Object)RowType.field((String)"d", (Type)BigintType.BIGINT))), Arrays.asList(1L, null, 3L, null));
        this.assertFunction("CAST(JSON '[{\"a\":1,\"c\":3}]' AS ARRAY<ROW(a BIGINT, b BIGINT, c BIGINT, d BIGINT)>)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"c", (Type)BigintType.BIGINT), (Object)RowType.field((String)"d", (Type)BigintType.BIGINT)))), ImmutableList.of(Arrays.asList(1L, null, 3L, null)));
        this.assertFunction("CAST(unchecked_to_json('{\"k4\": 4, \"k2\": 2, \"k3\": 3, \"k1\": 1}') AS ROW(k1 BIGINT, k2 BIGINT, k3 BIGINT, k4 BIGINT))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k3", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k4", (Type)BigintType.BIGINT))), ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        this.assertFunction("CAST(unchecked_to_json('[{\"k4\": 4, \"k2\": 2, \"k3\": 3, \"k1\": 1}]') AS ARRAY<ROW(k1 BIGINT, k2 BIGINT, k3 BIGINT, k4 BIGINT)>)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k3", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k4", (Type)BigintType.BIGINT)))), ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L)));
        this.assertFunction("CAST(JSON '[true, false, 12, 0, 12.3, 0.0, \"true\", \"false\", null]' AS ROW(BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN))", (Type)RowType.anonymous((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN)), Arrays.asList(true, false, true, false, true, false, true, false, null));
        this.assertFunction("CAST(JSON '{\"k1\": true, \"k2\": false, \"k3\": 12, \"k4\": 0, \"k5\": 12.3, \"k6\": 0.0, \"k7\": \"true\", \"k8\": \"false\", \"k9\": null}' AS ROW(k1 BOOLEAN, k2 BOOLEAN, k3 BOOLEAN, k4 BOOLEAN, k5 BOOLEAN, k6 BOOLEAN, k7 BOOLEAN, k8 BOOLEAN, k9 BOOLEAN))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k2", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k3", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k4", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k5", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k6", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k7", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k8", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k9", (Type)BooleanType.BOOLEAN))), Arrays.asList(true, false, true, false, true, false, true, false, null));
        this.assertFunction("CAST(JSON '[12,12345,123456789,1234567890123456789,null,null,null,null]' AS ROW(TINYINT, SMALLINT, INTEGER, BIGINT, TINYINT, SMALLINT, INTEGER, BIGINT))", (Type)RowType.anonymous((List)ImmutableList.of((Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT)), Arrays.asList((byte)12, (short)12345, 123456789, 1234567890123456789L, null, null, null, null));
        this.assertFunction("CAST(JSON '{\"tinyint_value\": 12, \"tinyint_null\":null, \"smallint_value\":12345, \"smallint_null\":null,  \"integer_value\":123456789, \"integer_null\": null, \"bigint_value\":1234567890123456789, \"bigint_null\": null}' AS ROW(tinyint_value TINYINT, smallint_value SMALLINT, integer_value INTEGER, bigint_value BIGINT, tinyint_null TINYINT, smallint_null SMALLINT, integer_null INTEGER, bigint_null BIGINT))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"tinyint_value", (Type)TinyintType.TINYINT), (Object)RowType.field((String)"smallint_value", (Type)SmallintType.SMALLINT), (Object)RowType.field((String)"integer_value", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"bigint_value", (Type)BigintType.BIGINT), (Object)RowType.field((String)"tinyint_null", (Type)TinyintType.TINYINT), (Object)RowType.field((String)"smallint_null", (Type)SmallintType.SMALLINT), (Object)RowType.field((String)"integer_null", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"bigint_null", (Type)BigintType.BIGINT))), Arrays.asList((byte)12, (short)12345, 123456789, 1234567890123456789L, null, null, null, null));
        this.assertFunction("CAST(JSON '[12345.67,1234567890.1,123.456,12345678.12345678,null,null,null]' AS ROW(REAL, DOUBLE, DECIMAL(10, 5), DECIMAL(38, 8), REAL, DOUBLE, DECIMAL(7, 7)))", (Type)RowType.anonymous((List)ImmutableList.of((Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)DecimalType.createDecimalType((int)10, (int)5), (Object)DecimalType.createDecimalType((int)38, (int)8), (Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)DecimalType.createDecimalType((int)7, (int)7))), Arrays.asList(Float.valueOf(12345.67f), 1.2345678901E9, TestRowOperators.decimal("123.45600"), TestRowOperators.decimal("12345678.12345678"), null, null, null));
        this.assertFunction("CAST(JSON '{\"real_value\": 12345.67, \"real_null\": null, \"double_value\": 1234567890.1, \"double_null\": null, \"decimal_value1\": 123.456, \"decimal_value2\": 12345678.12345678, \"decimal_null\": null}' AS ROW(real_value REAL, double_value DOUBLE, decimal_value1 DECIMAL(10, 5), decimal_value2 DECIMAL(38, 8), real_null REAL, double_null DOUBLE, decimal_null DECIMAL(7, 7)))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"real_value", (Type)RealType.REAL), (Object)RowType.field((String)"double_value", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"decimal_value1", (Type)DecimalType.createDecimalType((int)10, (int)5)), (Object)RowType.field((String)"decimal_value2", (Type)DecimalType.createDecimalType((int)38, (int)8)), (Object)RowType.field((String)"real_null", (Type)RealType.REAL), (Object)RowType.field((String)"double_null", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"decimal_null", (Type)DecimalType.createDecimalType((int)7, (int)7)))), Arrays.asList(Float.valueOf(12345.67f), 1.2345678901E9, TestRowOperators.decimal("123.45600"), TestRowOperators.decimal("12345678.12345678"), null, null, null));
        this.assertFunction("CAST(JSON '[\"puppies\", [1, 2, 3], null, null]' AS ROW(VARCHAR, JSON, VARCHAR, JSON))", (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)JsonType.JSON, (Object)VarcharType.VARCHAR, (Object)JsonType.JSON)), Arrays.asList("puppies", "[1,2,3]", null, "null"));
        this.assertFunction("CAST(JSON '{\"varchar_value\": \"puppies\", \"json_value\": [1, 2, 3], \"varchar_null\": null, \"json_null\": null}' AS ROW(varchar_value VARCHAR, json_value JSON, varchar_null VARCHAR, json_null JSON))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"varchar_value", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"json_value", (Type)JsonType.JSON), (Object)RowType.field((String)"varchar_null", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"json_null", (Type)JsonType.JSON))), Arrays.asList("puppies", "[1,2,3]", null, "null"));
        this.assertFunction("CAST(JSON '[[1, 2, null, 3], [], null, {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, {}, null, [1, 2, null, 3], null, {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, null]' AS ROW(ARRAY<BIGINT>, ARRAY<BIGINT>, ARRAY<BIGINT>, MAP<VARCHAR, BIGINT>, MAP<VARCHAR, BIGINT>, MAP<VARCHAR, BIGINT>, ROW(BIGINT, BIGINT, BIGINT, BIGINT), ROW(BIGINT),ROW(a BIGINT, b BIGINT, three BIGINT, none BIGINT), ROW(nothing BIGINT)))", (Type)RowType.anonymous((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), (Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)), (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"three", (Type)BigintType.BIGINT), (Object)RowType.field((String)"none", (Type)BigintType.BIGINT))), (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"nothing", (Type)BigintType.BIGINT))))), Arrays.asList(Arrays.asList(1L, 2L, null, 3L), Collections.emptyList(), null, TestRowOperators.asMap((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"none", (Object)"three"), Arrays.asList(1L, 2L, null, 3L)), ImmutableMap.of(), null, Arrays.asList(1L, 2L, null, 3L), null, Arrays.asList(1L, 2L, 3L, null), null));
        legacyJsonCastEnabled.assertFunction("CAST(JSON '{\"array2\": [1, 2, null, 3], \"array1\": [], \"array3\": null, \"map3\": {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, \"map1\": {}, \"map2\": null, \"rowAsJsonArray1\": [1, 2, null, 3], \"rowAsJsonArray2\": null, \"rowAsJsonObject2\": {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, \"rowAsJsonObject1\": null}' AS ROW(array1 ARRAY<BIGINT>, array2 ARRAY<BIGINT>, array3 ARRAY<BIGINT>, map1 MAP<VARCHAR, BIGINT>, map2 MAP<VARCHAR, BIGINT>, map3 MAP<VARCHAR, BIGINT>, rowAsJsonArray1 ROW(BIGINT, BIGINT, BIGINT, BIGINT), rowAsJsonArray2 ROW(BIGINT),rowAsJsonObject1 ROW(nothing BIGINT), rowAsJsonObject2 ROW(a BIGINT, b BIGINT, three BIGINT, none BIGINT)))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"array1", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"array2", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"array3", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"map1", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"map2", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"map3", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"rowasjsonarray1", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT))), (Object)RowType.field((String)"rowasjsonarray2", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))), (Object)RowType.field((String)"rowasjsonobject1", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"nothing", (Type)BigintType.BIGINT)))), (Object)RowType.field((String)"rowasjsonobject2", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"three", (Type)BigintType.BIGINT), (Object)RowType.field((String)"none", (Type)BigintType.BIGINT)))))), Arrays.asList(Collections.emptyList(), Arrays.asList(1L, 2L, null, 3L), null, ImmutableMap.of(), null, TestRowOperators.asMap((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"none", (Object)"three"), Arrays.asList(1L, 2L, null, 3L)), Arrays.asList(1L, 2L, null, 3L), null, null, Arrays.asList(1L, 2L, 3L, null)));
        legacyJsonCastDisabled.assertFunction("CAST(JSON '{\"array2\": [1, 2, null, 3], \"array1\": [], \"array3\": null, \"map3\": {\"a\": 1, \"b\": 2, \"none\": null, \"Three\": 3}, \"map1\": {}, \"map2\": null, \"rowAsJsonArray1\": [1, 2, null, 3], \"rowAsJsonArray2\": null, \"rowAsJsonObject2\": {\"a\": 1, \"b\": 2, \"none\": null, \"Three\": 3}, \"rowAsJsonObject1\": null}' AS ROW(array1 array<BIGINT>, array2 ARRAY<bigint>, array3 ARRAY<BIGINT>, map1 MAP<VARCHAR, BIGINT>, map2 map<varchar, BIGINT>, map3 MAP<VARCHAR, BIGINT>, \"rowAsJsonArray1\" row(BIGINT, bigint, BIGINT, BIGINT), \"rowAsJsonArray2\" ROW(BIGINT),\"rowAsJsonObject1\" ROW(nothing BIGINT), \"rowAsJsonObject2\" ROW(a BIGINT, b BIGINT, \"Three\" BIGINT, none BIGINT)))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"array1", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"array2", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"array3", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"map1", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"map2", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"map3", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"rowAsJsonArray1", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (boolean)true), (Object)RowType.field((String)"rowAsJsonArray2", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)), (boolean)true), (Object)RowType.field((String)"rowAsJsonObject1", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"nothing", (Type)BigintType.BIGINT))), (boolean)true), (Object)RowType.field((String)"rowAsJsonObject2", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"Three", (Type)BigintType.BIGINT, (boolean)true), (Object)RowType.field((String)"none", (Type)BigintType.BIGINT))), (boolean)true))), Arrays.asList(Collections.emptyList(), Arrays.asList(1L, 2L, null, 3L), null, ImmutableMap.of(), null, TestRowOperators.asMap((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"none", (Object)"Three"), Arrays.asList(1L, 2L, null, 3L)), Arrays.asList(1L, 2L, null, 3L), null, null, Arrays.asList(1L, 2L, 3L, null)));
        legacyJsonCastEnabled.assertFunction("CAST(json_extract('{\"1\":[{\"name\": \"John\", \"AGE\": 30}]}', '$') AS MAP<bigint, ARRAY<ROW(name VARCHAR, age VARCHAR)>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"name", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"age", (Type)VarcharType.VARCHAR))))), TestRowOperators.asMap((List)ImmutableList.of((Object)1L), Arrays.asList(Arrays.asList(Arrays.asList("John", "30")))));
        legacyJsonCastDisabled.assertFunction("CAST(json_extract('{\"1\":[{\"name\": \"John\", \"AGE\": 30}]}', '$') AS MAP<bigint, ARRAY<ROW(name VARCHAR, \"AGE\" VARCHAR)>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"name", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"AGE", (Type)VarcharType.VARCHAR, (boolean)true))))), TestRowOperators.asMap((List)ImmutableList.of((Object)1L), Arrays.asList(Arrays.asList(Arrays.asList("John", "30")))));
        legacyJsonCastDisabled.assertFunction("CAST(json_extract('{\"1\":[{\"name\": \"John\", \"AGE\": 30}]}', '$') AS MAP<bigint, ARRAY<ROW(name VARCHAR, \"age\" VARCHAR)>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"name", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"age", (Type)VarcharType.VARCHAR, (boolean)true))))), TestRowOperators.asMap((List)ImmutableList.of((Object)1L), Arrays.asList(Arrays.asList(Arrays.asList("John", null)))));
        legacyJsonCastDisabled.assertFunction("CAST(json_extract('{\"1\":[{\"name\": \"John\", \"AGE\": 30}]}', '$') AS MAP<bigint, ARRAY<ROW(name VARCHAR, age VARCHAR)>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"name", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"age", (Type)VarcharType.VARCHAR))))), TestRowOperators.asMap((List)ImmutableList.of((Object)1L), Arrays.asList(Arrays.asList(Arrays.asList("John", "30")))));
        legacyJsonCastDisabled.assertFunction("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\": \"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(\"key1\" VARCHAR, \"KEY1\" VARCHAR)>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"key1", (Type)VarcharType.VARCHAR, (boolean)true), (Object)RowType.field((String)"KEY1", (Type)VarcharType.VARCHAR, (boolean)true))))), TestRowOperators.asMap((List)ImmutableList.of((Object)1L), Arrays.asList(Arrays.asList(Arrays.asList("John", "Johnny")))));
        legacyJsonCastDisabled.assertFunction("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\": \"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(key1 VARCHAR, \"KEY1\" VARCHAR)>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"key1", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"KEY1", (Type)VarcharType.VARCHAR, (boolean)true))))), TestRowOperators.asMap((List)ImmutableList.of((Object)1L), Arrays.asList(Arrays.asList(Arrays.asList("John", "Johnny")))));
        this.assertInvalidTypeDefinition("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\": \"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(KEY1 VARCHAR, \"key1\" VARCHAR)>>)", "Duplicate field: key1");
        this.assertInvalidCast("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\":\"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(key1 VARCHAR)>>)", "Cannot cast to map(bigint,array(row(key1 varchar))). Duplicate field: KEY1\n{\"1\":[{\"key1\":\"John\",\"KEY1\":\"Johnny\"}]}");
        canonicalizedJsonExtractDisabled.assertInvalidCast("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\":\"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(key1 VARCHAR)>>)", "Cannot cast to map(bigint,array(row(key1 varchar))). Duplicate field: KEY1\n{\"1\":[{\"key1\":\"John\",\"KEY1\":\"Johnny\"}]}");
        canonicalizedJsonExtractEnabled.assertInvalidCast("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\":\"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(key1 VARCHAR)>>)", "Cannot cast to map(bigint,array(row(key1 varchar))). Duplicate field: key1\n{\"1\":[{\"KEY1\":\"Johnny\",\"key1\":\"John\"}]}");
        this.assertInvalidCast("CAST(unchecked_to_json('{\"a\":1,\"b\":2,\"a\":3}') AS ROW(a BIGINT, b BIGINT))", "Cannot cast to row(a bigint,b bigint). Duplicate field: a\n{\"a\":1,\"b\":2,\"a\":3}");
        this.assertInvalidCast("CAST(unchecked_to_json('[{\"a\":1,\"b\":2,\"a\":3}]') AS ARRAY<ROW(a BIGINT, b BIGINT)>)", "Cannot cast to array(row(a bigint,b bigint)). Duplicate field: a\n[{\"a\":1,\"b\":2,\"a\":3}]");
    }

    @Test
    public void testFieldAccessor() {
        this.assertFunction("CAST(row(1, CAST(NULL AS DOUBLE)) AS ROW(col0 integer, col1 double)).col1", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("CAST(row(TRUE, CAST(NULL AS BOOLEAN)) AS ROW(col0 boolean, col1 boolean)).col1", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("CAST(row(TRUE, CAST(NULL AS ARRAY<INTEGER>)) AS ROW(col0 boolean, col1 array(integer))).col1", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("CAST(row(1.0E0, CAST(NULL AS VARCHAR)) AS ROW(col0 double, col1 varchar)).col1", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("CAST(row(1, 2) AS ROW(col0 integer, col1 integer)).col0", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("CAST(row(1, 'kittens') AS ROW(col0 integer, col1 varchar)).col1", (Type)VarcharType.createUnboundedVarcharType(), "kittens");
        this.assertFunction("CAST(row(1, 2) AS ROW(col0 integer, col1 integer)).\"col1\"", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("CAST(array[row(1, 2)] AS array(row(col0 integer, col1 integer)))[1].col1", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("CAST(row(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) AS ROW(col0 boolean , col1 array(integer), col2 map(integer, double))).col1", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("CAST(row(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) AS ROW(col0 boolean , col1 array(integer), col2 map(integer, double))).col2", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)1, (Object)2.0, (Object)3, (Object)4.0));
        this.assertFunction("CAST(row(1.0E0, ARRAY[row(31, 4.1E0), row(32, 4.2E0)], row(3, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))).col1[2].col0", (Type)IntegerType.INTEGER, 32);
        this.assertFunction("CAST(ROW(1, 2) AS ROW(a BIGINT, b DOUBLE)).a", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CAST(ROW(1, 2) AS ROW(a BIGINT, b DOUBLE)).b", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("CAST(ROW(CAST(ROW('aa') AS ROW(a VARCHAR))) AS ROW(a ROW(a VARCHAR))).a.a", (Type)VarcharType.createUnboundedVarcharType(), "aa");
        this.assertFunction("CAST(ROW(ROW('ab')) AS ROW(a ROW(b VARCHAR))).a.b", (Type)VarcharType.VARCHAR, "ab");
        this.assertFunction("CAST(ROW(ARRAY[NULL]) AS ROW(a ARRAY(BIGINT))).a", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(new Integer[]{null}));
        this.assertFunction("CAST(ROW(1) AS ROW(A BIGINT)).A", (Type)BigintType.BIGINT, 1L);
        this.assertDecimalFunction("CAST(row(1.0, 123123123456.6549876543) AS ROW(col0 decimal(2,1), col1 decimal(22,10))).col0", TestRowOperators.decimal("1.0"));
        this.assertDecimalFunction("CAST(row(1.0, 123123123456.6549876543) AS ROW(col0 decimal(2,1), col1 decimal(22,10))).col1", TestRowOperators.decimal("123123123456.6549876543"));
        legacyRowFieldOrdinalAccess.assertFunction("row(1, CAST(NULL AS DOUBLE)).field1", (Type)DoubleType.DOUBLE, null);
        legacyRowFieldOrdinalAccess.assertFunction("row(TRUE, CAST(NULL AS BOOLEAN)).field1", (Type)BooleanType.BOOLEAN, null);
        legacyRowFieldOrdinalAccess.assertFunction("row(TRUE, CAST(NULL AS ARRAY<INTEGER>)).field1", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        legacyRowFieldOrdinalAccess.assertFunction("row(1.0E0, CAST(NULL AS VARCHAR)).field1", (Type)VarcharType.createUnboundedVarcharType(), null);
        legacyRowFieldOrdinalAccess.assertFunction("row(1, 2).field0", (Type)IntegerType.INTEGER, 1);
        legacyRowFieldOrdinalAccess.assertFunction("row(1, 'kittens').field1", (Type)VarcharType.createVarcharType((int)7), "kittens");
        legacyRowFieldOrdinalAccess.assertFunction("row(1, 2).\"field1\"", (Type)IntegerType.INTEGER, 2);
        legacyRowFieldOrdinalAccess.assertFunction("array[row(1, 2)][1].field1", (Type)IntegerType.INTEGER, 2);
        legacyRowFieldOrdinalAccess.assertFunction("row(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])).field1", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        legacyRowFieldOrdinalAccess.assertFunction("row(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])).field2", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)1, (Object)2.0, (Object)3, (Object)4.0));
        legacyRowFieldOrdinalAccess.assertFunction("row(1.0E0, ARRAY[row(31, 4.1E0), row(32, 4.2E0)], row(3, 4.0E0)).field1[2].field0", (Type)IntegerType.INTEGER, 32);
        legacyRowFieldOrdinalAccess.assertFunction("row(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11).field10", (Type)IntegerType.INTEGER, 11);
        legacyRowFieldOrdinalAccess.assertInvalidFunction("CAST(row(1, 2) as ROW(col0 integer, col1 integer)).field1", SemanticErrorCode.MISSING_ATTRIBUTE);
    }

    @Test
    public void testRowCast() {
        this.assertFunction("cast(row(2, 3) as row(aa bigint, bb bigint)).aa", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("cast(row(2, 3) as row(aa bigint, bb bigint)).bb", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("cast(row(2, 3) as row(aa bigint, bb boolean)).bb", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(row(2, cast(null as double)) as row(aa bigint, bb double)).bb", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("cast(row(2, 'test_str') as row(aa bigint, bb varchar)).bb", (Type)VarcharType.VARCHAR, "test_str");
        this.assertFunction("cast(row(1,null,3) as row(aa bigint, bb boolean, cc boolean)).bb", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("cast(row(1,null,3) as row(aa bigint, bb boolean, cc boolean)).aa", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("cast(row(null,null,null) as row(aa bigint, bb boolean, cc boolean)).aa", (Type)BigintType.BIGINT, null);
        this.assertInvalidTypeDefinition("CAST(ROW(1, 2) AS ROW(a BIGINT, A DOUBLE)).a", "Duplicate field: a");
        this.assertInvalidTypeDefinition("CAST(ROW(1, 2) AS ROW(KEY1 VARCHAR, \"key1\" VARCHAR))", "Duplicate field: key1");
        this.assertInvalidTypeDefinition("TYPEOF(CAST(row(1, 2) AS ROW(KEY1 VARCHAR, \"key1\" VARCHAR)))", "Duplicate field: key1");
        this.assertInvalidTypeDefinition("CAST(ROW(1, 2) AS ROW(KEY1 VARCHAR, \"key1\" VARCHAR)).key1", "Duplicate field: key1");
        String longFieldNameCast = "CAST(row(1.2E0, ARRAY[row(233, 6.9E0)], row(1000, 6.3E0)) AS ROW(%s VARCHAR, %s ARRAY(ROW(%s VARCHAR, %s VARCHAR)), %s ROW(%s VARCHAR, %s VARCHAR))).%s[1].%s";
        int fieldCount = 7;
        char[] chars = new char[9333];
        String[] fields = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            Arrays.fill(chars, (char)(97 + i));
            fields[i] = new String(chars);
        }
        this.assertFunction(String.format(longFieldNameCast, fields[0], fields[1], fields[2], fields[3], fields[4], fields[5], fields[6], fields[1], fields[2]), (Type)VarcharType.VARCHAR, "233");
        this.assertFunction("cast(row(json '2', json '1.5', json 'true', json '\"abc\"', json '[1, 2]') as row(a BIGINT, b DOUBLE, c BOOLEAN, d VARCHAR, e ARRAY(BIGINT)))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"c", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"d", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"e", (Type)new ArrayType((Type)BigintType.BIGINT)))), Arrays.asList(2L, 1.5, true, "abc", ImmutableList.of((Object)1L, (Object)2L)));
        this.assertFunction("MAP(ARRAY['myFirstRow', 'mySecondRow'], ARRAY[cast(row('row1FieldValue1', 'row1FieldValue2') as row(\"firstField\" varchar, \"secondField\" varchar)), cast(row('row2FieldValue1', 'row2FieldValue2') as row(\"firstField\" varchar, \"secondField\" varchar))])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)11), (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"firstField", (Type)VarcharType.VARCHAR, (boolean)true), (Object)RowType.field((String)"secondField", (Type)VarcharType.VARCHAR, (boolean)true)))), ImmutableMap.of((Object)"myFirstRow", Arrays.asList("row1FieldValue1", "row1FieldValue2"), (Object)"mySecondRow", Arrays.asList("row2FieldValue1", "row2FieldValue2")));
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS ROW(UNKNOWN)) IS DISTINCT FROM CAST(NULL AS ROW(UNKNOWN))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(NULL) IS DISTINCT FROM row(NULL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(1, 'cat') IS DISTINCT FROM row(1, 'cat')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(1, ARRAY [1]) IS DISTINCT FROM row(1, ARRAY [1])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(1, ARRAY [1, 2]) IS DISTINCT FROM row(1, ARRAY [1, NULL])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("row(1, 2.0E0, TRUE, 'cat', from_unixtime(1)) IS DISTINCT FROM row(1, 2.0E0, TRUE, 'cat', from_unixtime(1))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(1, 2.0E0, TRUE, 'cat', from_unixtime(1)) IS DISTINCT FROM row(1, 2.0E0, TRUE, 'cat', from_unixtime(2))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("row(1, 2.0E0, TRUE, 'cat', CAST(NULL AS INTEGER)) IS DISTINCT FROM row(1, 2.0E0, TRUE, 'cat', 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("row(1, 2.0E0, TRUE, 'cat', CAST(NULL AS INTEGER)) IS DISTINCT FROM row(1, 2.0E0, TRUE, 'cat', CAST(NULL AS INTEGER))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(1, 2.0E0, TRUE, 'cat') IS DISTINCT FROM row(1, 2.0E0, TRUE, CAST(NULL AS VARCHAR(3)))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("row(1, 2.0E0, TRUE, CAST(NULL AS VARCHAR(3))) IS DISTINCT FROM row(1, 2.0E0, TRUE, CAST(NULL AS VARCHAR(3)))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY[ROW(1)] IS DISTINCT FROM ARRAY[ROW(1)]", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testRowComparison() {
        this.assertFunction("row(TIMESTAMP '2002-01-02 03:04:05.321 +08:10', TIMESTAMP '2002-01-02 03:04:05.321 +08:10') = row(TIMESTAMP '2002-01-02 02:04:05.321 +07:10', TIMESTAMP '2002-01-02 03:05:05.321 +08:11')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("row(1.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10')) = row(1.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:11'))", (Type)BooleanType.BOOLEAN, false);
        this.assertComparisonCombination("row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10')", "row(TIMESTAMP '2002-01-02 03:04:05.321 +07:09', TIMESTAMP '2002-01-02 03:04:05.321 +07:09')");
        this.assertComparisonCombination("row(1.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10'))", "row(2.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10'))");
        this.assertComparisonCombination("row(1.0E0, 'kittens')", "row(1.0E0, 'puppies')");
        this.assertComparisonCombination("row(1, 2.0E0)", "row(5, 2.0E0)");
        this.assertComparisonCombination("row(TRUE, FALSE, TRUE, FALSE)", "row(TRUE, TRUE, TRUE, FALSE)");
        this.assertComparisonCombination("row(1, 2.0E0, TRUE, 'kittens', from_unixtime(1))", "row(1, 3.0E0, TRUE, 'kittens', from_unixtime(1))");
        this.assertInvalidFunction("cast(row(cast(cast ('' as varbinary) as hyperloglog)) as row(col0 hyperloglog)) = cast(row(cast(cast ('' as varbinary) as hyperloglog)) as row(col0 hyperloglog))", SemanticErrorCode.TYPE_MISMATCH, "line 1:81: '=' cannot be applied to row(col0 HyperLogLog), row(col0 HyperLogLog)");
        this.assertInvalidFunction("cast(row(cast(cast ('' as varbinary) as hyperloglog)) as row(col0 hyperloglog)) > cast(row(cast(cast ('' as varbinary) as hyperloglog)) as row(col0 hyperloglog))", SemanticErrorCode.TYPE_MISMATCH, "line 1:81: '>' cannot be applied to row(col0 HyperLogLog), row(col0 HyperLogLog)");
        this.assertInvalidFunction("cast(row(cast(cast ('' as varbinary) as qdigest(double))) as row(col0 qdigest(double))) = cast(row(cast(cast ('' as varbinary) as qdigest(double))) as row(col0 qdigest(double)))", SemanticErrorCode.TYPE_MISMATCH, "line 1:89: '=' cannot be applied to row(col0 qdigest(double)), row(col0 qdigest(double))");
        this.assertInvalidFunction("cast(row(cast(cast ('' as varbinary) as qdigest(double))) as row(col0 qdigest(double))) > cast(row(cast(cast ('' as varbinary) as qdigest(double))) as row(col0 qdigest(double)))", SemanticErrorCode.TYPE_MISMATCH, "line 1:89: '>' cannot be applied to row(col0 qdigest(double)), row(col0 qdigest(double))");
        this.assertFunction("row(TRUE, ARRAY [1], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) = row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) = row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("row(1, CAST(NULL AS INTEGER)) = row(1, 2)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("row(1, CAST(NULL AS INTEGER)) != row(1, 2)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("row(2, CAST(NULL AS INTEGER)) = row(1, 2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("row(2, CAST(NULL AS INTEGER)) != row(1, 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertInvalidFunction("row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) > row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))", SemanticErrorCode.TYPE_MISMATCH, "line 1:64: '>' cannot be applied to row(boolean,array(integer),map(integer,double)), row(boolean,array(integer),map(integer,double))");
        this.assertInvalidFunction("row(1, CAST(NULL AS INTEGER)) < row(1, 2)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertComparisonCombination("row(1.0E0, ARRAY [1,2,3], row(2, 2.0E0))", "row(1.0E0, ARRAY [1,3,3], row(2, 2.0E0))");
        this.assertComparisonCombination("row(TRUE, ARRAY [1])", "row(TRUE, ARRAY [1, 2])");
        this.assertComparisonCombination("ROW(1, 2)", "ROW(2, 1)");
        this.assertFunction("ROW(1, 2) = ROW(1, 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ROW(2, 1) != ROW(1, 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ROW(1.0, 123123123456.6549876543) = ROW(1.0, 123123123456.6549876543)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ROW(1.0, 123123123456.6549876543) = ROW(1.0, 123123123456.6549876542)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ROW(1.0, 123123123456.6549876543) != ROW(1.0, 123123123456.6549876543)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ROW(1.0, 123123123456.6549876543) != ROW(1.0, 123123123456.6549876542)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testRowHashOperator() {
        this.assertRowHashOperator("ROW(1, 2)", (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER), (List<Object>)ImmutableList.of((Object)1, (Object)2));
        this.assertRowHashOperator("ROW(true, 2)", (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)IntegerType.INTEGER), (List<Object>)ImmutableList.of((Object)true, (Object)2));
    }

    @Test
    public void testRowNestedNullVarchar() {
        this.assertFunction("CAST(ROW(JSON_EXTRACT('{\"decision_data\":{\"result\":null}}', '$.decision_data.result')) AS ROW(decision_string VARCHAR))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"decision_string", (Type)VarcharType.VARCHAR))), Arrays.asList(new String[]{null}));
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as row(col0 bigint))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(1)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(null)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(1,2)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(1,null)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(null,2)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(null,null)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row('111',null)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(null,'222')", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row('111','222')", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1), row(2), row(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1), row(null), row(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1), row(cast(null as bigint)), row(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(row(1)), row(2), row(3))", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(row(null)), row(2), row(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(row(cast(null as boolean))), row(2), row(3))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[3,4,5]))", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(3,4)]))", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(null,2),row(array[row(3,4)]))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1,null),row(array[row(3,4)]))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[cast(row(3,4) as row(a integer, b integer)), cast(null as row(a integer, b integer))]))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(null,4)]))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(map(array[8], array[9]),4)]))", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(map(array[8], array[null]),4)]))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(1E0,2E0)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(1E0,null)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "row(true,false)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "row(true,null)", (Type)BooleanType.BOOLEAN, true);
    }

    private void assertRowHashOperator(String inputString, List<Type> types, List<Object> elements) {
        Preconditions.checkArgument((types.size() == elements.size() ? 1 : 0) != 0, (Object)"types and elements must have the same size");
        RowType rowType = RowType.anonymous(types);
        BlockBuilder blockBuilder = rowType.createBlockBuilder(null, 1);
        BlockBuilder singleRowBlockWriter = blockBuilder.beginBlockEntry();
        for (int i = 0; i < types.size(); ++i) {
            StructuralTestUtil.appendToBlockBuilder(types.get(i), elements.get(i), singleRowBlockWriter);
        }
        blockBuilder.closeEntry();
        this.assertOperator(OperatorType.HASH_CODE, inputString, (Type)BigintType.BIGINT, rowType.hash(blockBuilder.build(), 0));
    }

    private void assertComparisonCombination(String base, String greater) {
        HashSet equalOperators = new HashSet(ImmutableSet.of((Object)"=", (Object)">=", (Object)"<="));
        HashSet greaterOrInequalityOperators = new HashSet(ImmutableSet.of((Object)">=", (Object)">", (Object)"!="));
        HashSet lessOrInequalityOperators = new HashSet(ImmutableSet.of((Object)"<=", (Object)"<", (Object)"!="));
        for (String operator : ImmutableList.of((Object)">", (Object)"=", (Object)"<", (Object)">=", (Object)"<=", (Object)"!=")) {
            this.assertFunction(base + operator + base, (Type)BooleanType.BOOLEAN, equalOperators.contains(operator));
            this.assertFunction(base + operator + greater, (Type)BooleanType.BOOLEAN, lessOrInequalityOperators.contains(operator));
            this.assertFunction(greater + operator + base, (Type)BooleanType.BOOLEAN, greaterOrInequalityOperators.contains(operator));
        }
    }

    @Test
    public void testRowNestedJsonExtractNullVarchar() {
        this.assertInvalidCast("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\":\"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(key1 VARCHAR)>>)", "Cannot cast to map(bigint,array(row(key1 varchar))). Duplicate field: KEY1\n{\"1\":[{\"key1\":\"John\",\"KEY1\":\"Johnny\"}]}");
        canonicalizedJsonExtractDisabled.assertInvalidCast("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\":\"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(key1 VARCHAR)>>)", "Cannot cast to map(bigint,array(row(key1 varchar))). Duplicate field: KEY1\n{\"1\":[{\"key1\":\"John\",\"KEY1\":\"Johnny\"}]}");
        canonicalizedJsonExtractEnabled.assertInvalidCast("CAST(json_extract('{\"1\":[{\"key1\": \"John\", \"KEY1\":\"Johnny\"}]}', '$') AS MAP<bigint, ARRAY<ROW(key1 VARCHAR)>>)", "Cannot cast to map(bigint,array(row(key1 varchar))). Duplicate field: key1\n{\"1\":[{\"KEY1\":\"Johnny\",\"key1\":\"John\"}]}");
    }
}

