/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UuidType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.type.UuidOperators;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.annotations.Test;

public class TestUuidOperators
extends AbstractTestFunctions {
    @Test
    public void testRandomUuid() {
        this.tryEvaluateWithAll("uuid()", (Type)UuidType.UUID);
    }

    @Test
    public void testVarcharToUUIDCast() {
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)UuidType.UUID, "00000000-0000-0000-0000-000000000000");
        this.assertFunction("CAST('12151fd2-7586-11e9-8f9e-2a86e4085a59' AS UUID)", (Type)UuidType.UUID, "12151fd2-7586-11e9-8f9e-2a86e4085a59");
        this.assertFunction("CAST('300433ad-b0a1-3b53-a977-91cab582458e' AS UUID)", (Type)UuidType.UUID, "300433ad-b0a1-3b53-a977-91cab582458e");
        this.assertFunction("CAST('d3074e99-de12-4b8c-a2a1-b7faf79faba6' AS UUID)", (Type)UuidType.UUID, "d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        this.assertFunction("CAST('dfa7eaf8-6a26-5749-8d36-336025df74e8' AS UUID)", (Type)UuidType.UUID, "dfa7eaf8-6a26-5749-8d36-336025df74e8");
        this.assertFunction("CAST('12151FD2-7586-11E9-8F9E-2A86E4085A59' AS UUID)", (Type)UuidType.UUID, "12151fd2-7586-11e9-8f9e-2a86e4085a59");
        this.assertInvalidCast("CAST('1-2-3-4-1' AS UUID)", "Invalid UUID string length: 9");
        this.assertInvalidCast("CAST('12151fd217586211e938f9e42a86e4085a59' AS UUID)", "Cannot cast value to UUID: 12151fd217586211e938f9e42a86e4085a59");
    }

    @Test
    public void testUUIDToVarcharCast() {
        this.assertFunction("CAST(UUID 'd3074e99-de12-4b8c-a2a1-b7faf79faba6' AS VARCHAR)", (Type)VarcharType.VARCHAR, "d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        this.assertFunction("CAST(CAST('d3074e99-de12-4b8c-a2a1-b7faf79faba6' AS UUID) AS VARCHAR)", (Type)VarcharType.VARCHAR, "d3074e99-de12-4b8c-a2a1-b7faf79faba6");
    }

    @Test
    public void testVarbinaryToUUIDCast() {
        this.assertFunction("CAST(x'00000000000000000000000000000000' AS UUID)", (Type)UuidType.UUID, "00000000-0000-0000-0000-000000000000");
        this.assertFunction("CAST(x'E9118675D21F1512595A08E4862A9E8F' AS UUID)", (Type)UuidType.UUID, "e9118675-d21f-1512-595a-08e4862a9e8f");
        this.assertFunction("CAST(x'533BA1B0AD3304308E4582B5CA9177A9' AS UUID)", (Type)UuidType.UUID, "533ba1b0-ad33-0430-8e45-82b5ca9177a9");
        this.assertFunction("CAST(x'8C4B12DE994E07D3A6AB9FF7FAB7A1A2' AS UUID)", (Type)UuidType.UUID, "8c4b12de-994e-07d3-a6ab-9ff7fab7a1a2");
        this.assertFunction("CAST(x'4957266AF8EAA7DFE874DF256033368D' AS UUID)", (Type)UuidType.UUID, "4957266a-f8ea-a7df-e874-df256033368d");
        this.assertFunction("CAST(x'e9118675d21f1512595a08e4862a9e8f' AS UUID)", (Type)UuidType.UUID, "e9118675-d21f-1512-595a-08e4862a9e8f");
        this.assertInvalidCast("CAST(x'f000001100' AS UUID)", "Invalid UUID binary length: 5");
    }

    @Test
    public void testUUIDToVarbinaryCast() {
        this.assertFunction("CAST(UUID '00000000-0000-0000-0000-000000000000' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, new SqlVarbinary(BaseEncoding.base16().decode((CharSequence)"00000000000000000000000000000000")));
        this.assertFunction("CAST(UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, new SqlVarbinary(BaseEncoding.base16().decode((CharSequence)"6B5F5B6567E443B08EE3586CD49F58A0")));
    }

    @Test
    public void testEquals() {
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' = UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID) = CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' IS DISTINCT FROM UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(NULL AS UUID) IS DISTINCT FROM CAST(NULL AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' IS DISTINCT FROM UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a1'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' IS DISTINCT FROM CAST(NULL AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(NULL AS UUID) IS DISTINCT FROM UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEquals() {
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' != UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('12151fd2-7586-11e9-8f9e-2a86e4085a59' AS UUID) != UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testOrderOperators() {
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) < CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) < CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) < CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-ff00-000000000001' AS UUID) < CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) < CAST('00000000-0000-0000-ff00-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) < CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) < CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('ff000000-0000-0001-0000-000000000000' AS UUID) < CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) < CAST('ff000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) < CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) < CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('ff000000-0000-0000-0000-000000000001' AS UUID) < CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) < CAST('ff000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) <= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) <= CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) <= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-ff00-000000000001' AS UUID) <= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) <= CAST('00000000-0000-0000-ff00-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) <= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) <= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('ff000000-0000-0001-0000-000000000000' AS UUID) <= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) <= CAST('ff000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) <= CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) <= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('ff000000-0000-0000-0000-000000000001' AS UUID) <= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) <= CAST('ff000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) > CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) > CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) > CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-ff00-000000000001' AS UUID) > CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) > CAST('00000000-0000-0000-ff00-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) > CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) > CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('ff000000-0000-0001-0000-000000000000' AS UUID) > CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) > CAST('ff000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) > CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) > CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('ff000000-0000-0000-0000-000000000001' AS UUID) > CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) > CAST('ff000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) >= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) >= CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) >= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-ff00-000000000001' AS UUID) >= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) >= CAST('00000000-0000-0000-ff00-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) >= CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID) >= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('ff000000-0000-0001-0000-000000000000' AS UUID) >= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) >= CAST('ff000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('00000000-0000-0001-0000-000000000000' AS UUID) >= CAST('00000000-0000-0000-0000-000000000001' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) >= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('ff000000-0000-0000-0000-000000000001' AS UUID) >= CAST('00000000-0000-0001-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000001' AS UUID) >= CAST('ff000000-0000-0000-0000-000000000000' AS UUID)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "CAST(null AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testHash() {
        this.assertOperator(OperatorType.HASH_CODE, "CAST(null AS UUID)", (Type)BigintType.BIGINT, null);
        this.assertOperator(OperatorType.HASH_CODE, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BigintType.BIGINT, TestUuidOperators.hashFromType("12151fd2-7586-11e9-8f9e-2a86e4085a59"));
    }

    private static long hashFromType(String uuidString) {
        BlockBuilder blockBuilder = UuidType.UUID.createBlockBuilder(null, 1);
        UuidType.UUID.writeSlice(blockBuilder, UuidOperators.castFromVarcharToUuid((Slice)Slices.utf8Slice((String)uuidString)));
        Block block = blockBuilder.build();
        return UuidType.UUID.hash(block, 0);
    }
}

