/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import io.airlift.slice.Slice;
import io.airlift.slice.testing.SliceAssertions;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.LongStream;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestKHyperLogLog {
    @Test
    public void testCardinality() throws Exception {
        int trials = 1000;
        for (int indexBits = 4; indexBits <= 12; ++indexBits) {
            HashMap<Integer, StandardDeviation> errors = new HashMap<Integer, StandardDeviation>();
            int numberOfBuckets = 1 << indexBits;
            int maxCardinality = numberOfBuckets * 2;
            for (int trial = 0; trial < trials; ++trial) {
                KHyperLogLog khll = new KHyperLogLog();
                for (int cardinality = 1; cardinality <= maxCardinality; ++cardinality) {
                    khll.add(ThreadLocalRandom.current().nextLong(), 0L);
                    if (cardinality % (numberOfBuckets / 10) != 0) continue;
                    double error = (double)(khll.cardinality() - (long)cardinality) * 1.0 / (double)cardinality;
                    StandardDeviation stdev = errors.computeIfAbsent(cardinality, k -> new StandardDeviation());
                    stdev.increment(error);
                }
            }
            double expectedStandardError = 1.04 / Math.sqrt(1 << indexBits);
            for (Map.Entry entry : errors.entrySet()) {
                double realStandardError = ((StandardDeviation)entry.getValue()).getResult();
                Assert.assertTrue((realStandardError <= expectedStandardError * 1.1 ? 1 : 0) != 0, (String)String.format("Failed at p = %s, cardinality = %s. Expected std error = %s, actual = %s", indexBits, entry.getKey(), expectedStandardError, realStandardError));
            }
        }
    }

    @Test
    public void testMerge() throws Exception {
        this.verifyMerge(LongStream.rangeClosed(0L, 100L), LongStream.rangeClosed(50L, 150L));
        this.verifyMerge(LongStream.rangeClosed(0L, 100L), LongStream.rangeClosed(50L, 5000L));
        this.verifyMerge(LongStream.rangeClosed(50L, 5000L), LongStream.rangeClosed(0L, 100L));
        this.verifyMerge(LongStream.rangeClosed(0L, 5000L), LongStream.rangeClosed(3000L, 8000L));
    }

    private void verifyMerge(LongStream one, LongStream two) {
        long uii;
        KHyperLogLog khll1 = new KHyperLogLog();
        KHyperLogLog khll2 = new KHyperLogLog();
        KHyperLogLog expected = new KHyperLogLog();
        for (long value : one.toArray()) {
            uii = this.randomLong(100);
            khll1.add(value, uii);
            expected.add(value, uii);
        }
        for (long value : two.toArray()) {
            uii = this.randomLong(100);
            khll2.add(value, uii);
            expected.add(value, uii);
        }
        KHyperLogLog merged = khll1.mergeWith(khll2);
        Assert.assertEquals((long)merged.cardinality(), (long)expected.cardinality());
        Assert.assertEquals((double)merged.reidentificationPotential(10L), (double)expected.reidentificationPotential(10L));
        SliceAssertions.assertSlicesEqual((Slice)khll1.serialize(), (Slice)expected.serialize());
    }

    @Test
    public void testSerialization() throws Exception {
        this.verifySerialization(LongStream.rangeClosed(0L, 1000L));
        this.verifySerialization(LongStream.rangeClosed(0L, 200000L));
    }

    private void verifySerialization(LongStream sequence) {
        KHyperLogLog khll = new KHyperLogLog();
        long[] lArray = sequence.toArray();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long value = lArray[i];
            khll.add(value.longValue(), (long)(Math.random() * 100.0));
        }
        Slice serialized = khll.serialize();
        KHyperLogLog deserialized = KHyperLogLog.newInstance((Slice)serialized);
        Assert.assertEquals((long)khll.cardinality(), (long)deserialized.cardinality());
        Assert.assertEquals((double)khll.reidentificationPotential(10L), (double)deserialized.reidentificationPotential(10L));
        Slice reserialized = deserialized.serialize();
        SliceAssertions.assertSlicesEqual((Slice)serialized, (Slice)reserialized);
    }

    @Test
    public void testHistogram() throws Exception {
        this.buildHistogramAndVerify(256, 1000);
        this.buildHistogramAndVerify(256, 200000);
    }

    public void buildHistogramAndVerify(int histogramSize, int count) {
        KHyperLogLog khll = new KHyperLogLog();
        HashMap<Long, HashSet<Long>> map = new HashMap<Long, HashSet<Long>>();
        for (int i = 0; i < count; ++i) {
            long uii = this.randomLong(histogramSize);
            long value = this.randomLong(count);
            khll.add(value, uii);
            map.computeIfAbsent(value, k -> new HashSet()).add(uii);
        }
        int size = map.size();
        HashMap<Long, Double> realHistogram = new HashMap<Long, Double>();
        for (HashSet uiis : map.values()) {
            long bucket = Math.min(uiis.size(), histogramSize);
            realHistogram.merge(bucket, 1.0 / (double)size, Double::sum);
        }
        Long2DoubleMap khllHistogram = khll.uniquenessDistribution((long)histogramSize);
        this.verifyUniquenessDistribution(realHistogram, (Map<Long, Double>)khllHistogram);
        this.verifyReidentificationPotential(map, khll);
    }

    public void verifyUniquenessDistribution(Map<Long, Double> realHistogram, Map<Long, Double> khllHistogram) {
        double estimated = 0.0;
        double real = 0.0;
        int histogramSize = realHistogram.size();
        for (long i = 1L; i < (long)histogramSize; ++i) {
            Assert.assertTrue((Math.abs((estimated += khllHistogram.get(i).doubleValue()) - (real += realHistogram.getOrDefault(i, 0.0).doubleValue())) <= 0.1 * real ? 1 : 0) != 0, (String)String.format("Expected histogram value %f +/- 10%%, got %f, for bucket %d", real, estimated, i));
        }
    }

    public void verifyReidentificationPotential(Map<Long, HashSet<Long>> map, KHyperLogLog khll) {
        int size = map.size();
        for (int threshold = 1; threshold < 10; ++threshold) {
            double estimated = khll.reidentificationPotential((long)threshold);
            double real = 0.0;
            for (HashSet<Long> uiis : map.values()) {
                if (uiis.size() > threshold) continue;
                real += 1.0;
            }
            Assert.assertTrue((Math.abs(estimated - (real /= (double)size)) <= 0.1 * real ? 1 : 0) != 0, (String)String.format("Expected reidentification potential %f +/- 10%%, got %f, for set of size %d", real, estimated, size));
        }
    }

    private long randomLong(int range) {
        return (long)(Math.pow(Math.random(), 2.0) * (double)range);
    }
}

