/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.testing.TestingEnvironment;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.util.GraphvizPrinter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGraphvizPrinter {
    private static final ConnectorId TEST_CONNECTOR_ID = new ConnectorId("connector_id");
    private static final PlanNodeId TEST_TABLE_SCAN_NODE_ID = new PlanNodeId("plan_id");
    private static final ConnectorTableHandle TEST_CONNECTOR_TABLE_HANDLE = new TestingMetadata.TestingTableHandle();
    private static final PlanNode TEST_TABLE_SCAN_NODE = new TableScanNode(Optional.empty(), TEST_TABLE_SCAN_NODE_ID, new TableHandle(TEST_CONNECTOR_ID, TEST_CONNECTOR_TABLE_HANDLE, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List)ImmutableList.of(), (Map)ImmutableMap.of(), TupleDomain.all(), TupleDomain.all(), Optional.empty());
    private static final String TEST_TABLE_SCAN_NODE_INNER_OUTPUT = String.format("label=\"{TableScan | [TableHandle \\{connectorId='%s', connectorHandle='%s', layout='Optional.empty'\\}]|Estimates: \\{rows: ? (0B), cpu: ?, memory: ?, network: ?\\}\n}\", style=\"rounded, filled\", shape=record, fillcolor=deepskyblue", TEST_CONNECTOR_ID, TEST_CONNECTOR_TABLE_HANDLE);

    @Test
    public void testPrintLogical() {
        String actual = GraphvizPrinter.printLogical((List)ImmutableList.of((Object)TestGraphvizPrinter.createTestPlanFragment(0, TEST_TABLE_SCAN_NODE)), (FunctionAndTypeManager)TestingEnvironment.FUNCTION_AND_TYPE_MANAGER, (Session)TestingSession.testSessionBuilder().build());
        String expected = String.join((CharSequence)System.lineSeparator(), "digraph logical_plan {", "subgraph cluster_0 {", "label = \"SOURCE\"", String.format("plannode_1[%s];", TEST_TABLE_SCAN_NODE_INNER_OUTPUT), "}", "}", "");
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test
    public void testPrintDistributed() {
        SubPlan tableScanNodeSubPlan = new SubPlan(TestGraphvizPrinter.createTestPlanFragment(0, TEST_TABLE_SCAN_NODE), (List)ImmutableList.of());
        SubPlan nestedSubPlan = new SubPlan(TestGraphvizPrinter.createTestPlanFragment(1, TEST_TABLE_SCAN_NODE), (List)ImmutableList.of((Object)tableScanNodeSubPlan));
        String actualNestedSubPlan = GraphvizPrinter.printDistributed((SubPlan)nestedSubPlan, (FunctionAndTypeManager)TestingEnvironment.FUNCTION_AND_TYPE_MANAGER, (Session)TestingSession.testSessionBuilder().build());
        String expectedNestedSubPlan = String.join((CharSequence)System.lineSeparator(), "digraph distributed_plan {", "subgraph cluster_1 {", "label = \"SOURCE\"", String.format("plannode_1[%s];", TEST_TABLE_SCAN_NODE_INNER_OUTPUT), "}", "subgraph cluster_0 {", "label = \"SOURCE\"", String.format("plannode_1[%s];", TEST_TABLE_SCAN_NODE_INNER_OUTPUT), "}", "}", "");
        Assert.assertEquals((String)actualNestedSubPlan, (String)expectedNestedSubPlan);
    }

    @Test
    public void testPrintDistributedFromFragments() {
        ArrayList<PlanFragment> allFragments = new ArrayList<PlanFragment>();
        allFragments.add(TestGraphvizPrinter.createTestPlanFragment(0, TEST_TABLE_SCAN_NODE));
        allFragments.add(TestGraphvizPrinter.createTestPlanFragment(1, TEST_TABLE_SCAN_NODE));
        String actual = GraphvizPrinter.printDistributedFromFragments(allFragments, (FunctionAndTypeManager)TestingEnvironment.FUNCTION_AND_TYPE_MANAGER, (Session)TestingSession.testSessionBuilder().build());
        String expected = "digraph distributed_plan {\nsubgraph cluster_0 {\nlabel = \"SOURCE\"\nplannode_1[label=\"{TableScan | [TableHandle \\{connectorId='connector_id', connectorHandle='com.facebook.presto.testing.TestingMetadata$TestingTableHandle@1af56f7', layout='Optional.empty'\\}]|Estimates: \\{rows: ? (0B), cpu: ?, memory: ?, network: ?\\}\n}\", style=\"rounded, filled\", shape=record, fillcolor=deepskyblue];\n}\nsubgraph cluster_1 {\nlabel = \"SOURCE\"\nplannode_1[label=\"{TableScan | [TableHandle \\{connectorId='connector_id', connectorHandle='com.facebook.presto.testing.TestingMetadata$TestingTableHandle@1af56f7', layout='Optional.empty'\\}]|Estimates: \\{rows: ? (0B), cpu: ?, memory: ?, network: ?\\}\n}\", style=\"rounded, filled\", shape=record, fillcolor=deepskyblue];\n}\n}\n";
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test
    public void testPrintLogicalForJoinNode() {
        ValuesNode valuesNode = new ValuesNode(Optional.empty(), new PlanNodeId("right"), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        JoinNode node = new JoinNode(Optional.empty(), new PlanNodeId("join"), JoinType.INNER, TEST_TABLE_SCAN_NODE, (PlanNode)valuesNode, Collections.emptyList(), (List)ImmutableList.builder().addAll((Iterable)TEST_TABLE_SCAN_NODE.getOutputVariables()).addAll((Iterable)valuesNode.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), (Map)ImmutableMap.of());
        String actual = GraphvizPrinter.printLogical((List)ImmutableList.of((Object)TestGraphvizPrinter.createTestPlanFragment(0, (PlanNode)node)), (FunctionAndTypeManager)TestingEnvironment.FUNCTION_AND_TYPE_MANAGER, (Session)TestingSession.testSessionBuilder().build());
        String expected = "digraph logical_plan {\nsubgraph cluster_0 {\nlabel = \"SOURCE\"\nplannode_1[label=\"{CrossJoin[REPLICATED]|Estimates: \\{rows: ? (0B), cpu: ?, memory: ?, network: ?\\}\n}\", style=\"rounded, filled\", shape=record, fillcolor=orange];\nplannode_2[label=\"{TableScan | [TableHandle \\{connectorId='connector_id', connectorHandle='com.facebook.presto.testing.TestingMetadata$TestingTableHandle@1af56f7', layout='Optional.empty'\\}]|Estimates: \\{rows: ? (0B), cpu: ?, memory: ?, network: ?\\}\n}\", style=\"rounded, filled\", shape=record, fillcolor=deepskyblue];\nplannode_3[label=\"{Values|Estimates: \\{rows: ? (0B), cpu: ?, memory: ?, network: ?\\}\n}\", style=\"rounded, filled\", shape=record, fillcolor=deepskyblue];\n}\nplannode_1 -> plannode_3 [label = \"Build\"];\nplannode_1 -> plannode_2 [label = \"Probe\"];\n}\n";
        Assert.assertEquals((String)actual, (String)expected);
    }

    private static PlanFragment createTestPlanFragment(int id, PlanNode node) {
        return new PlanFragment(new PlanFragmentId(id), node, (Set)ImmutableSet.of(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)TEST_TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of()), StageExecutionDescriptor.ungroupedExecution(), false, Optional.of(StatsAndCosts.empty()), Optional.empty());
    }
}

