/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.SimplePageWithPositionComparator;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.util.MergeSortedPages;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeSortedPages {
    @Test
    public void testSingleStream() throws Exception {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER);
        MaterializedResult actual = TestMergeSortedPages.mergeSortedPages((List<Type>)types, (List<Integer>)ImmutableList.of((Object)0, (Object)1), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.DESC_NULLS_FIRST), (List<List<Page>>)ImmutableList.of(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1, 4).row(2, 3).pageBreak().row(3, 2).row(4, 1).build()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Iterable)types).row(new Object[]{1, 4}).row(new Object[]{2, 3}).row(new Object[]{3, 2}).row(new Object[]{4, 1}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testSimpleTwoStreams() throws Exception {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER);
        MaterializedResult actual = TestMergeSortedPages.mergeSortedPages((List<Type>)types, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST), (List<List<Page>>)ImmutableList.of(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1).row(3).pageBreak().row(5).row(7).build(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2).row(4).pageBreak().row(6).row(8).build()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Iterable)types).row(new Object[]{1}).row(new Object[]{2}).row(new Object[]{3}).row(new Object[]{4}).row(new Object[]{5}).row(new Object[]{6}).row(new Object[]{7}).row(new Object[]{8}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testMultipleStreams() throws Exception {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER);
        MaterializedResult actual = TestMergeSortedPages.mergeSortedPages((List<Type>)types, (List<Integer>)ImmutableList.of((Object)0, (Object)1), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.DESC_NULLS_FIRST), (List<List<Page>>)ImmutableList.of(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1, 1, 2).pageBreak().pageBreak().row(8, 1, 1).row(19, 1, 3).row(27, 1, 4).row(41, 2, 5).pageBreak().row(55, 1, 2).row(89, 1, 3).row(100, 2, 6).row(100, 2, 8).row(101, 1, 4).row(202, 1, 3).row(399, 2, 2).pageBreak().row(400, 1, 1).row(401, 1, 7).pageBreak().row(402, 1, 6).build(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).pageBreak().row(2, 1, 2).row(8, 1, 1).row(19, 1, 3).row(25, 1, 4).row(26, 2, 5).pageBreak().row(56, 1, 2).row(66, 1, 3).row(77, 1, 4).row(88, 1, 3).row(99, 1, 1).pageBreak().row(99, 2, 2).row(100, 1, 7).build(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(8, 1, 1).row(88, 1, 3).pageBreak().row(89, 1, 3).pageBreak().row(90, 1, 3).pageBreak().row(91, 1, 4).row(92, 2, 5).pageBreak().row(93, 1, 2).row(94, 1, 3).row(95, 1, 4).row(97, 1, 3).row(98, 2, 2).row(100, 1, 7).build()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Iterable)types).row(new Object[]{1, 1, 2}).row(new Object[]{2, 1, 2}).row(new Object[]{8, 1, 1}).row(new Object[]{8, 1, 1}).row(new Object[]{8, 1, 1}).row(new Object[]{19, 1, 3}).row(new Object[]{19, 1, 3}).row(new Object[]{25, 1, 4}).row(new Object[]{26, 2, 5}).row(new Object[]{27, 1, 4}).row(new Object[]{41, 2, 5}).row(new Object[]{55, 1, 2}).row(new Object[]{56, 1, 2}).row(new Object[]{66, 1, 3}).row(new Object[]{77, 1, 4}).row(new Object[]{88, 1, 3}).row(new Object[]{88, 1, 3}).row(new Object[]{89, 1, 3}).row(new Object[]{89, 1, 3}).row(new Object[]{90, 1, 3}).row(new Object[]{91, 1, 4}).row(new Object[]{92, 2, 5}).row(new Object[]{93, 1, 2}).row(new Object[]{94, 1, 3}).row(new Object[]{95, 1, 4}).row(new Object[]{97, 1, 3}).row(new Object[]{98, 2, 2}).row(new Object[]{99, 1, 1}).row(new Object[]{99, 2, 2}).row(new Object[]{100, 2, 6}).row(new Object[]{100, 2, 8}).row(new Object[]{100, 1, 7}).row(new Object[]{100, 1, 7}).row(new Object[]{101, 1, 4}).row(new Object[]{202, 1, 3}).row(new Object[]{399, 2, 2}).row(new Object[]{400, 1, 1}).row(new Object[]{401, 1, 7}).row(new Object[]{402, 1, 6}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testEmptyStreams() throws Exception {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        MaterializedResult actual = TestMergeSortedPages.mergeSortedPages((List<Type>)types, (List<Integer>)ImmutableList.of((Object)0, (Object)1), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST), (List<List<Page>>)ImmutableList.of(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).pageBreak().pageBreak().build(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).pageBreak().build(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).pageBreak().build(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).build()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Iterable)types).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testDifferentTypes() throws Exception {
        ImmutableList types = ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER);
        MaterializedResult actual = TestMergeSortedPages.mergeSortedPages((List<Type>)types, (List<Integer>)ImmutableList.of((Object)2, (Object)0, (Object)1), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.DESC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST), (List<List<Page>>)ImmutableList.of(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(16.0, "a1", 16).row(8.0, "b1", 16).pageBreak().row(4.0, "c1", 16).row(4.0, "d1", 16).row(null, "d1", 8).row(16.0, "a1", 8).row(16.0, "b1", 8).row(16.0, "c1", 4).row(8.0, "d1", 4).row(16.0, "a1", 2).row(null, "a1", null).row(16.0, "a1", null).build(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(15.0, "a2", 17).row(9.0, "b2", 17).pageBreak().row(5.0, "c2", 17).row(5.0, "d2", 17).row(null, "d2", 8).row(17.0, "a0", 8).row(17.0, "b0", 8).row(17.0, "c0", 5).row(9.0, "d0", 5).row(17.0, "a0", 3).row(null, "a0", null).row(17.0, "a0", null).build()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Iterable)types).row(new Object[]{15.0, "a2", 17}).row(new Object[]{9.0, "b2", 17}).row(new Object[]{5.0, "c2", 17}).row(new Object[]{5.0, "d2", 17}).row(new Object[]{16.0, "a1", 16}).row(new Object[]{8.0, "b1", 16}).row(new Object[]{4.0, "c1", 16}).row(new Object[]{4.0, "d1", 16}).row(new Object[]{null, "d1", 8}).row(new Object[]{null, "d2", 8}).row(new Object[]{17.0, "a0", 8}).row(new Object[]{17.0, "b0", 8}).row(new Object[]{16.0, "a1", 8}).row(new Object[]{16.0, "b1", 8}).row(new Object[]{17.0, "c0", 5}).row(new Object[]{9.0, "d0", 5}).row(new Object[]{16.0, "c1", 4}).row(new Object[]{8.0, "d1", 4}).row(new Object[]{17.0, "a0", 3}).row(new Object[]{16.0, "a1", 2}).row(new Object[]{null, "a0", null}).row(new Object[]{null, "a1", null}).row(new Object[]{17.0, "a0", null}).row(new Object[]{16.0, "a1", null}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testSortingYields() throws Exception {
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        yieldSignal.forceYieldForTesting();
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER);
        WorkProcessor mergedPages = MergeSortedPages.mergeSortedPages((List)ImmutableList.of((Object)WorkProcessor.fromIterable(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1).build())), (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST)), (List)ImmutableList.of((Object)0), (List)types, (pageBuilder, pageWithPosition) -> pageBuilder.isFull(), (boolean)false, (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newAggregatedMemoryContext(), (DriverYieldSignal)yieldSignal);
        org.testng.Assert.assertFalse((boolean)mergedPages.process());
        yieldSignal.resetYieldForTesting();
        org.testng.Assert.assertTrue((boolean)mergedPages.process());
        org.testng.Assert.assertFalse((boolean)mergedPages.isFinished());
        Page page = (Page)mergedPages.getResult();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Iterable)types).row(new Object[]{1}).build();
        Assert.assertEquals((Iterable)OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, (List<Page>)ImmutableList.of((Object)page)), (Iterable)expected);
        org.testng.Assert.assertTrue((boolean)mergedPages.process());
        org.testng.Assert.assertTrue((boolean)mergedPages.isFinished());
    }

    @Test
    public void testMergeSortYieldingProgresses() throws Exception {
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        yieldSignal.forceYieldForTesting();
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER);
        WorkProcessor mergedPages = MergeSortedPages.mergeSortedPages((List)ImmutableList.of((Object)WorkProcessor.fromIterable(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).build())), (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST)), (List)ImmutableList.of((Object)0), (List)types, (pageBuilder, pageWithPosition) -> pageBuilder.isFull(), (boolean)false, (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newAggregatedMemoryContext(), (DriverYieldSignal)yieldSignal);
        org.testng.Assert.assertFalse((boolean)mergedPages.process());
        org.testng.Assert.assertTrue((boolean)mergedPages.process());
        org.testng.Assert.assertTrue((boolean)mergedPages.isFinished());
    }

    private static MaterializedResult mergeSortedPages(List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrder, List<List<Page>> sortedPages) throws Exception {
        List pageProducers = (List)sortedPages.stream().map(WorkProcessor::fromIterable).collect(ImmutableList.toImmutableList());
        SimplePageWithPositionComparator comparator = new SimplePageWithPositionComparator(types, sortChannels, sortOrder);
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newAggregatedMemoryContext();
        WorkProcessor mergedPages = MergeSortedPages.mergeSortedPages((List)pageProducers, (PageWithPositionComparator)comparator, types, (AggregatedMemoryContext)memoryContext, (DriverYieldSignal)new DriverYieldSignal());
        org.testng.Assert.assertTrue((boolean)mergedPages.process());
        if (mergedPages.isFinished()) {
            return OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, types, (List<Page>)ImmutableList.of());
        }
        Page page = (Page)mergedPages.getResult();
        org.testng.Assert.assertTrue((boolean)mergedPages.process());
        org.testng.Assert.assertTrue((boolean)mergedPages.isFinished());
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        return OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, types, (List<Page>)ImmutableList.of((Object)page));
    }
}

