/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.catalogserver;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.Session;
import com.facebook.presto.catalogserver.CatalogServerClient;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.CatalogMetadata;
import com.facebook.presto.metadata.DelegatingMetadataManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.transaction.TransactionManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class RemoteMetadataManager
extends DelegatingMetadataManager {
    private final TransactionManager transactionManager;
    private final ObjectMapper objectMapper;
    private final DriftClient<CatalogServerClient> catalogServerClient;

    @Inject
    public RemoteMetadataManager(MetadataManager metadataManager, TransactionManager transactionManager, ObjectMapper objectMapper, DriftClient<CatalogServerClient> catalogServerClient) {
        super(metadataManager);
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.catalogServerClient = Objects.requireNonNull(catalogServerClient, "catalogServerClient is null");
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        String schemaNamesJson = ((CatalogServerClient)this.catalogServerClient.get()).listSchemaNames(this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), catalogName);
        return schemaNamesJson.isEmpty() ? ImmutableList.of() : this.readValue(schemaNamesJson, new TypeReference<List<String>>(){});
    }

    private Optional<TableHandle> getOptionalTableHandle(Session session, QualifiedObjectName table) {
        String tableHandleJson = ((CatalogServerClient)this.catalogServerClient.get()).getTableHandle(this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), table);
        if (!tableHandleJson.isEmpty()) {
            TableHandle tableHandle = this.readValue(tableHandleJson, new TypeReference<TableHandle>(){});
            Optional<CatalogMetadata> catalogMetadata = this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), table.getCatalogName());
            if (catalogMetadata.isPresent()) {
                tableHandle = new TableHandle(tableHandle.getConnectorId(), tableHandle.getConnectorHandle(), catalogMetadata.get().getTransactionHandleFor(tableHandle.getConnectorId()), tableHandle.getLayout());
            }
            return Optional.of(tableHandle);
        }
        return Optional.empty();
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        String tableListJson = ((CatalogServerClient)this.catalogServerClient.get()).listTables(this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), prefix);
        return tableListJson.isEmpty() ? ImmutableList.of() : this.readValue(tableListJson, new TypeReference<List<QualifiedObjectName>>(){});
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        String viewsListJson = ((CatalogServerClient)this.catalogServerClient.get()).listViews(this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), prefix);
        return viewsListJson.isEmpty() ? ImmutableList.of() : this.readValue(viewsListJson, new TypeReference<List<QualifiedObjectName>>(){});
    }

    @Override
    public Map<QualifiedObjectName, ViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        String viewsMapJson = ((CatalogServerClient)this.catalogServerClient.get()).getViews(this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), prefix);
        return viewsMapJson.isEmpty() ? ImmutableMap.of() : this.readValue(viewsMapJson, new TypeReference<Map<QualifiedObjectName, ViewDefinition>>(){});
    }

    @Override
    public List<QualifiedObjectName> getReferencedMaterializedViews(Session session, QualifiedObjectName tableName) {
        String referencedMaterializedViewsListJson = ((CatalogServerClient)this.catalogServerClient.get()).getReferencedMaterializedViews(this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), tableName);
        return referencedMaterializedViewsListJson.isEmpty() ? ImmutableList.of() : this.readValue(referencedMaterializedViewsListJson, new TypeReference<List<QualifiedObjectName>>(){});
    }

    @Override
    public MetadataResolver getMetadataResolver(final Session session) {
        return new MetadataResolver(){

            public boolean catalogExists(String catalogName) {
                return ((CatalogServerClient)RemoteMetadataManager.this.catalogServerClient.get()).catalogExists(RemoteMetadataManager.this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), catalogName);
            }

            public boolean schemaExists(CatalogSchemaName schema) {
                return ((CatalogServerClient)RemoteMetadataManager.this.catalogServerClient.get()).schemaExists(RemoteMetadataManager.this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), schema);
            }

            public boolean tableExists(QualifiedObjectName tableName) {
                return this.getTableHandle(tableName).isPresent();
            }

            public Optional<TableHandle> getTableHandle(QualifiedObjectName tableName) {
                return RemoteMetadataManager.this.getOptionalTableHandle(session, tableName);
            }

            public List<ColumnMetadata> getColumns(TableHandle tableHandle) {
                return RemoteMetadataManager.this.getTableMetadata(session, tableHandle).getColumns();
            }

            public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
                return RemoteMetadataManager.this.getColumnHandles(session, tableHandle);
            }

            public Optional<ViewDefinition> getView(QualifiedObjectName viewName) {
                String viewDefinitionJson = ((CatalogServerClient)RemoteMetadataManager.this.catalogServerClient.get()).getView(RemoteMetadataManager.this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), viewName);
                return viewDefinitionJson.isEmpty() ? Optional.empty() : Optional.of((ViewDefinition)RemoteMetadataManager.this.readValue(viewDefinitionJson, (TypeReference)new TypeReference<ViewDefinition>(){}));
            }

            public Optional<MaterializedViewDefinition> getMaterializedView(QualifiedObjectName viewName) {
                String materializedViewDefinitionJson = ((CatalogServerClient)RemoteMetadataManager.this.catalogServerClient.get()).getMaterializedView(RemoteMetadataManager.this.transactionManager.getTransactionInfo(session.getRequiredTransactionId()), session.toSessionRepresentation(), viewName);
                return materializedViewDefinitionJson.isEmpty() ? Optional.empty() : Optional.of((MaterializedViewDefinition)RemoteMetadataManager.this.readValue(materializedViewDefinitionJson, (TypeReference)new TypeReference<MaterializedViewDefinition>(){}));
            }
        };
    }

    private <T> T readValue(String content, TypeReference<T> valueTypeRef) {
        try {
            return (T)this.objectMapper.readValue(content, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

