/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system.jdbc;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.system.jdbc.FilterUtil;
import com.facebook.presto.connector.system.jdbc.JdbcTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataListing;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControl;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class TableJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "tables");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.createUnboundedVarcharType()).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_type", (Type)VarcharType.createUnboundedVarcharType()).column("remarks", (Type)VarcharType.createUnboundedVarcharType()).column("type_cat", (Type)VarcharType.createUnboundedVarcharType()).column("type_schem", (Type)VarcharType.createUnboundedVarcharType()).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("self_referencing_col_name", (Type)VarcharType.createUnboundedVarcharType()).column("ref_generation", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TableJdbcTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        Optional<String> typeFilter = FilterUtil.stringFilter(constraint, 3);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (String catalog : FilterUtil.filter(MetadataListing.listCatalogs(session, this.metadata, this.accessControl).keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            ImmutableSet views = ImmutableSet.of();
            if (FilterUtil.emptyOrEquals(typeFilter, "VIEW")) {
                views = ImmutableSet.copyOf(MetadataListing.listViews(session, this.metadata, this.accessControl, prefix));
                for (SchemaTableName name : views) {
                    table.addRow(TableJdbcTable.tableRow(catalog, name, "VIEW"));
                }
            }
            if (!FilterUtil.emptyOrEquals(typeFilter, "TABLE")) continue;
            for (SchemaTableName name : MetadataListing.listTables(session, this.metadata, this.accessControl, prefix)) {
                if (views.contains(name)) continue;
                table.addRow(TableJdbcTable.tableRow(catalog, name, "TABLE"));
            }
        }
        return table.build().cursor();
    }

    private static Object[] tableRow(String catalog, SchemaTableName name, String type) {
        return new Object[]{catalog, name.getSchemaName(), name.getTableName(), type, null, null, null, null, null, null};
    }
}

