/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.DoubleRange;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.collect.ImmutableBiMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectorFilterStatsCalculatorService
implements FilterStatsCalculatorService {
    private final FilterStatsCalculator filterStatsCalculator;

    public ConnectorFilterStatsCalculatorService(FilterStatsCalculator filterStatsCalculator) {
        this.filterStatsCalculator = Objects.requireNonNull(filterStatsCalculator, "filterStatsCalculator is null");
    }

    public TableStatistics filterStats(TableStatistics tableStatistics, RowExpression predicate, ConnectorSession session, Map<ColumnHandle, String> columnNames, Map<String, Type> columnTypes) {
        Session filterSession;
        PlanNodeStatsEstimate tableStats = ConnectorFilterStatsCalculatorService.toPlanNodeStats(tableStatistics, columnNames, columnTypes);
        PlanNodeStatsEstimate filteredStats = this.filterStatsCalculator.filterStats(tableStats, predicate, session, filterSession = ((FullConnectorSession)session).getSession());
        if (filteredStats.isOutputRowCountUnknown()) {
            filteredStats = tableStats.mapOutputRowCount(sourceRowCount -> tableStats.getOutputRowCount() * 0.9);
        }
        TableStatistics filteredStatistics = ConnectorFilterStatsCalculatorService.toTableStatistics(filteredStats, (Map<String, ColumnHandle>)ImmutableBiMap.copyOf(columnNames).inverse());
        TableStatistics.Builder filteredStatsWithSize = TableStatistics.builder();
        filteredStatsWithSize.setRowCount(filteredStatistics.getRowCount());
        filteredStatistics.getColumnStatistics().forEach((arg_0, arg_1) -> ((TableStatistics.Builder)filteredStatsWithSize).setColumnStatistics(arg_0, arg_1));
        if (!tableStatistics.getRowCount().isUnknown() && tableStatistics.getRowCount().getValue() == 0.0 || !filteredStatistics.getRowCount().isUnknown() && filteredStatistics.getRowCount().getValue() == 0.0) {
            filteredStatsWithSize.setTotalSize(Estimate.of((double)0.0));
        } else if (!(tableStatistics.getTotalSize().isUnknown() || filteredStatistics.getRowCount().isUnknown() || tableStatistics.getRowCount().isUnknown())) {
            double totalSizeAfterFilter = filteredStatistics.getRowCount().getValue() / tableStatistics.getRowCount().getValue() * tableStatistics.getTotalSize().getValue();
            filteredStatsWithSize.setTotalSize(Estimate.of((double)totalSizeAfterFilter));
        }
        return filteredStatsWithSize.setConfidenceLevel(SourceInfo.ConfidenceLevel.LOW).build();
    }

    private static PlanNodeStatsEstimate toPlanNodeStats(TableStatistics tableStatistics, Map<ColumnHandle, String> columnNames, Map<String, Type> columnTypes) {
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(tableStatistics.getRowCount().getValue());
        for (Map.Entry entry : tableStatistics.getColumnStatistics().entrySet()) {
            String columnName = columnNames.get(entry.getKey());
            VariableReferenceExpression variable = new VariableReferenceExpression(Optional.empty(), columnName, columnTypes.get(columnName));
            builder.addVariableStatistics(variable, StatsUtil.toVariableStatsEstimate(tableStatistics, (ColumnStatistics)entry.getValue()));
        }
        return builder.build();
    }

    private static TableStatistics toTableStatistics(PlanNodeStatsEstimate planNodeStats, Map<String, ColumnHandle> columnByName) {
        TableStatistics.Builder builder = TableStatistics.builder();
        if (planNodeStats.isOutputRowCountUnknown()) {
            builder.setRowCount(Estimate.unknown());
            return builder.build();
        }
        double rowCount = planNodeStats.getOutputRowCount();
        builder.setRowCount(Estimate.of((double)rowCount));
        for (Map.Entry<VariableReferenceExpression, VariableStatsEstimate> entry : planNodeStats.getVariableStatistics().entrySet()) {
            builder.setColumnStatistics(columnByName.get(entry.getKey().getName()), ConnectorFilterStatsCalculatorService.toColumnStatistics(entry.getValue(), rowCount));
        }
        return builder.setConfidenceLevel(planNodeStats.confidenceLevel()).build();
    }

    private static ColumnStatistics toColumnStatistics(VariableStatsEstimate variableStatsEstimate, double rowCount) {
        if (variableStatsEstimate.isUnknown()) {
            return ColumnStatistics.empty();
        }
        double nullsFractionDouble = variableStatsEstimate.getNullsFraction();
        double nonNullRowsCount = rowCount * (1.0 - nullsFractionDouble);
        ColumnStatistics.Builder builder = ColumnStatistics.builder();
        if (!Double.isNaN(nullsFractionDouble)) {
            builder.setNullsFraction(Estimate.of((double)nullsFractionDouble));
        }
        if (!Double.isNaN(variableStatsEstimate.getDistinctValuesCount())) {
            builder.setDistinctValuesCount(Estimate.of((double)variableStatsEstimate.getDistinctValuesCount()));
        }
        if (!Double.isNaN(variableStatsEstimate.getAverageRowSize())) {
            builder.setDataSize(Estimate.of((double)(variableStatsEstimate.getAverageRowSize() * nonNullRowsCount)));
        }
        if (!Double.isNaN(variableStatsEstimate.getLowValue()) && !Double.isNaN(variableStatsEstimate.getHighValue())) {
            builder.setRange(new DoubleRange(variableStatsEstimate.getLowValue(), variableStatsEstimate.getHighValue()));
        }
        if (variableStatsEstimate.getHistogram().isPresent()) {
            builder.setHistogram(variableStatsEstimate.getHistogram());
        }
        return builder.build();
    }
}

