/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Optional;

public class ExchangeStatsRule
extends SimpleStatsRule<ExchangeNode> {
    private static final Pattern<ExchangeNode> PATTERN = Patterns.exchange();

    public ExchangeStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<ExchangeNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(ExchangeNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        Optional<Object> estimate = Optional.empty();
        double totalSize = 0.0;
        SourceInfo.ConfidenceLevel confidenceLevel = SourceInfo.ConfidenceLevel.FACT;
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = node.getSources().get(i);
            PlanNodeStatsEstimate sourceStats = statsProvider.getStats(source);
            totalSize += sourceStats.getOutputSizeInBytes();
            if (sourceStats.confidenceLevel().ordinal() < confidenceLevel.ordinal()) {
                confidenceLevel = sourceStats.confidenceLevel();
            }
            PlanNodeStatsEstimate sourceStatsWithMappedSymbols = this.mapToOutputVariables(sourceStats, node.getInputs().get(i), node.getOutputVariables());
            if (estimate.isPresent()) {
                PlanNodeStatsEstimateMath calculator = new PlanNodeStatsEstimateMath(SystemSessionProperties.shouldOptimizerUseHistograms(session));
                estimate = Optional.of(calculator.addStatsAndMaxDistinctValues((PlanNodeStatsEstimate)estimate.get(), sourceStatsWithMappedSymbols));
                continue;
            }
            estimate = Optional.of(sourceStatsWithMappedSymbols);
        }
        Verify.verify((boolean)estimate.isPresent());
        return Optional.of(PlanNodeStatsEstimate.buildFrom((PlanNodeStatsEstimate)estimate.get()).setTotalSize(totalSize).setConfidence(confidenceLevel).build());
    }

    private PlanNodeStatsEstimate mapToOutputVariables(PlanNodeStatsEstimate estimate, List<VariableReferenceExpression> inputs, List<VariableReferenceExpression> outputs) {
        Preconditions.checkArgument((inputs.size() == outputs.size() ? 1 : 0) != 0, (Object)"Input symbols count does not match output symbols count");
        PlanNodeStatsEstimate.Builder mapped = PlanNodeStatsEstimate.builder().setOutputRowCount(estimate.getOutputRowCount());
        for (int i = 0; i < inputs.size(); ++i) {
            mapped.addVariableStatistics(outputs.get(i), estimate.getVariableStatistics(inputs.get(i)));
        }
        return mapped.build();
    }
}

